/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf;

import com.alee.laf.DefaultLayoutStyle;
import java.awt.Container;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.plaf.UIResource;

public class WebLayoutStyle
extends DefaultLayoutStyle {
    private static WebLayoutStyle instance;

    public static WebLayoutStyle getInstance() {
        if (instance == null) {
            instance = new WebLayoutStyle();
        }
        return instance;
    }

    @Override
    public int getPreferredGap(JComponent component1, JComponent component2, LayoutStyle.ComponentPlacement type, int position, Container container) {
        super.getPreferredGap(component1, component2, type, position, container);
        int offset = 0;
        switch (type) {
            case INDENT: {
                if (position == 3 || position == 7) {
                    int indent = this.getIndent(component1, position);
                    if (indent > 0) {
                        return indent;
                    }
                    return 12;
                }
            }
            case RELATED: {
                if (component1.getUIClassID().equals("ToggleButtonUI") && component2.getUIClassID().equals("ToggleButtonUI")) {
                    ButtonModel sourceModel = ((JToggleButton)component1).getModel();
                    ButtonModel targetModel = ((JToggleButton)component2).getModel();
                    if (sourceModel instanceof DefaultButtonModel && targetModel instanceof DefaultButtonModel && ((DefaultButtonModel)sourceModel).getGroup() == ((DefaultButtonModel)targetModel).getGroup() && ((DefaultButtonModel)sourceModel).getGroup() != null) {
                        return 2;
                    }
                    return 5;
                }
                offset = 6;
                break;
            }
            case UNRELATED: {
                offset = 12;
            }
        }
        if (this.isLabelAndNonlabel(component1, component2, position)) {
            return this.getButtonGap(component1, component2, position, offset + 6);
        }
        return this.getButtonGap(component1, component2, position, offset);
    }

    @Override
    public int getContainerGap(JComponent component2, int position, Container container) {
        super.getContainerGap(component2, position, container);
        return this.getButtonGap(component2, position, 12 - this.getButtonAdjustment(component2, position));
    }

    @Override
    protected int getButtonGap(JComponent source, JComponent target, int position, int offset) {
        if ((offset = super.getButtonGap(source, target, position, offset)) > 0) {
            int buttonAdjustment = this.getButtonAdjustment(source, position);
            if (buttonAdjustment == 0) {
                buttonAdjustment = this.getButtonAdjustment(target, this.flipDirection(position));
            }
            offset -= buttonAdjustment;
        }
        if (offset < 0) {
            return 0;
        }
        return offset;
    }

    private int getButtonAdjustment(JComponent source, int edge) {
        String classID = source.getUIClassID();
        if (classID.equals("ButtonUI") || classID.equals("ToggleButtonUI") ? (edge == 3 || edge == 5) && source.getBorder() instanceof UIResource : edge == 5 && (classID.equals("RadioButtonUI") || classID.equals("CheckBoxUI"))) {
            return 1;
        }
        return 0;
    }
}

