/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Supplier;
import com.alee.laf.ControlType;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SystemUtils;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.synth.Region;
import org.slf4j.LoggerFactory;

public final class NativeFonts {
    private static boolean warningsEnabled = true;
    private static final String TAHOMA = "Tahoma";
    private static final String SEGOE_UI = "Segoe UI";
    private static final String LUCIDA_GRANDE = "Lucida Grande";
    private static final String SANS_SERIF = "SansSerif";
    private static boolean useNativeFonts = true;
    private static volatile Boolean gtkAvailable = null;
    private static volatile Boolean gtkStyleFactoryAvailable = null;
    private static Object gtkStyleFactory = null;
    private static volatile Boolean defaultGTKFontAvailable = null;
    private static Font defaultGTKFont = null;

    public static void setWarningsEnabled(boolean enabled) {
        warningsEnabled = enabled;
    }

    public static boolean isUseNativeFonts() {
        return useNativeFonts;
    }

    public static void setUseNativeFonts(boolean useNativeFonts) {
        NativeFonts.useNativeFonts = useNativeFonts;
    }

    @NotNull
    public static FontUIResource get(@NotNull ControlType control2) {
        FontUIResource font;
        block0 : switch (SystemUtils.getOsType()) {
            case WINDOWS: {
                switch (control2) {
                    default: {
                        font = NativeFonts.getWindowsFont("win.defaultGUI.font", new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.TAHOMA, 0, 12);
                            }
                        });
                        break block0;
                    }
                    case TEXT: {
                        font = NativeFonts.getWindowsFont("win.defaultGUI.font", new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.TAHOMA, 0, 12);
                            }
                        });
                        break block0;
                    }
                    case TOOLTIP: {
                        font = NativeFonts.getWindowsFont("win.tooltip.font", new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.SEGOE_UI, 0, 12);
                            }
                        });
                        break block0;
                    }
                    case MESSAGE: {
                        font = NativeFonts.getWindowsFont("win.messagebox.font", new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.SEGOE_UI, 0, 13);
                            }
                        });
                        break block0;
                    }
                    case MENU: {
                        font = NativeFonts.getWindowsFont("win.menu.font", new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.SEGOE_UI, 0, 12);
                            }
                        });
                        break block0;
                    }
                    case MENU_SMALL: {
                        font = NativeFonts.getWindowsFont("win.menu.font", new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.SEGOE_UI, 0, 12);
                            }
                        });
                        break block0;
                    }
                    case WINDOW: 
                }
                font = NativeFonts.getWindowsFont("win.frame.captionFont", new Supplier<FontUIResource>(){

                    @Override
                    public FontUIResource get() {
                        return new FontUIResource(NativeFonts.SEGOE_UI, 0, 14);
                    }
                });
                break;
            }
            case MAC: {
                switch (control2) {
                    default: {
                        font = NativeFonts.getMacOSFont("getControlTextFont", new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.LUCIDA_GRANDE, 0, 13);
                            }
                        });
                        break block0;
                    }
                    case TEXT: {
                        font = NativeFonts.getMacOSFont("getControlTextFont", new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.LUCIDA_GRANDE, 0, 13);
                            }
                        });
                        break block0;
                    }
                    case TOOLTIP: {
                        font = NativeFonts.getMacOSFont("getControlTextSmallFont", new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.LUCIDA_GRANDE, 0, 11);
                            }
                        });
                        break block0;
                    }
                    case MESSAGE: {
                        font = NativeFonts.getMacOSFont("getAlertHeaderFont", new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.LUCIDA_GRANDE, 0, 11);
                            }
                        });
                        break block0;
                    }
                    case MENU: {
                        font = NativeFonts.getMacOSFont("getMenuFont", new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.LUCIDA_GRANDE, 0, 14);
                            }
                        });
                        break block0;
                    }
                    case MENU_SMALL: {
                        font = NativeFonts.getMacOSFont("getMenuFont", new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.LUCIDA_GRANDE, 0, 13);
                            }
                        });
                        break block0;
                    }
                    case WINDOW: 
                }
                font = NativeFonts.getMacOSFont("getMenuFont", new Supplier<FontUIResource>(){

                    @Override
                    public FontUIResource get() {
                        return new FontUIResource(NativeFonts.LUCIDA_GRANDE, 1, 14);
                    }
                });
                break;
            }
            case UNIX: 
            case SOLARIS: {
                switch (control2) {
                    default: {
                        font = NativeFonts.getUnixFont(Region.BUTTON, new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.SANS_SERIF, 0, 12);
                            }
                        });
                        break block0;
                    }
                    case TEXT: {
                        font = NativeFonts.getUnixFont(Region.TEXT_FIELD, new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.SANS_SERIF, 0, 12);
                            }
                        });
                        break block0;
                    }
                    case TOOLTIP: {
                        font = NativeFonts.getUnixFont(Region.TOOL_TIP, new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.SANS_SERIF, 0, 12);
                            }
                        });
                        break block0;
                    }
                    case MESSAGE: {
                        font = NativeFonts.getUnixFont(Region.OPTION_PANE, new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.SANS_SERIF, 0, 12);
                            }
                        });
                        break block0;
                    }
                    case MENU: {
                        font = NativeFonts.getUnixFont(Region.MENU_ITEM, new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.SANS_SERIF, 0, 12);
                            }
                        });
                        break block0;
                    }
                    case MENU_SMALL: {
                        font = NativeFonts.getUnixFont(Region.MENU_ITEM_ACCELERATOR, new Supplier<FontUIResource>(){

                            @Override
                            public FontUIResource get() {
                                return new FontUIResource(NativeFonts.SANS_SERIF, 0, 11);
                            }
                        });
                        break block0;
                    }
                    case WINDOW: 
                }
                font = NativeFonts.getUnixFont(Region.INTERNAL_FRAME_TITLE_PANE, new Supplier<FontUIResource>(){

                    @Override
                    public FontUIResource get() {
                        return new FontUIResource(NativeFonts.SANS_SERIF, 1, 12);
                    }
                });
                break;
            }
            default: {
                switch (control2) {
                    default: {
                        font = new FontUIResource(SANS_SERIF, 0, 12);
                        break block0;
                    }
                    case TEXT: {
                        font = new FontUIResource(SANS_SERIF, 0, 12);
                        break block0;
                    }
                    case TOOLTIP: {
                        font = new FontUIResource(SANS_SERIF, 0, 12);
                        break block0;
                    }
                    case MESSAGE: {
                        font = new FontUIResource(SANS_SERIF, 0, 12);
                        break block0;
                    }
                    case MENU: {
                        font = new FontUIResource(SANS_SERIF, 0, 12);
                        break block0;
                    }
                    case MENU_SMALL: {
                        font = new FontUIResource(SANS_SERIF, 0, 11);
                        break block0;
                    }
                    case WINDOW: 
                }
                font = new FontUIResource(SANS_SERIF, 1, 12);
            }
        }
        return font;
    }

    @NotNull
    private static FontUIResource getWindowsFont(@NotNull String fontKey, @NotNull Supplier<FontUIResource> fallback) {
        Font font;
        block26: {
            String msg;
            block25: {
                if (NativeFonts.isUseNativeFonts()) {
                    try {
                        Object nativeFont = Toolkit.getDefaultToolkit().getDesktopProperty(fontKey);
                        if (nativeFont != null) {
                            font = (Font)nativeFont;
                            break block25;
                        }
                        if (warningsEnabled) {
                            msg = "Unable to retrieve native Windows font: %s";
                            LoggerFactory.getLogger(NativeFonts.class).error(String.format("Unable to retrieve native Windows font: %s", fontKey));
                        }
                        font = fallback.get();
                    }
                    catch (Exception e) {
                        if (warningsEnabled) {
                            msg = "Unable to retrieve native Windows font: %s";
                            LoggerFactory.getLogger(NativeFonts.class).error(String.format("Unable to retrieve native Windows font: %s", fontKey), e);
                        }
                        font = fallback.get();
                    }
                } else {
                    font = fallback.get();
                }
            }
            if (SystemUtils.isJava7orAbove()) {
                try {
                    Class fontUtilities = ReflectUtils.getClass("sun.font.FontUtilities");
                    try {
                        if (((Boolean)ReflectUtils.callStaticMethod(fontUtilities, "fontSupportsDefaultEncoding", font)).booleanValue()) break block26;
                        try {
                            font = (Font)ReflectUtils.callStaticMethod(fontUtilities, "getCompositeFontUIResource", font);
                        }
                        catch (Exception e) {
                            if (warningsEnabled) {
                                String msg2 = "Unable to retrieve composite Font";
                                LoggerFactory.getLogger(NativeFonts.class).error("Unable to retrieve composite Font", e);
                            }
                            break block26;
                        }
                    }
                    catch (Exception e) {
                        if (warningsEnabled) {
                            String msg3 = "Unable to check Font default encoding support";
                            LoggerFactory.getLogger(NativeFonts.class).error("Unable to check Font default encoding support", e);
                        }
                        break block26;
                    }
                }
                catch (ClassNotFoundException e) {
                    if (warningsEnabled) {
                        msg = "Unable to access sun.font.FontUtilities";
                        LoggerFactory.getLogger(NativeFonts.class).error("Unable to access sun.font.FontUtilities", e);
                    }
                    break block26;
                }
            }
            try {
                Class fontManager = ReflectUtils.getClass("sun.font.FontManager");
                try {
                    if (((Boolean)ReflectUtils.callStaticMethod(fontManager, "fontSupportsDefaultEncoding", font)).booleanValue()) break block26;
                    try {
                        font = (Font)ReflectUtils.callStaticMethod(fontManager, "getCompositeFontUIResource", font);
                    }
                    catch (Exception e) {
                        if (warningsEnabled) {
                            String msg4 = "Unable to retrieve composite Font";
                            LoggerFactory.getLogger(NativeFonts.class).error("Unable to retrieve composite Font", e);
                        }
                    }
                }
                catch (Exception e) {
                    if (warningsEnabled) {
                        String msg5 = "Unable to check Font default encoding support";
                        LoggerFactory.getLogger(NativeFonts.class).error("Unable to check Font default encoding support", e);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                if (!warningsEnabled) break block26;
                msg = "Unable to access sun.font.FontManager";
                LoggerFactory.getLogger(NativeFonts.class).error("Unable to access sun.font.FontManager", e);
            }
        }
        FontUIResource fontUIResource = font instanceof FontUIResource ? (FontUIResource)font : new FontUIResource(font);
        return fontUIResource;
    }

    @NotNull
    private static FontUIResource getMacOSFont(@NotNull String fontMethodName, @NotNull Supplier<FontUIResource> fallback) {
        Font font;
        block7: {
            if (NativeFonts.isUseNativeFonts()) {
                try {
                    Object nativeFont = ReflectUtils.callStaticMethod("com.apple.laf.AquaFonts", fontMethodName, new Object[0]);
                    if (nativeFont != null) {
                        font = (Font)nativeFont;
                        break block7;
                    }
                    if (warningsEnabled) {
                        String msg = "Unable to retrieve native Mac OS X font using method: com.apple.laf.AquaFonts.%s()";
                        LoggerFactory.getLogger(NativeFonts.class).error(String.format("Unable to retrieve native Mac OS X font using method: com.apple.laf.AquaFonts.%s()", fontMethodName));
                    }
                    font = fallback.get();
                }
                catch (Exception e) {
                    if (warningsEnabled) {
                        String msg = "Unable to retrieve native Mac OS X font using method: com.apple.laf.AquaFonts.%s()";
                        LoggerFactory.getLogger(NativeFonts.class).error(String.format("Unable to retrieve native Mac OS X font using method: com.apple.laf.AquaFonts.%s()", fontMethodName), e);
                    }
                    font = fallback.get();
                }
            } else {
                font = fallback.get();
            }
        }
        FontUIResource fontUIResource = font instanceof FontUIResource ? (FontUIResource)font : new FontUIResource(font);
        return fontUIResource;
    }

    @NotNull
    private static FontUIResource getUnixFont(@NotNull Region region, @NotNull Supplier<FontUIResource> fallback) {
        Font font;
        block8: {
            Object factory;
            font = null;
            if (NativeFonts.isUseNativeFonts() && NativeFonts.isGTKAvailable() && (factory = NativeFonts.getGTKStyleFactory()) != null) {
                try {
                    Object style = ReflectUtils.callMethod(factory, "getStyle", null, region);
                    if (style == null) break block8;
                    try {
                        if (SystemUtils.isJava9orAbove() || SystemUtils.isJavaVersionOrAbove(1.8, 211)) {
                            font = (Font)ReflectUtils.callMethod(style, "getDefaultFont", new Object[0]);
                            break block8;
                        }
                        if (SystemUtils.isJava7orAbove()) {
                            Object[] args = new Object[]{null};
                            font = (Font)ReflectUtils.callMethod(style, "getFontForState", args);
                            break block8;
                        }
                        Object[] args = new Object[]{null, region, 1};
                        font = (Font)ReflectUtils.callMethod(style, "getFontForState", args);
                    }
                    catch (Exception e) {
                        String msg = "Unable to retrieve region Font: %s";
                        LoggerFactory.getLogger(NativeFonts.class).error(String.format("Unable to retrieve region Font: %s", region));
                    }
                }
                catch (Exception e) {
                    String msg = "Unable to retrieve region style: %s";
                    LoggerFactory.getLogger(NativeFonts.class).error(String.format("Unable to retrieve region style: %s", region));
                }
            }
        }
        if (font == null) {
            font = fallback.get();
        }
        FontUIResource fontUIResource = font instanceof FontUIResource ? (FontUIResource)font : new FontUIResource(font);
        return fontUIResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isGTKAvailable() {
        if (gtkAvailable != null) return gtkAvailable;
        Class<NativeFonts> clazz = NativeFonts.class;
        synchronized (NativeFonts.class) {
            if (gtkAvailable != null) return gtkAvailable;
            if (SystemUtils.isJava7orAbove()) {
                try {
                    gtkAvailable = (Boolean)ReflectUtils.callMethod(Toolkit.getDefaultToolkit(), "isNativeGTKAvailable", new Object[0]);
                    if (!gtkAvailable.booleanValue()) return gtkAvailable;
                    try {
                        gtkAvailable = (Boolean)ReflectUtils.callMethod(Toolkit.getDefaultToolkit(), "loadGTK", new Object[0]);
                    }
                    catch (Exception e) {
                        String msg = "Unable to load GTK libraries";
                        LoggerFactory.getLogger(NativeFonts.class).error("Unable to load GTK libraries");
                        gtkAvailable = false;
                    }
                }
                catch (Exception e) {
                    String msg = "Unable to check GTK availability";
                    LoggerFactory.getLogger(NativeFonts.class).error("Unable to check GTK availability");
                    gtkAvailable = false;
                }
            } else {
                try {
                    gtkAvailable = (Boolean)ReflectUtils.callMethod(Toolkit.getDefaultToolkit(), "checkGTK", new Object[0]);
                }
                catch (Exception e) {
                    String msg = "Unable to check GTK availability";
                    LoggerFactory.getLogger(NativeFonts.class).error("Unable to check GTK availability");
                    gtkAvailable = false;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return gtkAvailable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static Object getGTKStyleFactory() {
        if (gtkStyleFactoryAvailable != null) return gtkStyleFactory;
        Class<NativeFonts> clazz = NativeFonts.class;
        synchronized (NativeFonts.class) {
            if (gtkStyleFactoryAvailable != null) return gtkStyleFactory;
            try {
                gtkStyleFactory = ReflectUtils.createInstance("com.sun.java.swing.plaf.gtk.GTKStyleFactory", new Object[0]);
                Font defaultGTKFont = NativeFonts.getDefaultGTKFont();
                if (defaultGTKFont != null) {
                    try {
                        ReflectUtils.callMethod(gtkStyleFactory, "initStyles", defaultGTKFont);
                        gtkStyleFactoryAvailable = true;
                    }
                    catch (Exception e) {
                        String msg = "Unable to initialize GTKStyleFactory styles";
                        LoggerFactory.getLogger(NativeFonts.class).error("Unable to initialize GTKStyleFactory styles");
                        gtkStyleFactory = null;
                        gtkStyleFactoryAvailable = false;
                    }
                } else {
                    gtkStyleFactory = null;
                    gtkStyleFactoryAvailable = false;
                }
            }
            catch (Exception e) {
                String msg = "Unable to instantiate GTK style factory";
                LoggerFactory.getLogger(NativeFonts.class).error("Unable to instantiate GTK style factory");
                gtkStyleFactory = null;
                gtkStyleFactoryAvailable = false;
            }
            return gtkStyleFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static Font getDefaultGTKFont() {
        if (defaultGTKFontAvailable != null) return defaultGTKFont;
        Class<NativeFonts> clazz = NativeFonts.class;
        synchronized (NativeFonts.class) {
            if (defaultGTKFontAvailable != null) return defaultGTKFont;
            try {
                Object fontName = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Gtk/FontName");
                if (!(fontName instanceof String)) {
                    Class ec = ReflectUtils.getClass("com.sun.java.swing.plaf.gtk.GTKEngine");
                    Object engine = ReflectUtils.getStaticFieldValue(ec, "INSTANCE");
                    Class settings2 = ReflectUtils.getInnerClass(ec, "Settings");
                    Object fontKey = ReflectUtils.getStaticFieldValue(settings2, "GTK_FONT_NAME");
                    fontName = ReflectUtils.callMethod(engine, "getSetting", fontKey);
                    if (!(fontName instanceof String)) {
                        fontName = "SansSerif 12";
                    }
                }
                defaultGTKFont = (Font)ReflectUtils.callStaticMethod("com.sun.java.swing.plaf.gtk.PangoFonts", "lookupFont", fontName);
                defaultGTKFontAvailable = true;
            }
            catch (Exception e) {
                String msg = "Unable retrieve default GTK font";
                LoggerFactory.getLogger(NativeFonts.class).error("Unable retrieve default GTK font");
                defaultGTKFont = null;
                defaultGTKFontAvailable = false;
            }
            return defaultGTKFont;
        }
    }
}

