/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf;

import com.alee.api.annotations.NotNull;
import com.alee.laf.WebLookAndFeel;
import com.alee.utils.CoreSwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventPostProcessor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;

public class AltProcessor
implements KeyEventPostProcessor {
    private static boolean altKeyPressed = false;
    private static boolean menuCanceledOnPress = false;
    private static JRootPane root = null;
    private static Window winAncestor = null;

    @Override
    public boolean postProcessKeyEvent(@NotNull KeyEvent ev) {
        if (ev.isConsumed()) {
            return false;
        }
        if (ev.getKeyCode() == 18) {
            root = SwingUtilities.getRootPane(ev.getComponent());
            Window window = winAncestor = root == null ? null : CoreSwingUtils.getWindowAncestor(root);
            if (ev.getID() == 401) {
                if (!altKeyPressed) {
                    this.altPressed(ev);
                }
                altKeyPressed = true;
                return true;
            }
            if (ev.getID() == 402) {
                if (altKeyPressed) {
                    this.altReleased();
                } else {
                    MenuSelectionManager msm = MenuSelectionManager.defaultManager();
                    MenuElement[] path = msm.getSelectedPath();
                    if (path.length <= 0) {
                        WebLookAndFeel.setMnemonicHidden(true);
                        this.repaintMnemonicsInWindow(winAncestor);
                    }
                }
                altKeyPressed = false;
            }
            root = null;
            winAncestor = null;
        } else {
            altKeyPressed = false;
        }
        return false;
    }

    private void altPressed(@NotNull KeyEvent ev) {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        MenuElement[] path = msm.getSelectedPath();
        if (path.length > 0 && !(path[0] instanceof ComboPopup)) {
            msm.clearSelectedPath();
            menuCanceledOnPress = true;
            ev.consume();
        } else if (path.length > 0) {
            menuCanceledOnPress = false;
            WebLookAndFeel.setMnemonicHidden(false);
            this.repaintMnemonicsInWindow(winAncestor);
            ev.consume();
        } else {
            JMenu menu;
            JMenuBar mbar;
            menuCanceledOnPress = false;
            WebLookAndFeel.setMnemonicHidden(false);
            this.repaintMnemonicsInWindow(winAncestor);
            JMenuBar jMenuBar = mbar = root != null ? root.getJMenuBar() : null;
            if (mbar == null && winAncestor instanceof JFrame) {
                mbar = ((JFrame)winAncestor).getJMenuBar();
            }
            JMenu jMenu = menu = mbar != null ? mbar.getMenu(0) : null;
            if (menu != null) {
                ev.consume();
            }
        }
    }

    private void altReleased() {
        if (menuCanceledOnPress) {
            WebLookAndFeel.setMnemonicHidden(true);
            this.repaintMnemonicsInWindow(winAncestor);
        } else {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            if (msm.getSelectedPath().length == 0) {
                JMenu menu;
                JMenuBar mbar;
                JMenuBar jMenuBar = mbar = root != null ? root.getJMenuBar() : null;
                if (mbar == null && winAncestor instanceof JFrame) {
                    mbar = ((JFrame)winAncestor).getJMenuBar();
                }
                JMenu jMenu = menu = mbar != null ? mbar.getMenu(0) : null;
                if (menu != null) {
                    MenuElement[] path = new MenuElement[]{mbar, menu};
                    msm.setSelectedPath(path);
                } else if (!WebLookAndFeel.isMnemonicHidden()) {
                    WebLookAndFeel.setMnemonicHidden(true);
                    this.repaintMnemonicsInWindow(winAncestor);
                }
            } else if (msm.getSelectedPath()[0] instanceof ComboPopup) {
                WebLookAndFeel.setMnemonicHidden(true);
                this.repaintMnemonicsInWindow(winAncestor);
            }
        }
    }

    private void repaintMnemonicsInWindow(Window w) {
        if (w != null && w.isShowing()) {
            Window[] ownedWindows;
            for (Window ownedWindow : ownedWindows = w.getOwnedWindows()) {
                this.repaintMnemonicsInWindow(ownedWindow);
            }
            this.repaintMnemonicsInContainer(w);
        }
    }

    private void repaintMnemonicsInContainer(Container cont) {
        for (int i = 0; i < cont.getComponentCount(); ++i) {
            Component c = cont.getComponent(i);
            if (c == null || !c.isVisible()) continue;
            if (c instanceof AbstractButton && ((AbstractButton)c).getMnemonic() != 0) {
                c.repaint();
                continue;
            }
            if (c instanceof JLabel && ((JLabel)c).getDisplayedMnemonic() != 0) {
                c.repaint();
                continue;
            }
            if (!(c instanceof Container)) continue;
            this.repaintMnemonicsInContainer((Container)c);
        }
    }
}

