/*
 * Decompiled with CFR 0.152.
 */
package com.alee.graphics.shapes;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class RelativeGeneralPath
implements Shape,
Cloneable,
Serializable {
    protected final Rectangle bounds;
    protected final boolean ltr;
    protected final GeneralPath shape;

    public RelativeGeneralPath(Rectangle bounds) {
        this(bounds, true);
    }

    public RelativeGeneralPath(Rectangle bounds, boolean ltr) {
        this.bounds = bounds;
        this.ltr = ltr;
        this.shape = new GeneralPath(0);
    }

    public final synchronized void moveTo(float x, float y) {
        this.shape.moveTo((float)this.bounds.x + this.orientX(x), (float)this.bounds.y + y);
    }

    public final synchronized void lineTo(float x, float y) {
        this.shape.lineTo((float)this.bounds.x + this.orientX(x), (float)this.bounds.y + y);
    }

    public final synchronized void quadTo(float x1, float y1, float x2, float y2) {
        this.shape.quadTo((float)this.bounds.x + this.orientX(x1), (float)this.bounds.y + y1, (float)this.bounds.x + this.orientX(x2), (float)this.bounds.y + y2);
    }

    public final synchronized void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.shape.curveTo((float)this.bounds.x + this.orientX(x1), (float)this.bounds.y + y1, (float)this.bounds.x + this.orientX(x2), (float)this.bounds.y + y2, (float)this.bounds.x + this.orientX(x3), (float)this.bounds.y + y3);
    }

    public final synchronized void closePath() {
        this.shape.closePath();
    }

    protected float orientX(float x) {
        return this.ltr ? x : (float)this.bounds.width - x;
    }

    @Override
    public Rectangle getBounds() {
        return this.shape.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.shape.getBounds2D();
    }

    @Override
    public boolean contains(double x, double y) {
        return this.shape.contains(x, y);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.shape.contains(p);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.shape.intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.shape.intersects(r);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.shape.contains(x, y, w, h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.shape.contains(r);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.shape.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.shape.getPathIterator(at, flatness);
    }
}

