/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.utils.UtilityException;

public enum PopOverDirection {
    up,
    down,
    left,
    right;


    public PopOverDirection[] getPriority() {
        switch (this) {
            case up: {
                return new PopOverDirection[]{up, down, right, left};
            }
            case down: {
                return new PopOverDirection[]{down, up, right, left};
            }
            case left: {
                return new PopOverDirection[]{left, right, down, up};
            }
            case right: {
                return new PopOverDirection[]{right, left, down, up};
            }
        }
        throw new UtilityException("Unsupported PopOverDirection: " + (Object)((Object)this));
    }

    public int getCornerSide(boolean ltr) {
        switch (this) {
            case up: {
                return 3;
            }
            case down: {
                return 1;
            }
            case left: {
                return ltr ? 4 : 2;
            }
            case right: {
                return ltr ? 2 : 4;
            }
        }
        throw new UtilityException("Unsupported PopOverDirection: " + (Object)((Object)this));
    }
}

