/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.tree.ExTreeDataProvider;
import com.alee.extended.tree.FilterableNodes;
import com.alee.extended.tree.SortableNodes;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.WebTreeModel;
import com.alee.laf.tree.WebTreeNode;
import com.alee.utils.CollectionUtils;
import com.alee.utils.compare.Filter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ExTreeModel<N extends UniqueNode>
extends WebTreeModel<N>
implements FilterableNodes<N>,
SortableNodes<N> {
    @NotNull
    protected final ExTreeDataProvider<N> dataProvider;
    protected transient Map<String, List<N>> rawNodeChildrenCache;
    protected transient Map<String, N> nodeById;
    protected transient Map<String, String> parentById;
    protected transient WebTree<N> tree;
    @Nullable
    protected transient N rootNode;
    @Nullable
    protected transient Filter<N> filter;
    @Nullable
    protected transient Comparator<N> comparator;

    public ExTreeModel(@NotNull ExTreeDataProvider<N> dataProvider) {
        super(null);
        this.dataProvider = dataProvider;
    }

    @NotNull
    public ExTreeDataProvider<N> getDataProvider() {
        return this.dataProvider;
    }

    public void install(@NotNull WebTree<N> tree) {
        WebLookAndFeel.checkEventDispatchThread();
        this.rawNodeChildrenCache = new HashMap<String, List<N>>(10);
        this.nodeById = new HashMap<String, N>(50);
        this.parentById = new HashMap<String, String>(50);
        this.tree = tree;
        this.rootNode = this.loadRootNode();
        this.loadTreeData(this.getRoot());
    }

    public void uninstall(@NotNull WebTree<N> tree) {
        WebLookAndFeel.checkEventDispatchThread();
        this.rootNode = null;
        this.tree = null;
        this.parentById = null;
        this.nodeById = null;
        this.rawNodeChildrenCache = null;
    }

    public boolean isInstalled() {
        return this.tree != null;
    }

    protected void checkInstalled() {
        if (!this.isInstalled()) {
            throw new IllegalStateException("This operation cannot be performed before model is installed into WebAsyncTree");
        }
    }

    @NotNull
    protected N loadRootNode() {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        N rootNode = this.getDataProvider().getRoot();
        this.cacheNodeById(rootNode);
        this.cacheParentId(rootNode, null);
        return rootNode;
    }

    protected void loadTreeData(@NotNull N parent) {
        List<N> children = this.getDataProvider().getChildren(parent);
        this.setRawChildren(parent, children);
        this.cacheNodesById(children);
        this.cacheParentId(children, ((UniqueNode)parent).getId());
        List<N> displayedChildren = this.filterAndSort(parent, children);
        if (displayedChildren.size() > 0) {
            super.insertNodesInto(displayedChildren, parent, 0);
        }
        for (UniqueNode child : children) {
            this.loadTreeData(child);
        }
    }

    @Override
    @NotNull
    public N getRoot() {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        if (this.rootNode == null) {
            throw new RuntimeException("Root node is not available");
        }
        return this.rootNode;
    }

    @NotNull
    public N getChild(@NotNull Object parent, int index) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        return (N)((UniqueNode)super.getChild(parent, index));
    }

    @Override
    public void reload(@NotNull TreeNode node) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        UniqueNode reloadedNode = (UniqueNode)node;
        this.tree.cancelEditing();
        this.clearRawChildren(reloadedNode, false);
        reloadedNode.removeAllChildren();
        this.loadTreeData(reloadedNode);
        super.reload(reloadedNode);
    }

    @Override
    public void valueForPathChanged(@NotNull TreePath path, @Nullable Object newValue) {
        TreeNode parent;
        this.checkInstalled();
        super.valueForPathChanged(path, newValue);
        UniqueNode node = (UniqueNode)this.tree.getNodeForPath(path);
        if (node != null && (parent = node.getParent()) != null) {
            this.filterAndSort((UniqueNode)parent, false);
        }
    }

    public void setChildNodes(@NotNull N parent, @NotNull List<N> children) {
        this.removeNodesFromParent(parent);
        this.addChildNodes(parent, children);
    }

    public void addChildNode(@NotNull N parent, @NotNull N child) {
        this.insertNodeInto((MutableTreeNode)child, (MutableTreeNode)parent, this.getRawChildrenCount(parent));
    }

    public void addChildNodes(@NotNull N parent, @NotNull List<N> children) {
        this.insertNodesInto(children, parent, this.getRawChildrenCount(parent));
    }

    @Override
    public void insertNodeInto(@NotNull MutableTreeNode child, @NotNull MutableTreeNode parent, int index) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        UniqueNode childNode = (UniqueNode)child;
        UniqueNode parentNode = (UniqueNode)parent;
        this.addRawChild(parentNode, childNode, index);
        this.cacheNodeById(childNode);
        this.cacheParentId(childNode, parentNode.getId());
        this.clearRawChildren(childNode, false);
        super.insertNodeInto(childNode, parentNode, Math.min(index, parentNode.getChildCount()));
        this.loadTreeData(childNode);
        this.filterAndSort(parentNode, false);
    }

    @Override
    public void insertNodesInto(@NotNull List<N> children, @NotNull N parent, int index) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        this.addRawChildren(parent, children, index);
        this.cacheNodesById(children);
        this.cacheParentId(children, ((UniqueNode)parent).getId());
        this.clearRawChildren(children, false);
        super.insertNodesInto(children, parent, Math.min(index, ((WebTreeNode)parent).getChildCount()));
        for (UniqueNode child : children) {
            this.loadTreeData(child);
        }
        this.filterAndSort(parent, false);
    }

    @Override
    public void insertNodesInto(@NotNull N[] children, @NotNull N parent, int index) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        this.addRawChildren((UniqueNode)parent, (UniqueNode[])children, index);
        this.cacheNodesById((UniqueNode[])children);
        this.cacheParentId((N)children, ((UniqueNode)parent).getId());
        this.clearRawChildren((N)children, false);
        super.insertNodesInto(children, parent, Math.min(index, ((WebTreeNode)parent).getChildCount()));
        for (N child : children) {
            this.loadTreeData(child);
        }
        this.filterAndSort(parent, false);
    }

    @Override
    public void removeNodeFromParent(@NotNull MutableTreeNode node) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        UniqueNode child = (UniqueNode)node;
        N parent = this.findParent(child.getId());
        if (parent != null) {
            this.removeRawChild(parent, child);
            this.clearRawChildren(child, true);
            child.removeAllChildren();
            if (child.getParent() == parent) {
                super.removeNodeFromParent(node);
            }
        }
    }

    @Override
    public void removeNodesFromParent(@NotNull N parent) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        this.clearRawChildren(parent, false);
        super.removeNodesFromParent(parent);
    }

    @Override
    public void removeNodesFromParent(@NotNull N[] nodes) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        this.removeNodesFromParent((List<N>)CollectionUtils.toList(nodes));
    }

    @Override
    public void removeNodesFromParent(@NotNull List<N> nodes) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        ArrayList<UniqueNode> visible = new ArrayList<UniqueNode>(nodes.size());
        for (UniqueNode child : nodes) {
            N parent = this.findParent(child.getId());
            if (parent == null) continue;
            this.removeRawChild(parent, child);
            this.clearRawChildren(child, true);
            child.removeAllChildren();
            if (child.getParent() != parent) continue;
            visible.add(child);
        }
        super.removeNodesFromParent(visible);
    }

    @Override
    @Nullable
    public Filter<N> getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(@Nullable Filter<N> filter2) {
        this.filter = filter2;
        this.filter();
    }

    @Override
    public void clearFilter() {
        this.setFilter(null);
    }

    @Override
    public void filter() {
        this.filterAndSort(true);
    }

    @Override
    public void filter(@NotNull N parent) {
        this.filterAndSort(parent, false);
    }

    @Override
    public void filter(@NotNull N parent, boolean recursively) {
        this.filterAndSort(parent, recursively);
    }

    @Override
    @Nullable
    public Comparator<N> getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(@Nullable Comparator<N> comparator) {
        this.comparator = comparator;
        this.sort();
    }

    @Override
    public void clearComparator() {
        this.setComparator(null);
    }

    @Override
    public void sort() {
        this.filterAndSort(true);
    }

    @Override
    public void sort(@NotNull N parent) {
        this.filterAndSort(parent, false);
    }

    @Override
    public void sort(@NotNull N parent, boolean recursively) {
        this.filterAndSort(parent, recursively);
    }

    public void filterAndSort(boolean recursively) {
        if (this.isInstalled()) {
            this.filterAndSort(this.getRoot(), recursively);
        }
    }

    public void filterAndSort(@NotNull N parent, boolean recursively) {
        if (this.isInstalled()) {
            WebLookAndFeel.checkEventDispatchThread();
            TreeState treeState = this.tree.getTreeState(parent);
            if (recursively) {
                this.filterAndSortRecursively(parent);
            } else {
                this.filterAndSort(parent);
            }
            this.nodeStructureChanged((TreeNode)parent);
            this.tree.setTreeState(treeState, parent);
        }
    }

    protected void filterAndSortRecursively(@NotNull N parent) {
        this.filterAndSort(parent);
        for (int i = 0; i < ((WebTreeNode)parent).getChildCount(); ++i) {
            this.filterAndSortRecursively((UniqueNode)((WebTreeNode)parent).getChildAt(i));
        }
    }

    protected void filterAndSort(@NotNull N parent) {
        ((WebTreeNode)parent).removeAllChildren();
        List<N> children = this.getRawChildren(parent);
        List<N> realChildren = this.filterAndSort(parent, children);
        for (UniqueNode child : realChildren) {
            ((WebTreeNode)parent).add(child);
        }
    }

    @NotNull
    protected List<N> filterAndSort(@NotNull N parent, @NotNull List<N> children) {
        ArrayList<Object> result2;
        if (CollectionUtils.notEmpty(children)) {
            ExTreeDataProvider<N> dataProvider = this.getDataProvider();
            Filter<N> dataProviderFilter = dataProvider.getChildrenFilter(parent, children);
            Filter treeFilter = this.tree instanceof FilterableNodes ? ((FilterableNodes)((Object)this.tree)).getFilter() : null;
            Filter<N> modelFilter = this.getFilter();
            result2 = CollectionUtils.filter(children, dataProviderFilter, treeFilter, modelFilter);
            Comparator<N> dataProviderComparator = dataProvider.getChildrenComparator(parent, result2);
            Comparator treeComparator = this.tree instanceof SortableNodes ? ((SortableNodes)((Object)this.tree)).getComparator() : null;
            Comparator<N> modelComparator = this.getComparator();
            CollectionUtils.sort(result2, dataProviderComparator, treeComparator, modelComparator);
        } else {
            result2 = new ArrayList(0);
        }
        return result2;
    }

    @Nullable
    public N findNode(@NotNull String nodeId) {
        this.checkInstalled();
        return (N)((UniqueNode)this.nodeById.get(nodeId));
    }

    @Nullable
    public N getRawParent(@NotNull N node) {
        this.checkInstalled();
        UniqueNode parent = (UniqueNode)((WebTreeNode)node).getParent();
        return (N)(parent != null ? parent : this.findParent(((UniqueNode)node).getId()));
    }

    @NotNull
    public List<N> getRawChildren(@NotNull N parent) {
        this.checkInstalled();
        List<N> children = this.rawNodeChildrenCache.get(((UniqueNode)parent).getId());
        if (children == null) {
            throw new RuntimeException("Raw children are not available for node: " + parent);
        }
        return children;
    }

    @NotNull
    public N getRawChildAt(@NotNull N parent, int index) {
        this.checkInstalled();
        List<N> children = this.rawNodeChildrenCache.get(((UniqueNode)parent).getId());
        if (children == null) {
            throw new RuntimeException("Raw children are not available for node: " + parent);
        }
        return (N)((UniqueNode)children.get(index));
    }

    protected void setRawChildren(@NotNull N parent, @NotNull List<N> nodes) {
        this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), nodes);
    }

    public int getRawChildrenCount(@NotNull N parent) {
        return this.getRawChildren(parent).size();
    }

    protected void addRawChild(@NotNull N parent, @NotNull N node, int index) {
        this.getRawChildren(parent).add(index, node);
    }

    protected void addRawChildren(@NotNull N parent, @NotNull List<N> nodes, int index) {
        this.getRawChildren(parent).addAll(index, nodes);
    }

    protected void addRawChildren(@NotNull N parent, @NotNull N[] nodes, int index) {
        List<N> cachedChildren = this.getRawChildren(parent);
        for (int i = nodes.length - 1; i >= 0; --i) {
            cachedChildren.add(index, nodes[i]);
        }
    }

    protected void removeRawChild(@NotNull N parent, @NotNull N node) {
        this.getRawChildren(parent).remove(node);
    }

    protected void clearRawChildren(@NotNull N node, boolean clearNode) {
        List<N> children;
        if (clearNode) {
            this.nodeById.remove(((UniqueNode)node).getId());
            this.parentById.remove(((UniqueNode)node).getId());
        }
        if (CollectionUtils.notEmpty(children = this.rawNodeChildrenCache.remove(((UniqueNode)node).getId()))) {
            this.clearRawChildren(children, true);
        }
    }

    protected void clearRawChildren(@NotNull List<N> nodes, boolean clearNodes) {
        for (UniqueNode node : nodes) {
            this.clearRawChildren(node, clearNodes);
        }
    }

    protected void clearRawChildren(@NotNull N[] nodes, boolean clearNodes) {
        for (N node : nodes) {
            this.clearRawChildren(node, clearNodes);
        }
    }

    protected void cacheNodeById(@NotNull N node) {
        this.nodeById.put(((UniqueNode)node).getId(), node);
    }

    protected void cacheNodesById(@NotNull List<N> nodes) {
        for (UniqueNode node : nodes) {
            this.cacheNodeById(node);
        }
    }

    protected void cacheNodesById(@NotNull N[] nodes) {
        for (N node : nodes) {
            this.cacheNodeById(node);
        }
    }

    @Nullable
    public N findParent(@NotNull String nodeId) {
        this.checkInstalled();
        String parentId = this.parentById.get(nodeId);
        return this.findNode(parentId);
    }

    protected void cacheParentId(@NotNull N node, @Nullable String parentId) {
        this.parentById.put(((UniqueNode)node).getId(), parentId);
    }

    protected void cacheParentId(@NotNull List<N> nodes, @Nullable String parentId) {
        for (UniqueNode node : nodes) {
            this.cacheParentId(node, parentId);
        }
    }

    protected void cacheParentId(@NotNull N[] nodes, @Nullable String parentId) {
        for (N node : nodes) {
            this.cacheParentId(node, parentId);
        }
    }
}

