/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.ui.IconBridge;
import com.alee.extended.icon.StackIcon;
import com.alee.extended.tree.AsyncNodeState;
import com.alee.extended.tree.NodeImageObserver;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.tree.TreeNodeParameters;
import com.alee.laf.tree.UniqueNode;
import com.alee.utils.TextUtils;
import com.alee.utils.swing.BroadcastImageObserver;
import com.alee.utils.swing.LoadIconType;
import java.awt.image.ImageObserver;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class AsyncUniqueNode<N extends AsyncUniqueNode<N, T>, T>
extends UniqueNode<N, T>
implements IconBridge<TreeNodeParameters<N, WebAsyncTree<N>>> {
    public static LoadIconType loadIconType = LoadIconType.roller;
    protected static final String ID_PREFIX = "AUN";
    protected static final Icon failedStateIcon = new ImageIcon(AsyncUniqueNode.class.getResource("icons/failed.png"));
    protected static final Map<Icon, Icon> failedStateIcons = new WeakHashMap<Icon, Icon>(5);
    @NotNull
    protected AsyncNodeState state = AsyncNodeState.waiting;
    @Nullable
    protected Throwable failureCause = null;
    @Nullable
    protected transient ImageObserver observer = null;

    public AsyncUniqueNode() {
        this(TextUtils.generateId(ID_PREFIX), null);
    }

    public AsyncUniqueNode(@Nullable T userObject) {
        this(TextUtils.generateId(ID_PREFIX), userObject);
    }

    public AsyncUniqueNode(@NotNull String id, @Nullable T userObject) {
        super(id, userObject);
    }

    @NotNull
    public AsyncNodeState getState() {
        return this.state;
    }

    public boolean isWaiting() {
        return this.state == AsyncNodeState.waiting;
    }

    public boolean isLoading() {
        return this.state == AsyncNodeState.loading;
    }

    public boolean isLoaded() {
        return this.state == AsyncNodeState.loaded;
    }

    public boolean isFailed() {
        return this.state == AsyncNodeState.failed;
    }

    public void setState(@NotNull AsyncNodeState state) {
        this.state = state;
    }

    @Nullable
    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public void setFailureCause(@Nullable Throwable failureCause) {
        this.failureCause = failureCause;
    }

    @Override
    @Nullable
    public Icon getIcon(@NotNull TreeNodeParameters<N, WebAsyncTree<N>> parameters) {
        Icon nodeIcon;
        Icon icon = this.isLoading() ? this.getLoadIcon(parameters) : ((nodeIcon = this.getNodeIcon(parameters)) != null && this.isFailed() ? this.getFailedStateIcon(parameters, nodeIcon) : nodeIcon);
        return icon;
    }

    @Nullable
    public Icon getLoadIcon(@NotNull TreeNodeParameters<N, WebAsyncTree<N>> parameters) {
        return loadIconType != null ? loadIconType.getIcon() : null;
    }

    public void attachLoadIconObserver(@NotNull WebAsyncTree tree) {
        WebLookAndFeel.checkEventDispatchThread();
        Icon icon = this.getLoadIcon(new TreeNodeParameters<AsyncUniqueNode, WebAsyncTree>(tree, this));
        if (icon instanceof ImageIcon) {
            BroadcastImageObserver broadcast;
            ImageIcon imageIcon = (ImageIcon)icon;
            ImageObserver existing = imageIcon.getImageObserver();
            if (existing == null) {
                broadcast = new BroadcastImageObserver();
                imageIcon.setImageObserver(broadcast);
            } else if (existing instanceof BroadcastImageObserver) {
                broadcast = (BroadcastImageObserver)existing;
            } else {
                broadcast = new BroadcastImageObserver();
                broadcast.addObserver(existing);
                imageIcon.setImageObserver(broadcast);
            }
            if (this.observer == null) {
                this.observer = new NodeImageObserver(tree, this);
            }
            broadcast.addObserver(tree, this.observer);
        }
    }

    public void detachLoadIconObserver(@NotNull WebAsyncTree tree) {
        ImageIcon imageIcon;
        ImageObserver existing;
        WebLookAndFeel.checkEventDispatchThread();
        Icon icon = this.getLoadIcon(new TreeNodeParameters<AsyncUniqueNode, WebAsyncTree>(tree, this));
        if (icon instanceof ImageIcon && (existing = (imageIcon = (ImageIcon)icon).getImageObserver()) instanceof BroadcastImageObserver) {
            BroadcastImageObserver broadcast = (BroadcastImageObserver)existing;
            broadcast.removeObserver(tree, this.observer);
        }
    }

    @Nullable
    public abstract Icon getNodeIcon(@NotNull TreeNodeParameters<N, WebAsyncTree<N>> var1);

    public Icon getFailedStateIcon(@NotNull TreeNodeParameters<N, WebAsyncTree<N>> parameters, @NotNull Icon icon) {
        Icon failedIcon = failedStateIcons.get(icon);
        if (failedIcon == null) {
            failedIcon = new StackIcon(icon, failedStateIcon);
            failedStateIcons.put(icon, failedIcon);
        }
        return failedIcon;
    }
}

