/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.tree.AsyncNodeState;
import com.alee.extended.tree.AsyncTreeDataProvider;
import com.alee.extended.tree.AsyncTreeModelAdapter;
import com.alee.extended.tree.AsyncTreeModelListener;
import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.extended.tree.FilterableNodes;
import com.alee.extended.tree.NodesLoadCallback;
import com.alee.extended.tree.SortableNodes;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTreeModel;
import com.alee.laf.tree.WebTreeNode;
import com.alee.managers.task.TaskManager;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.compare.Filter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AsyncTreeModel<N extends AsyncUniqueNode>
extends WebTreeModel<N>
implements FilterableNodes<N>,
SortableNodes<N> {
    @NotNull
    protected final AsyncTreeDataProvider<N> dataProvider;
    @NotNull
    protected final EventListenerList listeners;
    protected transient Map<String, Boolean> nodeCached;
    protected transient Map<String, List<N>> rawNodeChildrenCache;
    protected transient Map<String, N> nodeById;
    protected transient WebAsyncTree<N> tree;
    @Nullable
    protected transient N rootNode;
    @Nullable
    protected transient Filter<N> filter;
    @Nullable
    protected transient Comparator<N> comparator;

    public AsyncTreeModel(@NotNull AsyncTreeDataProvider<N> dataProvider) {
        super(null);
        this.dataProvider = dataProvider;
        this.listeners = new EventListenerList();
    }

    @NotNull
    public AsyncTreeDataProvider<N> getDataProvider() {
        return this.dataProvider;
    }

    public void install(@NotNull WebAsyncTree<N> tree) {
        WebLookAndFeel.checkEventDispatchThread();
        this.nodeCached = new HashMap<String, Boolean>(50);
        this.rawNodeChildrenCache = new HashMap<String, List<N>>(10);
        this.nodeById = new HashMap<String, N>(50);
        this.tree = tree;
        this.rootNode = null;
        this.addAsyncTreeModelListener(tree);
    }

    public void uninstall(@NotNull WebAsyncTree<N> tree) {
        WebLookAndFeel.checkEventDispatchThread();
        this.removeAsyncTreeModelListener(tree);
        for (Map.Entry<String, N> entry : this.nodeById.entrySet()) {
            AsyncUniqueNode node = (AsyncUniqueNode)entry.getValue();
            node.detachLoadIconObserver(tree);
        }
        this.rootNode = null;
        this.tree = null;
        this.nodeById = null;
        this.rawNodeChildrenCache = null;
        this.nodeCached = null;
    }

    public boolean isInstalled() {
        return this.tree != null;
    }

    protected void checkInstalled() {
        if (!this.isInstalled()) {
            throw new RuntimeException("This operation cannot be performed before model is installed into WebAsyncTree");
        }
    }

    @Override
    @NotNull
    public N getRoot() {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        if (this.rootNode == null) {
            this.rootNode = this.getDataProvider().getRoot();
            this.cacheNodeById(this.rootNode);
            ((AsyncUniqueNode)this.rootNode).attachLoadIconObserver(this.tree);
        }
        return this.rootNode;
    }

    @Override
    public boolean isLeaf(@NotNull Object node) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        return this.getDataProvider().isLeaf((AsyncUniqueNode)node);
    }

    @Override
    public int getChildCount(@NotNull Object parent) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        AsyncUniqueNode node = (AsyncUniqueNode)parent;
        int count = this.areChildrenLoaded(node) ? super.getChildCount(parent) : (this.isLeaf(node) ? this.loadEmptyChildren(node) : this.loadChildren(node));
        return count;
    }

    @NotNull
    public N getChild(@NotNull Object parent, int index) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        AsyncUniqueNode node = (AsyncUniqueNode)parent;
        if (!this.areChildrenLoaded(node)) {
            throw new RuntimeException("There are no loaded children at node: " + node);
        }
        AsyncUniqueNode child = (AsyncUniqueNode)super.getChild(parent, index);
        return (N)child;
    }

    @Override
    public void reload(@NotNull TreeNode node) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        this.tree.cancelEditing();
        this.clearNodeChildrenCache((AsyncUniqueNode)node, false);
        super.reload(node);
    }

    protected int loadEmptyChildren(@NotNull N parent) {
        this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), new ArrayList(0));
        this.nodeCached.put(((UniqueNode)parent).getId(), true);
        ((AsyncUniqueNode)parent).setState(AsyncNodeState.loaded);
        return 0;
    }

    protected int loadChildren(@NotNull N parent) {
        int loadedCount;
        if (!((AsyncUniqueNode)parent).isLoading()) {
            ((AsyncUniqueNode)parent).setState(AsyncNodeState.loading);
            this.nodeChanged((TreeNode)parent);
            this.fireChildrenLoadStarted(parent);
            int childCount = ((WebTreeNode)parent).getChildCount();
            if (childCount > 0) {
                int[] indices = new int[childCount];
                Object[] children = new Object[childCount];
                for (int i = childCount - 1; i >= 0; --i) {
                    indices[i] = i;
                    children[i] = ((WebTreeNode)parent).getChildAt(i);
                    ((WebTreeNode)parent).remove(i);
                }
                this.nodesWereRemoved((TreeNode)parent, indices, children);
            }
            if (this.tree.isAsyncLoading()) {
                TaskManager.execute(this.dataProvider.getThreadGroupId(), new Runnable((AsyncUniqueNode)parent){
                    final /* synthetic */ AsyncUniqueNode val$parent;
                    {
                        this.val$parent = asyncUniqueNode;
                    }

                    @Override
                    public void run() {
                        AsyncTreeModel.this.getDataProvider().loadChildren(this.val$parent, new NodesLoadCallback<N>(){

                            @Override
                            public void completed(final @NotNull List<N> children) {
                                CoreSwingUtils.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        AsyncTreeModel.this.loadChildrenCompleted(val$parent, children);
                                    }
                                });
                            }

                            @Override
                            public void failed(final @NotNull Throwable cause) {
                                CoreSwingUtils.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        AsyncTreeModel.this.loadChildrenFailed(val$parent, cause);
                                    }
                                });
                            }
                        });
                    }
                });
                loadedCount = 0;
            } else {
                this.getDataProvider().loadChildren(parent, new NodesLoadCallback<N>((AsyncUniqueNode)parent){
                    final /* synthetic */ AsyncUniqueNode val$parent;
                    {
                        this.val$parent = asyncUniqueNode;
                    }

                    @Override
                    public void completed(@NotNull List<N> children) {
                        AsyncTreeModel.this.loadChildrenCompleted(this.val$parent, children);
                    }

                    @Override
                    public void failed(@NotNull Throwable cause) {
                        AsyncTreeModel.this.loadChildrenFailed(this.val$parent, cause);
                    }
                });
                loadedCount = ((WebTreeNode)parent).getChildCount();
            }
        } else {
            loadedCount = 0;
        }
        return loadedCount;
    }

    protected void loadChildrenCompleted(@NotNull N parent, @NotNull List<N> children) {
        if (this.isInstalled()) {
            WebLookAndFeel.checkEventDispatchThread();
            this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), children);
            this.cacheNodesById(children);
            for (AsyncUniqueNode child : children) {
                child.attachLoadIconObserver(this.tree);
            }
            List<N> realChildren = this.filterAndSort(parent, children);
            this.nodeCached.put(((UniqueNode)parent).getId(), true);
            if (realChildren.size() > 0) {
                this.insertNodesIntoImpl(realChildren, parent, 0);
            }
            ((AsyncUniqueNode)parent).setState(AsyncNodeState.loaded);
            this.nodeChanged((TreeNode)parent);
            this.fireChildrenLoadCompleted(parent, realChildren);
        }
    }

    protected void loadChildrenFailed(@NotNull N parent, @NotNull Throwable cause) {
        if (this.isInstalled()) {
            WebLookAndFeel.checkEventDispatchThread();
            this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), new ArrayList(0));
            this.nodeCached.put(((UniqueNode)parent).getId(), true);
            ((AsyncUniqueNode)parent).setState(AsyncNodeState.failed);
            ((AsyncUniqueNode)parent).setFailureCause(cause);
            this.nodeChanged((TreeNode)parent);
            this.fireChildrenLoadFailed(parent, cause);
        }
    }

    @Override
    public void valueForPathChanged(@NotNull TreePath path, @Nullable Object newValue) {
        TreeNode parent;
        this.checkInstalled();
        super.valueForPathChanged(path, newValue);
        AsyncUniqueNode node = (AsyncUniqueNode)this.tree.getNodeForPath(path);
        if (node != null && (parent = node.getParent()) != null) {
            this.filterAndSort((AsyncUniqueNode)parent, false);
        }
    }

    public void setChildNodes(@NotNull N parent, @NotNull List<N> children) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        if (!((AsyncUniqueNode)parent).isLoading()) {
            this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), children);
            this.cacheNodesById(children);
            List<N> realChildren = this.filterAndSort(parent, children);
            this.nodeCached.put(((UniqueNode)parent).getId(), true);
            if (realChildren.size() > 0) {
                this.clearNodeChildrenCache(children, false);
                this.insertNodesIntoImpl(realChildren, parent, 0);
            }
            ((AsyncUniqueNode)parent).setState(AsyncNodeState.loaded);
            this.nodeChanged((TreeNode)parent);
            this.fireChildrenLoadCompleted(parent, realChildren);
        }
    }

    public void addChildNode(@NotNull N parent, @NotNull N child) {
        this.addChildNodes(parent, CollectionUtils.asList(child));
    }

    public void addChildNodes(@NotNull N parent, @NotNull List<N> children) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        if (((AsyncUniqueNode)parent).isLoaded()) {
            List<N> cachedChildren = this.rawNodeChildrenCache.get(((UniqueNode)parent).getId());
            if (cachedChildren == null) {
                cachedChildren = new ArrayList<N>(children.size());
                this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), cachedChildren);
            }
            cachedChildren.addAll(children);
            this.cacheNodesById(children);
            this.clearNodeChildrenCache(children, false);
            this.insertNodesIntoImpl(children, parent, ((WebTreeNode)parent).getChildCount());
            this.filterAndSort(parent, false);
        }
    }

    @Override
    public void insertNodeInto(@NotNull MutableTreeNode child, @NotNull MutableTreeNode parent, int index) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        AsyncUniqueNode parentNode = (AsyncUniqueNode)parent;
        AsyncUniqueNode childNode = (AsyncUniqueNode)child;
        if (parentNode.isLoaded()) {
            List<N> cachedChildren = this.rawNodeChildrenCache.get(parentNode.getId());
            if (cachedChildren == null) {
                cachedChildren = new ArrayList<N>(1);
                this.rawNodeChildrenCache.put(parentNode.getId(), cachedChildren);
            }
            cachedChildren.add(index, childNode);
            this.cacheNodeById(childNode);
            this.clearNodeChildrenCache(childNode, false);
            this.insertNodeIntoImpl(childNode, parentNode, index);
            this.filterAndSort(parentNode, false);
        }
    }

    protected void insertNodeIntoImpl(@NotNull N child, @NotNull N parent, int index) {
        super.insertNodeInto((MutableTreeNode)child, (MutableTreeNode)parent, index);
        ((AsyncUniqueNode)child).attachLoadIconObserver(this.tree);
    }

    @Override
    public void insertNodesInto(@NotNull List<N> children, @NotNull N parent, int index) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        if (((AsyncUniqueNode)parent).isLoaded()) {
            List<N> cachedChildren = this.rawNodeChildrenCache.get(((UniqueNode)parent).getId());
            if (cachedChildren == null) {
                cachedChildren = new ArrayList<N>(1);
                this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), cachedChildren);
            }
            cachedChildren.addAll(index, children);
            this.cacheNodesById(children);
            this.clearNodeChildrenCache(children, false);
            this.insertNodesIntoImpl(children, parent, index);
            this.filterAndSort(parent, false);
        }
    }

    protected void insertNodesIntoImpl(@NotNull List<N> children, @NotNull N parent, int index) {
        super.insertNodesInto(children, parent, index);
        for (AsyncUniqueNode child : children) {
            child.attachLoadIconObserver(this.tree);
        }
    }

    @Override
    public void insertNodesInto(@NotNull N[] children, @NotNull N parent, int index) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        if (((AsyncUniqueNode)parent).isLoaded()) {
            List<N> cachedChildren = this.rawNodeChildrenCache.get(((UniqueNode)parent).getId());
            if (cachedChildren == null) {
                cachedChildren = new ArrayList<N>(1);
                this.rawNodeChildrenCache.put(((UniqueNode)parent).getId(), cachedChildren);
            }
            for (int i = children.length - 1; i >= 0; --i) {
                cachedChildren.add(index, children[i]);
            }
            this.cacheNodesById(CollectionUtils.asList(children));
            this.clearNodeChildrenCache((N)children, false);
            this.insertNodesIntoImpl((AsyncUniqueNode[])children, (AsyncUniqueNode)parent, index);
            this.filterAndSort(parent, false);
        }
    }

    protected void insertNodesIntoImpl(@NotNull N[] children, @NotNull N parent, int index) {
        super.insertNodesInto(children, parent, index);
        for (N child : children) {
            ((AsyncUniqueNode)child).attachLoadIconObserver(this.tree);
        }
    }

    @Override
    public void removeNodeFromParent(@NotNull MutableTreeNode node) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        AsyncUniqueNode child = (AsyncUniqueNode)node;
        AsyncUniqueNode parent = (AsyncUniqueNode)child.getParent();
        if (parent != null && parent.isLoaded()) {
            List<N> children = this.rawNodeChildrenCache.get(parent.getId());
            if (children != null) {
                children.remove(child);
            }
            this.clearNodeChildrenCache(child, true);
            child.removeAllChildren();
            super.removeNodeFromParent(node);
            child.detachLoadIconObserver(this.tree);
        }
    }

    @Override
    public void removeNodesFromParent(@NotNull N parent) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        if (((AsyncUniqueNode)parent).isLoaded()) {
            List<N> removed = this.rawNodeChildrenCache.get(((UniqueNode)parent).getId());
            this.clearNodeChildrenCache(parent, false);
            super.removeNodesFromParent(parent);
            if (CollectionUtils.notEmpty(removed)) {
                for (AsyncUniqueNode node : removed) {
                    node.detachLoadIconObserver(this.tree);
                }
            }
        }
    }

    @Override
    public void removeNodesFromParent(@NotNull N[] nodes) {
        this.removeNodesFromParent((List<N>)CollectionUtils.toList(nodes));
    }

    @Override
    public void removeNodesFromParent(@NotNull List<N> nodes) {
        WebLookAndFeel.checkEventDispatchThread();
        this.checkInstalled();
        ArrayList<AsyncUniqueNode> removed = new ArrayList<AsyncUniqueNode>(nodes.size());
        for (AsyncUniqueNode child : nodes) {
            AsyncUniqueNode parent = (AsyncUniqueNode)child.getParent();
            if (parent == null || !parent.isLoaded()) continue;
            List<N> children = this.rawNodeChildrenCache.get(parent.getId());
            if (children != null) {
                children.remove(child);
            }
            this.clearNodeChildrenCache(child, true);
            child.removeAllChildren();
            removed.add(child);
        }
        super.removeNodesFromParent(nodes);
        if (CollectionUtils.notEmpty(removed)) {
            for (AsyncUniqueNode node : removed) {
                node.detachLoadIconObserver(this.tree);
            }
        }
    }

    @Override
    @Nullable
    public Filter<N> getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(@Nullable Filter<N> filter2) {
        this.filter = filter2;
        this.filter();
    }

    @Override
    public void clearFilter() {
        this.setFilter(null);
    }

    @Override
    public void filter() {
        this.filterAndSort(true);
    }

    @Override
    public void filter(@NotNull N parent) {
        this.filterAndSort(parent, false);
    }

    @Override
    public void filter(@NotNull N parent, boolean recursively) {
        this.filterAndSort(parent, recursively);
    }

    @Override
    @Nullable
    public Comparator<N> getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(@Nullable Comparator<N> comparator) {
        this.comparator = comparator;
        this.sort();
    }

    @Override
    public void clearComparator() {
        this.setComparator(null);
    }

    @Override
    public void sort() {
        this.filterAndSort(true);
    }

    @Override
    public void sort(@NotNull N parent) {
        this.filterAndSort(parent, false);
    }

    @Override
    public void sort(@NotNull N parent, boolean recursively) {
        this.filterAndSort(parent, recursively);
    }

    public void filterAndSort(boolean recursively) {
        if (this.isInstalled()) {
            this.filterAndSort(this.getRoot(), recursively);
        }
    }

    public void filterAndSort(@NotNull N parent, boolean recursively) {
        if (this.isInstalled()) {
            WebLookAndFeel.checkEventDispatchThread();
            this.filterAndSort(parent, recursively, true);
        }
    }

    protected void filterAndSort(@NotNull N parent, boolean recursively, boolean performUpdates) {
        if (((AsyncUniqueNode)parent).isLoaded() && this.rawNodeChildrenCache.containsKey(((UniqueNode)parent).getId())) {
            this.filterAndSortRecursively(parent, recursively, performUpdates);
        } else if (((AsyncUniqueNode)parent).isLoading()) {
            this.addAsyncTreeModelListener(new AsyncTreeModelAdapter((AsyncUniqueNode)parent, recursively, performUpdates){
                final /* synthetic */ AsyncUniqueNode val$parent;
                final /* synthetic */ boolean val$recursively;
                final /* synthetic */ boolean val$performUpdates;
                {
                    this.val$parent = asyncUniqueNode;
                    this.val$recursively = bl;
                    this.val$performUpdates = bl2;
                }

                @Override
                public void loadCompleted(@NotNull AsyncUniqueNode completedFor, @NotNull List children) {
                    if (Objects.equals((Object)this.val$parent.getId(), (Object)completedFor.getId())) {
                        AsyncTreeModel.this.removeAsyncTreeModelListener(this);
                        AsyncTreeModel.this.filterAndSortRecursively(this.val$parent, this.val$recursively, this.val$performUpdates);
                    }
                }

                @Override
                public void loadFailed(@NotNull AsyncUniqueNode failedFor, @NotNull Throwable cause) {
                    if (Objects.equals((Object)this.val$parent.getId(), (Object)failedFor.getId())) {
                        AsyncTreeModel.this.removeAsyncTreeModelListener(this);
                    }
                }
            });
        }
    }

    protected void filterAndSortRecursively(@NotNull N parent, boolean recursively, boolean performUpdates) {
        TreeState treeState = this.tree.getTreeState(parent);
        List<N> cachedChildren = this.rawNodeChildrenCache.get(((UniqueNode)parent).getId());
        if (cachedChildren != null) {
            ((WebTreeNode)parent).removeAllChildren();
            List<N> children = this.filterAndSort(parent, cachedChildren);
            for (AsyncUniqueNode child : children) {
                ((WebTreeNode)parent).add(child);
            }
        }
        if (recursively) {
            for (int i = 0; i < ((WebTreeNode)parent).getChildCount(); ++i) {
                this.filterAndSort((AsyncUniqueNode)((WebTreeNode)parent).getChildAt(i), true, false);
            }
        }
        if (performUpdates) {
            this.nodeStructureChanged((TreeNode)parent);
            this.tree.setTreeState(treeState, parent);
        }
    }

    @NotNull
    protected List<N> filterAndSort(@NotNull N parent, @NotNull List<N> children) {
        ArrayList<Object> result2;
        if (CollectionUtils.notEmpty(children)) {
            AsyncTreeDataProvider<N> dataProvider = this.getDataProvider();
            Filter<N> dataProviderFilter = dataProvider.getChildrenFilter(parent, children);
            Filter<N> treeFilter = this.tree.getFilter();
            Filter<N> modelFilter = this.getFilter();
            result2 = CollectionUtils.filter(children, dataProviderFilter, treeFilter, modelFilter);
            Comparator<N> dataProviderComparator = dataProvider.getChildrenComparator(parent, result2);
            Comparator<N> treeComparator = this.tree.getComparator();
            Comparator<N> modelComparator = this.getComparator();
            CollectionUtils.sort(result2, dataProviderComparator, treeComparator, modelComparator);
        } else {
            result2 = new ArrayList(0);
        }
        return result2;
    }

    public N findNode(@NotNull String nodeId) {
        this.checkInstalled();
        return (N)((AsyncUniqueNode)this.nodeById.get(nodeId));
    }

    public boolean areChildrenLoaded(@NotNull N node) {
        this.checkInstalled();
        Boolean cached = this.nodeCached.get(((UniqueNode)node).getId());
        return cached != null && cached != false;
    }

    protected void clearNodeChildrenCache(@NotNull N node, boolean clearNode) {
        if (clearNode) {
            this.nodeById.remove(((UniqueNode)node).getId());
        }
        this.nodeCached.remove(((UniqueNode)node).getId());
        List<N> children = this.rawNodeChildrenCache.remove(((UniqueNode)node).getId());
        if (children != null) {
            this.clearNodeChildrenCache(children, true);
        }
    }

    protected void clearNodeChildrenCache(@NotNull List<N> nodes, boolean clearNodes) {
        for (AsyncUniqueNode node : nodes) {
            this.clearNodeChildrenCache(node, clearNodes);
        }
    }

    protected void clearNodeChildrenCache(@NotNull N[] nodes, boolean clearNodes) {
        for (N node : nodes) {
            this.clearNodeChildrenCache(node, clearNodes);
        }
    }

    protected void cacheNodeById(@NotNull N node) {
        this.nodeById.put(((UniqueNode)node).getId(), node);
    }

    protected void cacheNodesById(@NotNull List<N> nodes) {
        for (AsyncUniqueNode node : nodes) {
            this.nodeById.put(node.getId(), node);
        }
    }

    public void addAsyncTreeModelListener(@NotNull AsyncTreeModelListener listener) {
        this.listeners.add(AsyncTreeModelListener.class, listener);
    }

    public void removeAsyncTreeModelListener(@NotNull AsyncTreeModelListener listener) {
        this.listeners.remove(AsyncTreeModelListener.class, listener);
    }

    protected void fireChildrenLoadStarted(@NotNull N parent) {
        WebLookAndFeel.checkEventDispatchThread();
        for (AsyncTreeModelListener listener : (AsyncTreeModelListener[])this.listeners.getListeners(AsyncTreeModelListener.class)) {
            listener.loadStarted(parent);
        }
    }

    protected void fireChildrenLoadCompleted(@NotNull N parent, @NotNull List<N> children) {
        WebLookAndFeel.checkEventDispatchThread();
        for (AsyncTreeModelListener listener : (AsyncTreeModelListener[])this.listeners.getListeners(AsyncTreeModelListener.class)) {
            listener.loadCompleted(parent, children);
        }
    }

    protected void fireChildrenLoadFailed(@NotNull N parent, @NotNull Throwable cause) {
        WebLookAndFeel.checkEventDispatchThread();
        for (AsyncTreeModelListener listener : (AsyncTreeModelListener[])this.listeners.getListeners(AsyncTreeModelListener.class)) {
            listener.loadFailed(parent, cause);
        }
    }
}

