/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition.effects;

import com.alee.extended.transition.ImageTransition;
import com.alee.extended.transition.effects.Direction;
import com.alee.extended.transition.effects.TransitionEffect;
import com.alee.utils.SwingUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class DefaultTransitionEffect
implements TransitionEffect {
    protected static final String DIRECTION = "DIRECTION";
    protected Map<String, Object> effectSettings = new HashMap<String, Object>();
    protected boolean animating = false;

    @Override
    public long getAnimationDelay() {
        return SwingUtils.frameRateDelay(36);
    }

    @Override
    public boolean isAnimating() {
        return this.animating;
    }

    public Direction getDirection() {
        return this.get(DIRECTION, Direction.random);
    }

    public void setDirection(Direction direction) {
        this.put(DIRECTION, (Object)direction);
    }

    protected Map<String, Object> getEffectSettings() {
        return this.effectSettings;
    }

    protected void setEffectSettings(Map<String, Object> effectSettings) {
        this.effectSettings = effectSettings;
    }

    protected void put(String property, Object value) {
        this.effectSettings.put(property, value);
    }

    protected void remove(String property) {
        this.effectSettings.remove(property);
    }

    protected void clearSettings() {
        this.effectSettings.clear();
    }

    protected <T> T get(String property, T defaultValue2) {
        if (this.effectSettings.containsKey(property)) {
            return (T)this.effectSettings.get(property);
        }
        return defaultValue2;
    }

    @Override
    public boolean performAnimationTick(ImageTransition transition) {
        if (!this.animating) {
            this.animating = true;
            this.prepareAnimation(transition);
            return false;
        }
        boolean finished = this.performAnimation(transition);
        if (finished) {
            this.animating = false;
        }
        return finished;
    }

    public abstract void prepareAnimation(ImageTransition var1);

    public abstract boolean performAnimation(ImageTransition var1);
}

