/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition;

import com.alee.extended.layout.StackLayout;
import com.alee.extended.transition.ImageTransition;
import com.alee.extended.transition.TransitionListener;
import com.alee.extended.transition.effects.TransitionEffect;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class ComponentTransition
extends WebPanel {
    protected List<TransitionListener> transitionListeners = new ArrayList<TransitionListener>(1);
    protected boolean restoreFocus = true;
    protected boolean animating = false;
    protected ImageTransition transition = null;
    protected List<TransitionEffect> transitionEffects = null;
    protected Component lastContent;

    public ComponentTransition() {
        this((Component)null);
    }

    public ComponentTransition(Component content) {
        this(content, null);
    }

    public ComponentTransition(TransitionEffect transitionEffect) {
        this(null, transitionEffect);
    }

    public ComponentTransition(Component content, TransitionEffect transitionEffect) {
        super((LayoutManager)new StackLayout(), new Component[0]);
        this.setFocusable(false);
        this.setTransitionEffect(transitionEffect);
        this.lastContent = content;
        if (content != null) {
            this.add(content);
        }
    }

    public boolean isRestoreFocus() {
        return this.restoreFocus;
    }

    public void setRestoreFocus(boolean restoreFocus) {
        this.restoreFocus = restoreFocus;
    }

    public Component getContent() {
        return this.getComponentCount() > 0 ? this.getComponent(0) : null;
    }

    public void setContent(Component content) {
        if (!this.isAnimating()) {
            this.lastContent = content;
            this.removeAll();
            this.add(content);
            this.revalidate();
            this.repaint();
        }
    }

    public void performTransition(final Component content) {
        CoreSwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComponentTransition.this.performTransitionImpl(content);
            }
        });
    }

    public void delayTransition(long delay, final Component content) {
        WebTimer.delay("delayTransition", delay, true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentTransition.this.performTransitionImpl(content);
            }
        });
    }

    protected void performTransitionImpl(final Component content) {
        BufferedImage currentSnapshot;
        if (this.lastContent == content) {
            return;
        }
        this.lastContent = content;
        if (!this.canAnimate()) {
            this.finishTransitionImpl(content);
            return;
        }
        if (this.transition != null) {
            if (this.isAnimating()) {
                this.transition.cancelTransition();
            } else {
                this.transition.setBlocked(true);
            }
        }
        this.animating = true;
        final int width = this.getWidth();
        final int height = this.getHeight();
        if (this.transition != null) {
            currentSnapshot = this.transition.getOtherImage();
        } else {
            Component currentContent = this.getComponentCount() > 0 ? this.getComponent(0) : null;
            currentSnapshot = SwingUtils.createComponentSnapshot(currentContent, width, height);
        }
        this.setFocusable(true);
        if (this.restoreFocus && SwingUtils.hasFocusOwner(this)) {
            FocusAdapter focusHandle = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ComponentTransition.this.removeFocusListener(this);
                    ComponentTransition.this.continueTransitionImpl(content, width, height, currentSnapshot);
                }
            };
            this.addFocusListener(focusHandle);
            if (!this.requestFocusInWindow()) {
                this.removeFocusListener(focusHandle);
                this.continueTransitionImpl(content, width, height, currentSnapshot);
            }
        } else {
            this.continueTransitionImpl(content, width, height, currentSnapshot);
        }
    }

    protected boolean canAnimate() {
        return this.getTransitionEffect() != null && this.isShowing();
    }

    protected void continueTransitionImpl(final Component content, int width, int height, BufferedImage currentSnapshot) {
        this.removeAll();
        if (content != null) {
            this.add(content, (Object)"HIDDEN");
        }
        BufferedImage otherSnapshot = SwingUtils.createComponentSnapshot(content, width, height);
        this.removeAll();
        this.transition = new ImageTransition(currentSnapshot, otherSnapshot);
        this.transition.setTransitionEffects(this.transitionEffects);
        this.add((Component)this.transition);
        this.revalidate();
        this.repaint();
        this.transition.addTransitionListener(new TransitionListener(){

            @Override
            public void transitionStarted() {
                ComponentTransition.this.fireTransitionStarted();
            }

            @Override
            public void transitionFinished() {
                ComponentTransition.this.finishTransitionImpl(content);
            }
        });
        this.transition.performTransition();
    }

    protected void finishTransitionImpl(Component content) {
        this.removeAll();
        if (content != null) {
            this.add(content);
        }
        this.revalidate();
        this.repaint();
        this.animating = false;
        if (this.isFocusOwner()) {
            this.transferFocus();
        }
        this.setFocusable(false);
        if (this.transition != null) {
            this.transition.destroy();
            this.transition = null;
        }
        this.fireTransitionFinished();
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public List<TransitionEffect> getTransitionEffects() {
        return this.transitionEffects;
    }

    public TransitionEffect getTransitionEffect() {
        return this.transitionEffects != null && this.transitionEffects.size() > 0 ? this.transitionEffects.get(0) : null;
    }

    public void addTransitionEffect(TransitionEffect transitionEffect) {
        if (this.transitionEffects == null) {
            this.transitionEffects = new ArrayList<TransitionEffect>();
        }
        this.transitionEffects.add(transitionEffect);
    }

    public void clearTransitionEffects() {
        if (this.transitionEffects != null) {
            this.transitionEffects = null;
        }
    }

    public void removeTransitionEffect(TransitionEffect transitionEffect) {
        if (this.transitionEffects != null) {
            this.transitionEffects.remove(transitionEffect);
        }
    }

    public void setTransitionEffect(TransitionEffect transitionEffect) {
        this.transitionEffects = transitionEffect != null ? CollectionUtils.asList(transitionEffect) : null;
    }

    public void setTransitionEffects(List<TransitionEffect> transitionEffects) {
        this.transitionEffects = transitionEffects;
    }

    public void setTransitionEffects(TransitionEffect ... transitionEffects) {
        this.transitionEffects = transitionEffects != null ? CollectionUtils.asList(transitionEffects) : null;
    }

    public void addTransitionListener(TransitionListener listener) {
        this.transitionListeners.add(listener);
    }

    public void removeTransitionListener(TransitionListener listener) {
        this.transitionListeners.remove(listener);
    }

    public void fireTransitionStarted() {
        for (TransitionListener listener : CollectionUtils.copy(this.transitionListeners)) {
            listener.transitionStarted();
        }
    }

    public void fireTransitionFinished() {
        for (TransitionListener listener : CollectionUtils.copy(this.transitionListeners)) {
            listener.transitionFinished();
        }
    }
}

