/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tab;

import com.alee.extended.tab.DocumentData;
import com.alee.extended.tab.DocumentPaneState;
import com.alee.extended.tab.PaneData;
import com.alee.extended.tab.StructureData;
import com.alee.extended.tab.WebDocumentPane;
import com.alee.laf.splitpane.WebSplitPane;
import com.alee.managers.style.StyleId;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.Customizer;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class SplitData<T extends DocumentData>
implements StructureData<T> {
    protected final WebSplitPane splitPane;
    protected int orientation;
    protected StructureData first;
    protected StructureData last;

    public SplitData(WebDocumentPane<T> documentPane, int orientation, StructureData first, StructureData last) {
        this.orientation = orientation;
        this.first = first;
        this.last = last;
        this.splitPane = this.createSplit(documentPane, orientation, first, last);
        this.updateSplitPaneCustomizer(documentPane);
    }

    protected WebSplitPane createSplit(WebDocumentPane<T> documentPane, int orientation, StructureData first, StructureData last) {
        StyleId splitStyleId = StyleId.documentpaneSplit.at(documentPane);
        WebSplitPane splitPane = new WebSplitPane(splitStyleId, orientation, first.getComponent(), last.getComponent());
        splitPane.putClientProperty("document.pane.data", this);
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(0.5);
        splitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CoreSwingUtils.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SplitData.this.getDocumentPane().fireDividerLocationChanged(SplitData.this);
                    }
                });
            }
        });
        return splitPane;
    }

    protected void updateSplitPaneCustomizer(WebDocumentPane<T> documentPane) {
        Customizer<WebSplitPane> customizer = documentPane.getSplitPaneCustomizer();
        if (customizer != null) {
            customizer.customize(this.splitPane);
        }
    }

    @Override
    public Component getComponent() {
        return this.getSplitPane();
    }

    @Override
    public PaneData<T> findClosestPane() {
        return this.getFirst().findClosestPane();
    }

    @Override
    public DocumentPaneState getDocumentPaneState() {
        return new DocumentPaneState(this);
    }

    public WebDocumentPane getDocumentPane() {
        return SwingUtils.getFirstParent(this.splitPane, WebDocumentPane.class);
    }

    public WebSplitPane getSplitPane() {
        return this.splitPane;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.splitPane.setOrientation(orientation);
        this.getDocumentPane().fireOrientationChanged(this);
    }

    public void changeOrientation() {
        this.setOrientation(this.orientation == 1 ? 0 : 1);
    }

    public void swapSides() {
        StructureData first = this.last;
        StructureData last = this.first;
        double location = this.getDividerLocation();
        this.splitPane.setLeftComponent(null);
        this.splitPane.setRightComponent(null);
        this.first = first;
        this.last = last;
        this.splitPane.setLeftComponent(first.getComponent());
        this.splitPane.setRightComponent(last.getComponent());
        this.splitPane.revalidate();
        this.splitPane.repaint();
        this.setDividerLocation(1.0 - location);
        this.getDocumentPane().fireSidesSwapped(this);
    }

    public double getDividerLocation() {
        return this.splitPane.getProportionalDividerLocation();
    }

    public void setDividerLocation(double location) {
        this.splitPane.setDividerLocation(Math.max(0.0, Math.min(location, 1.0)));
    }

    public StructureData getFirst() {
        return this.first;
    }

    public void setFirst(StructureData first) {
        this.first = first;
        this.splitPane.setLeftComponent(first.getComponent());
    }

    public StructureData getLast() {
        return this.last;
    }

    public void setLast(StructureData last) {
        this.last = last;
        this.splitPane.setRightComponent(last.getComponent());
    }

    public void replace(StructureData element, StructureData replacement) {
        if (this.first == element) {
            this.first = replacement;
            this.splitPane.setLeftComponent(replacement.getComponent());
        }
        if (this.last == element) {
            this.last = replacement;
            this.splitPane.setRightComponent(replacement.getComponent());
        }
    }
}

