/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tab;

import com.alee.api.annotations.NotNull;
import com.alee.extended.tab.DocumentData;
import com.alee.extended.tab.DocumentListener;
import com.alee.extended.tab.DocumentPaneListener;
import com.alee.extended.tab.DocumentPaneState;
import com.alee.extended.tab.PaneData;
import com.alee.extended.tab.SplitData;
import com.alee.extended.tab.StructureData;
import com.alee.extended.tab.WebDocumentPane;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;

public class DocumentPaneSettingsProcessor
extends SettingsProcessor<WebDocumentPane, DocumentPaneState, Configuration<DocumentPaneState>> {
    protected transient DocumentListener documentListener;
    protected transient DocumentPaneListener documentPaneListener;

    public DocumentPaneSettingsProcessor(WebDocumentPane documentPane, Configuration configuration) {
        super(documentPane, configuration);
    }

    @Override
    protected void register(@NotNull WebDocumentPane documentPane) {
        this.documentListener = new DocumentListener(){

            public void opened(DocumentData document, PaneData pane, int index) {
                DocumentPaneSettingsProcessor.this.save();
            }

            public void selected(DocumentData document, PaneData pane, int index) {
                DocumentPaneSettingsProcessor.this.save();
            }

            public boolean closing(DocumentData document, PaneData pane, int index) {
                return true;
            }

            public void closed(DocumentData document, PaneData pane, int index) {
                DocumentPaneSettingsProcessor.this.save();
            }
        };
        documentPane.addDocumentListener(this.documentListener);
        this.documentPaneListener = new DocumentPaneListener(){

            public void splitted(@NotNull WebDocumentPane documentPane, @NotNull PaneData splittedPane, @NotNull SplitData newSplitData) {
                DocumentPaneSettingsProcessor.this.save();
            }

            public void merged(@NotNull WebDocumentPane documentPane, @NotNull SplitData mergedSplit, @NotNull StructureData newStructureData) {
                DocumentPaneSettingsProcessor.this.save();
            }

            public void orientationChanged(@NotNull WebDocumentPane documentPane, @NotNull SplitData splitData) {
                DocumentPaneSettingsProcessor.this.save();
            }

            public void sidesSwapped(@NotNull WebDocumentPane documentPane, @NotNull SplitData splitData) {
                DocumentPaneSettingsProcessor.this.save();
            }

            public void dividerLocationChanged(@NotNull WebDocumentPane documentPane, @NotNull SplitData splitData) {
                DocumentPaneSettingsProcessor.this.save();
            }
        };
        documentPane.addDocumentPaneListener(this.documentPaneListener);
    }

    @Override
    protected void unregister(@NotNull WebDocumentPane documentPane) {
        documentPane.removeDocumentPaneListener(this.documentPaneListener);
        this.documentPaneListener = null;
        documentPane.removeDocumentListener(this.documentListener);
        this.documentListener = null;
    }

    @Override
    protected void loadSettings(@NotNull WebDocumentPane documentPane) {
        DocumentPaneState state = (DocumentPaneState)this.loadSettings();
        if (state != null) {
            documentPane.setDocumentPaneState(state);
        }
    }

    @Override
    protected void saveSettings(@NotNull WebDocumentPane documentPane) {
        this.saveSettings(documentPane.getDocumentPaneState());
    }
}

