/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tab;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.tab.DocumentDataListener;
import com.alee.utils.CollectionUtils;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;

public class DocumentData<C extends Component> {
    @Nullable
    protected EventListenerList listeners;
    @NotNull
    protected String id;
    @Nullable
    protected Icon icon;
    @NotNull
    protected String title;
    @Nullable
    protected Color foreground;
    @Nullable
    protected Color background;
    protected boolean closable;
    protected boolean draggable;
    @NotNull
    protected C component;

    public DocumentData(@NotNull String id, @NotNull String title, @NotNull C component2) {
        this(id, null, title, null, null, true, true, component2);
    }

    public DocumentData(@NotNull String id, @Nullable Icon icon, @NotNull String title, @NotNull C component2) {
        this(id, icon, title, null, null, true, true, component2);
    }

    public DocumentData(@NotNull String id, @Nullable Icon icon, @NotNull String title, @Nullable Color background, @NotNull C component2) {
        this(id, icon, title, null, background, true, true, component2);
    }

    public DocumentData(@NotNull String id, @Nullable Icon icon, @NotNull String title, @Nullable Color background, boolean closable, @NotNull C component2) {
        this(id, icon, title, null, background, closable, true, component2);
    }

    public DocumentData(@NotNull String id, @Nullable Icon icon, @NotNull String title, @Nullable Color background, boolean closable, boolean draggable, @NotNull C component2) {
        this(id, icon, title, null, background, closable, draggable, component2);
    }

    public DocumentData(@NotNull String id, @Nullable Icon icon, @NotNull String title, @Nullable Color foreground, @Nullable Color background, boolean closable, boolean draggable, @NotNull C component2) {
        this.id = id;
        this.icon = icon;
        this.title = title;
        this.foreground = foreground;
        this.background = background;
        this.closable = closable;
        this.draggable = draggable;
        this.component = component2;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(@NotNull String id) {
        this.id = id;
    }

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(@Nullable Icon icon) {
        this.icon = icon;
        this.fireTitleChanged();
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@NotNull String title) {
        this.title = title;
        this.fireTitleChanged();
    }

    @Nullable
    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(@Nullable Color foreground) {
        this.foreground = foreground;
        this.fireTitleChanged();
    }

    @Nullable
    public Color getBackground() {
        return this.background;
    }

    public void setBackground(@Nullable Color background) {
        Color old = this.background;
        this.background = background;
        this.fireBackgroundChanged(old, background);
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void setClosable(boolean closable) {
        this.closable = closable;
        this.fireTitleChanged();
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    @NotNull
    public C getComponent() {
        return this.component;
    }

    public void setComponent(@NotNull C component2) {
        C old = this.component;
        this.component = component2;
        this.fireContentChanged((Component)old, (Component)component2);
    }

    @NotNull
    public List<DocumentDataListener> getListeners() {
        return this.listeners != null ? CollectionUtils.asList(this.listeners.getListeners(DocumentDataListener.class)) : new ArrayList<DocumentDataListener>();
    }

    public void addListener(@NotNull DocumentDataListener listener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(DocumentDataListener.class, listener);
    }

    public void removeListener(@NotNull DocumentDataListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(DocumentDataListener.class, listener);
            if (this.listeners.getListenerCount() == 0) {
                this.listeners = null;
            }
        }
    }

    public void fireTitleChanged() {
        if (this.listeners != null) {
            for (DocumentDataListener listener : (DocumentDataListener[])this.listeners.getListeners(DocumentDataListener.class)) {
                listener.titleChanged(this);
            }
        }
    }

    public void fireBackgroundChanged(Color oldBackground, Color newBackground) {
        if (this.listeners != null) {
            for (DocumentDataListener listener : (DocumentDataListener[])this.listeners.getListeners(DocumentDataListener.class)) {
                listener.backgroundChanged(this, oldBackground, newBackground);
            }
        }
    }

    public void fireContentChanged(Component oldComponent, Component newComponent) {
        if (this.listeners != null) {
            for (DocumentDataListener listener : (DocumentDataListener[])this.listeners.getListeners(DocumentDataListener.class)) {
                listener.contentChanged(this, oldComponent, newComponent);
            }
        }
    }
}

