/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.split;

import com.alee.api.annotations.NotNull;
import com.alee.api.data.Orientation;
import com.alee.extended.WebContainer;
import com.alee.extended.split.OneTouchButton;
import com.alee.extended.split.WMultiSplitPaneDividerUI;
import com.alee.extended.split.WebMultiSplitPane;
import com.alee.laf.button.WebButton;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WebMultiSplitPaneDivider
extends WebContainer<WebMultiSplitPaneDivider, WMultiSplitPaneDividerUI> {
    protected final WebMultiSplitPane multiSplitPane;

    public WebMultiSplitPaneDivider(WebMultiSplitPane multiSplitPane) {
        this(StyleId.auto, multiSplitPane);
    }

    public WebMultiSplitPaneDivider(StyleId id, WebMultiSplitPane multiSplitPane) {
        this.multiSplitPane = multiSplitPane;
        this.updateUI();
        this.setStyleId(id);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.multisplitpanedivider;
    }

    public WebMultiSplitPane getMultiSplitPane() {
        return this.multiSplitPane;
    }

    public Orientation getOrientation() {
        return this.getMultiSplitPane().getOrientation().opposite();
    }

    public boolean isDragAvailable() {
        return this.getMultiSplitPane().getModel().isDragAvailable(this);
    }

    public WebButton getLeftOneTouchButton() {
        return this.getUI().getLeftOneTouchButton();
    }

    protected WebButton createLeftOneTouchButton() {
        OneTouchButton button = new OneTouchButton(StyleId.multisplitpanedividerOneTouchLeftButton.at(this), this);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebMultiSplitPaneDivider.this.multiSplitPane.getModel().toggleViewToRight(WebMultiSplitPaneDivider.this);
            }
        });
        return button;
    }

    public WebButton getRightOneTouchButton() {
        return this.getUI().getRightOneTouchButton();
    }

    protected WebButton createRightOneTouchButton() {
        OneTouchButton button = new OneTouchButton(StyleId.multisplitpanedividerOneTouchRightButton.at(this), this);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebMultiSplitPaneDivider.this.multiSplitPane.getModel().toggleViewToLeft(WebMultiSplitPaneDivider.this);
            }
        });
        return button;
    }

    @Override
    public WMultiSplitPaneDividerUI getUI() {
        return (WMultiSplitPaneDividerUI)this.ui;
    }

    public void setUI(WMultiSplitPaneDividerUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

