/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.split;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.Orientation;
import com.alee.extended.WebContainer;
import com.alee.extended.split.MultiSplitExpansionListener;
import com.alee.extended.split.MultiSplitPaneModel;
import com.alee.extended.split.MultiSplitResizeListener;
import com.alee.extended.split.MultiSplitState;
import com.alee.extended.split.MultiSplitView;
import com.alee.extended.split.WMultiSplitPaneUI;
import com.alee.extended.split.WebMultiSplitPaneDivider;
import com.alee.extended.split.WebMultiSplitPaneModel;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;

public class WebMultiSplitPane
extends WebContainer<WebMultiSplitPane, WMultiSplitPaneUI> {
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String CONTINUOUS_LAYOUT_PROPERTY = "continuousLayout";
    public static final String DIVIDER_SIZE_PROPERTY = "dividerSize";
    public static final String ONE_TOUCH_EXPANDABLE_PROPERTY = "oneTouchExpandable";
    public static final String MODEL_PROPERTY = "model";
    protected Orientation orientation;
    protected boolean continuousLayout;
    protected int dividerSize;
    protected boolean oneTouchExpandable;
    @Nullable
    protected MultiSplitPaneModel model;

    public WebMultiSplitPane() {
        this(StyleId.auto, Orientation.horizontal);
    }

    public WebMultiSplitPane(@Nullable Orientation orientation) {
        this(StyleId.auto, orientation);
    }

    public WebMultiSplitPane(@NotNull StyleId id) {
        this(id, Orientation.horizontal);
    }

    public WebMultiSplitPane(@NotNull StyleId id, @Nullable Orientation orientation) {
        this.setOrientation(orientation);
        this.setContinuousLayout(true);
        this.setDividerSize(11);
        this.setOneTouchExpandable(false);
        this.setModel(this.createModel());
        this.updateUI();
        this.setStyleId(id);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.multisplitpane;
    }

    @NotNull
    public Orientation getOrientation() {
        return this.orientation != null ? this.orientation : Orientation.horizontal;
    }

    @NotNull
    public WebMultiSplitPane setOrientation(@Nullable Orientation orientation) {
        if (this.orientation != orientation) {
            Orientation old = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange(ORIENTATION_PROPERTY, old, orientation);
        }
        return this;
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    @NotNull
    public WebMultiSplitPane setContinuousLayout(boolean continuousLayout) {
        if (this.continuousLayout != continuousLayout) {
            boolean old = this.continuousLayout;
            this.continuousLayout = continuousLayout;
            this.firePropertyChange(CONTINUOUS_LAYOUT_PROPERTY, old, continuousLayout);
        }
        return this;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    @NotNull
    public WebMultiSplitPane setDividerSize(int size) {
        if (this.dividerSize != size) {
            int old = this.dividerSize;
            this.dividerSize = size;
            this.firePropertyChange(DIVIDER_SIZE_PROPERTY, old, size);
        }
        return this;
    }

    public boolean isOneTouchExpandable() {
        return this.oneTouchExpandable;
    }

    @NotNull
    public WebMultiSplitPane setOneTouchExpandable(boolean oneTouchExpandable) {
        if (this.oneTouchExpandable != oneTouchExpandable) {
            boolean old = this.oneTouchExpandable;
            this.oneTouchExpandable = oneTouchExpandable;
            this.firePropertyChange(ONE_TOUCH_EXPANDABLE_PROPERTY, old, oneTouchExpandable);
        }
        return this;
    }

    @Nullable
    public MultiSplitPaneModel getModel() {
        return this.model;
    }

    @NotNull
    protected MultiSplitPaneModel createModel() {
        return new WebMultiSplitPaneModel();
    }

    @NotNull
    public WebMultiSplitPane setModel(@Nullable MultiSplitPaneModel model) {
        if (this.model != model) {
            List<WebMultiSplitPaneDivider> dividers;
            MultiSplitPaneModel old = this.model;
            List<MultiSplitView> views = old != null ? old.getViews() : null;
            List<WebMultiSplitPaneDivider> list = dividers = old != null ? old.getDividers() : null;
            if (this.model != null) {
                this.model.uninstall(this);
            }
            this.model = model;
            this.setLayout(model);
            if (model != null) {
                model.install(this, views, dividers);
            }
            this.firePropertyChange(MODEL_PROPERTY, old, model);
        }
        return this;
    }

    @Override
    public void setLayout(@Nullable LayoutManager layout) {
        if (layout != null && !(layout instanceof MultiSplitPaneModel)) {
            throw new IllegalArgumentException("Only MultiSplitPaneModel instances are supported");
        }
        super.setLayout(layout);
    }

    @Override
    @Nullable
    public MultiSplitPaneModel getLayout() {
        return (MultiSplitPaneModel)super.getLayout();
    }

    public int getViewCount() {
        return this.getModel() != null ? this.getModel().getViewCount() : 0;
    }

    @Nullable
    public List<MultiSplitView> getViews() {
        return this.getModel() != null ? this.getModel().getViews() : null;
    }

    public int getViewIndex(@NotNull Component component2) {
        return this.getModel() != null ? this.getModel().getViewIndex(component2) : -1;
    }

    @Nullable
    public Component getViewComponent(int index) {
        return this.getModel() != null ? this.getModel().getViewComponent(index) : null;
    }

    @NotNull
    public List<Component> getViewComponents() {
        return this.getModel() != null ? this.getModel().getViewComponents() : new ArrayList();
    }

    @NotNull
    public List<WebMultiSplitPaneDivider> getDividers() {
        return this.getModel() != null ? this.getModel().getDividers() : new ArrayList();
    }

    @NotNull
    protected WebMultiSplitPaneDivider createDivider() {
        StyleId styleId = StyleId.multisplitpaneContinuousDivider.at(this);
        return new WebMultiSplitPaneDivider(styleId, this);
    }

    @Nullable
    public MultiSplitState getMultiSplitState() {
        return this.getModel() != null ? this.getModel().getMultiSplitState() : null;
    }

    public void setMultiSplitState(@NotNull MultiSplitState state) {
        if (this.getModel() != null) {
            this.getModel().setMultiSplitState(state);
        }
    }

    public void resetViewSizes() {
        if (this.getModel() != null) {
            this.getModel().resetViewStates();
        }
    }

    public boolean isAnyViewExpanded() {
        return this.getModel() != null && this.getModel().isAnyViewExpanded();
    }

    public int getExpandedViewIndex() {
        return this.getModel() != null ? this.getModel().getExpandedViewIndex() : -1;
    }

    public void expandView(int index) {
        if (this.getModel() != null) {
            this.getModel().expandView(index);
        }
    }

    public void collapseExpandedView() {
        if (this.getModel() != null) {
            this.getModel().collapseExpandedView();
        }
    }

    public void toggleViewExpansion(int index) {
        if (this.getModel() != null) {
            this.getModel().toggleViewExpansion(index);
        }
    }

    @Override
    public Component add(@NotNull Component component2) {
        if (component2 instanceof WebMultiSplitPaneDivider) {
            throw new IllegalArgumentException("Dividers cannot be added explicitely");
        }
        this.addImpl(component2, null, this.getViewCount());
        return component2;
    }

    @Override
    public Component add(@Nullable String constraints, @NotNull Component component2) {
        if (component2 instanceof WebMultiSplitPaneDivider) {
            throw new IllegalArgumentException("Dividers cannot be added explicitely");
        }
        this.addImpl(component2, constraints, this.getViewCount());
        return component2;
    }

    @Override
    public Component add(@NotNull Component component2, int index) {
        if (component2 instanceof WebMultiSplitPaneDivider) {
            throw new IllegalArgumentException("Dividers cannot be added explicitely");
        }
        if (index > this.getViewCount()) {
            throw new IndexOutOfBoundsException("Illegal view component index");
        }
        this.addImpl(component2, null, index);
        return component2;
    }

    @Override
    public void add(@NotNull Component component2, @Nullable Object constraints) {
        if (component2 instanceof WebMultiSplitPaneDivider) {
            throw new IllegalArgumentException("Dividers cannot be added explicitely");
        }
        this.addImpl(component2, constraints, this.getViewCount());
    }

    @Override
    public void add(@NotNull Component component2, @Nullable Object constraints, int index) {
        if (component2 instanceof WebMultiSplitPaneDivider) {
            throw new IllegalArgumentException("Dividers cannot be added explicitely");
        }
        if (index > this.getViewCount()) {
            throw new IndexOutOfBoundsException("Illegal view component index");
        }
        this.addImpl(component2, constraints, index);
    }

    @Override
    protected void addImpl(@NotNull Component component2, @Nullable Object constraints, int index) {
        super.addImpl(component2, constraints, index);
    }

    @Override
    public void setComponentZOrder(@NotNull Component component2, int index) {
        if (component2 instanceof WebMultiSplitPaneDivider) {
            throw new IllegalArgumentException("Dividers order cannot be modified explicitely");
        }
        if (index > this.getViewCount()) {
            throw new IndexOutOfBoundsException("Illegal view component index");
        }
        this.setComponentZOrderImpl(component2, index);
        if (this.getModel() != null) {
            this.getModel().moveComponent(component2, index);
        }
    }

    protected void setComponentZOrderImpl(@NotNull Component component2, int index) {
        super.setComponentZOrder(component2, index);
    }

    @Override
    public void remove(int index) {
        if (index < 0 || this.getViewCount() <= index) {
            throw new IndexOutOfBoundsException("There is no view component at specified index");
        }
        if (this.getComponent(index) instanceof WebMultiSplitPaneDivider) {
            throw new IllegalArgumentException("Dividers cannot be added explicitely");
        }
        this.removeImpl(index);
    }

    protected void removeImpl(int index) {
        super.remove(index);
    }

    @Override
    public void removeAll() {
        for (int index = this.getViewCount() - 1; index >= 0; --index) {
            this.remove(index);
        }
    }

    public void addResizeListener(@NotNull MultiSplitResizeListener listener) {
        this.listenerList.add(MultiSplitResizeListener.class, listener);
    }

    public void removeResizeListener(@NotNull MultiSplitResizeListener listener) {
        this.listenerList.remove(MultiSplitResizeListener.class, listener);
    }

    public void fireViewResizeStarted(@NotNull WebMultiSplitPaneDivider divider) {
        for (MultiSplitResizeListener listener : (MultiSplitResizeListener[])this.listenerList.getListeners(MultiSplitResizeListener.class)) {
            listener.viewResizeStarted(this, divider);
        }
    }

    public void fireViewResized(@NotNull WebMultiSplitPaneDivider divider) {
        for (MultiSplitResizeListener listener : (MultiSplitResizeListener[])this.listenerList.getListeners(MultiSplitResizeListener.class)) {
            listener.viewResized(this, divider);
        }
    }

    public void fireViewResizeEnded(@NotNull WebMultiSplitPaneDivider divider) {
        for (MultiSplitResizeListener listener : (MultiSplitResizeListener[])this.listenerList.getListeners(MultiSplitResizeListener.class)) {
            listener.viewResizeEnded(this, divider);
        }
    }

    public void fireViewSizeAdjusted() {
        for (MultiSplitResizeListener listener : (MultiSplitResizeListener[])this.listenerList.getListeners(MultiSplitResizeListener.class)) {
            listener.viewSizeAdjusted(this);
        }
    }

    public void addExpansionListener(@NotNull MultiSplitExpansionListener listener) {
        this.listenerList.add(MultiSplitExpansionListener.class, listener);
    }

    public void removeExpansionListener(@NotNull MultiSplitExpansionListener listener) {
        this.listenerList.remove(MultiSplitExpansionListener.class, listener);
    }

    public void fireViewExpanded(@NotNull Component view) {
        for (MultiSplitExpansionListener listener : (MultiSplitExpansionListener[])this.listenerList.getListeners(MultiSplitExpansionListener.class)) {
            listener.viewExpanded(this, view);
        }
    }

    public void fireViewCollapsed(@NotNull Component view) {
        for (MultiSplitExpansionListener listener : (MultiSplitExpansionListener[])this.listenerList.getListeners(MultiSplitExpansionListener.class)) {
            listener.viewCollapsed(this, view);
        }
    }

    @Override
    @Nullable
    public WMultiSplitPaneUI getUI() {
        return (WMultiSplitPaneUI)this.ui;
    }

    public void setUI(@Nullable WMultiSplitPaneUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

