/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.split;

import com.alee.api.annotations.NotNull;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.extended.split.WebMultiSplitPaneDivider;
import com.alee.laf.button.WebButton;
import com.alee.utils.SwingUtils;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class MultiSplitPaneDividerLayout
extends AbstractLayoutManager {
    @Override
    public void layoutContainer(@NotNull Container container) {
        WebMultiSplitPaneDivider divider = (WebMultiSplitPaneDivider)container;
        WebButton leftButton = divider.getLeftOneTouchButton();
        WebButton rightButton = divider.getRightOneTouchButton();
        if (leftButton != null && rightButton != null) {
            if (divider.getMultiSplitPane().isOneTouchExpandable()) {
                Insets insets = divider.getInsets();
                Dimension lps = leftButton.getPreferredSize();
                Dimension rps = rightButton.getPreferredSize();
                if (divider.getOrientation().isHorizontal()) {
                    int y;
                    boolean ltr = divider.getComponentOrientation().isLeftToRight();
                    int dividerHeight = divider.getHeight() - (insets != null ? insets.top + insets.bottom : 0);
                    int n = y = insets != null ? insets.top : 0;
                    if (ltr) {
                        int x = insets != null ? insets.left : 0;
                        leftButton.setBounds(x, y, lps.width, dividerHeight);
                        rightButton.setBounds(x + lps.width, y, rps.width, dividerHeight);
                    } else {
                        int x = divider.getWidth() - lps.width - rps.width - (insets != null ? insets.right : 0);
                        rightButton.setBounds(x, y, rps.width, dividerHeight);
                        leftButton.setBounds(x + rps.width, y, lps.width, dividerHeight);
                    }
                } else {
                    int x = insets != null ? insets.left : 0;
                    int y = insets != null ? insets.top : 0;
                    int dividerWidth = divider.getWidth() - (insets != null ? insets.left + insets.right : 0);
                    leftButton.setBounds(x, y, dividerWidth, lps.height);
                    rightButton.setBounds(x, y + lps.height, dividerWidth, rps.height);
                }
                leftButton.setVisible(true);
                rightButton.setVisible(true);
            } else {
                leftButton.setVisible(false);
                rightButton.setVisible(false);
            }
        }
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        Dimension ps;
        WebMultiSplitPaneDivider divider = (WebMultiSplitPaneDivider)container;
        WebButton leftButton = divider.getLeftOneTouchButton();
        WebButton rightButton = divider.getRightOneTouchButton();
        Dimension buttonSize = null;
        if (divider.getMultiSplitPane().isOneTouchExpandable()) {
            if (leftButton != null) {
                buttonSize = leftButton.getPreferredSize();
            }
            if (rightButton != null) {
                buttonSize = SwingUtils.max(buttonSize, rightButton.getPreferredSize());
            }
        }
        Insets insets = divider.getInsets();
        int dividerWidth = 0;
        if (divider.getOrientation().isHorizontal()) {
            if (buttonSize != null) {
                int size = buttonSize.height;
                if (insets != null) {
                    size += insets.top + insets.bottom;
                }
                dividerWidth = Math.max(dividerWidth, size);
            }
            ps = new Dimension(1, dividerWidth);
        } else {
            if (buttonSize != null) {
                int size = buttonSize.width;
                if (insets != null) {
                    size += insets.left + insets.right;
                }
                dividerWidth = Math.max(dividerWidth, size);
            }
            ps = new Dimension(dividerWidth, 1);
        }
        return ps;
    }
}

