/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.panel;

import com.alee.api.annotations.NotNull;
import com.alee.extended.layout.ComponentPanelLayout;
import com.alee.extended.panel.ComponentReorderListener;
import com.alee.extended.panel.WebSelectablePanel;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.style.StyleId;
import com.alee.utils.CollectionUtils;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WebComponentPane
extends WebPanel {
    private final List<ComponentReorderListener> listeners = new ArrayList<ComponentReorderListener>(1);
    protected final WebPanel container;
    protected final Map<Component, WebSelectablePanel> components = new LinkedHashMap<Component, WebSelectablePanel>();
    protected boolean reorderingAllowed = false;
    protected boolean showReorderGrippers = true;
    protected boolean upDownHotkeysAllowed = true;
    protected boolean leftRightHotkeysAllowed = false;

    public WebComponentPane() {
        super(StyleId.componentpane);
        this.container = new WebPanel();
        this.container.setLayout(new ComponentPanelLayout());
        this.add((Component)this.container, (Object)"Center");
        HotkeyRunnable prevAction = new HotkeyRunnable(){

            @Override
            public void run(@NotNull KeyEvent e) {
                if (WebComponentPane.this.upDownHotkeysAllowed && Hotkey.UP.isTriggered(e) || WebComponentPane.this.leftRightHotkeysAllowed && Hotkey.LEFT.isTriggered(e)) {
                    int index = WebComponentPane.this.getFocusedElementIndex();
                    if (index == -1) {
                        WebComponentPane.this.focusElement(WebComponentPane.this.getElementCount() - 1);
                    } else {
                        WebComponentPane.this.focusElement(index > 0 ? index - 1 : WebComponentPane.this.getElementCount() - 1);
                    }
                }
            }
        };
        HotkeyManager.registerHotkey((Component)this, this, Hotkey.UP, prevAction);
        HotkeyManager.registerHotkey((Component)this, this, Hotkey.LEFT, prevAction);
        HotkeyRunnable nextAction = new HotkeyRunnable(){

            @Override
            public void run(@NotNull KeyEvent e) {
                if (WebComponentPane.this.upDownHotkeysAllowed && Hotkey.DOWN.isTriggered(e) || WebComponentPane.this.leftRightHotkeysAllowed && Hotkey.RIGHT.isTriggered(e)) {
                    int index = WebComponentPane.this.getFocusedElementIndex();
                    if (index == -1) {
                        WebComponentPane.this.focusElement(0);
                    } else {
                        WebComponentPane.this.focusElement(index < WebComponentPane.this.getElementCount() - 1 ? index + 1 : 0);
                    }
                }
            }
        };
        HotkeyManager.registerHotkey((Component)this, this, Hotkey.DOWN, nextAction);
        HotkeyManager.registerHotkey((Component)this, this, Hotkey.RIGHT, nextAction);
    }

    public WebPanel getContainer() {
        return this.container;
    }

    public ComponentPanelLayout getContainerLayout() {
        return (ComponentPanelLayout)this.container.getLayout();
    }

    public boolean isUpDownHotkeysAllowed() {
        return this.upDownHotkeysAllowed;
    }

    public void setUpDownHotkeysAllowed(boolean upDownHotkeysAllowed) {
        this.upDownHotkeysAllowed = upDownHotkeysAllowed;
    }

    public boolean isLeftRightHotkeysAllowed() {
        return this.leftRightHotkeysAllowed;
    }

    public void setLeftRightHotkeysAllowed(boolean leftRightHotkeysAllowed) {
        this.leftRightHotkeysAllowed = leftRightHotkeysAllowed;
    }

    public WebSelectablePanel addElement(Component component2) {
        if (this.components.containsKey(component2)) {
            return this.components.get(component2);
        }
        WebSelectablePanel element = new WebSelectablePanel(this);
        element.add(component2, (Object)"Center");
        this.container.add((Component)element, (Object)"");
        this.components.put(component2, element);
        return element;
    }

    public void removeElement(int index) {
        this.removeElement(this.getElement(index));
    }

    public void removeElement(WebSelectablePanel element) {
        for (Component component2 : this.components.keySet()) {
            if (this.components.get(component2) != element) continue;
            this.removeElement(component2);
            break;
        }
    }

    public void removeElement(Component component2) {
        WebSelectablePanel element = this.components.get(component2);
        this.container.remove((Component)element);
        this.components.remove(component2);
    }

    public int getElementCount() {
        return this.components.size();
    }

    public WebSelectablePanel getElement(int index) {
        return (WebSelectablePanel)this.getContainerLayout().getComponent(index);
    }

    public WebSelectablePanel getFocusedElement() {
        for (Component component2 : this.getContainerLayout().getComponents()) {
            WebSelectablePanel selectablePanel = (WebSelectablePanel)component2;
            if (!selectablePanel.isFocused()) continue;
            return selectablePanel;
        }
        return null;
    }

    public int getFocusedElementIndex() {
        return this.getContainerLayout().indexOf(this.getFocusedElement());
    }

    public void focusElement(int index) {
        this.getElement(index).transferFocus();
    }

    public boolean isReorderingAllowed() {
        return this.reorderingAllowed;
    }

    public void setReorderingAllowed(boolean reorderingAllowed) {
        this.reorderingAllowed = reorderingAllowed;
    }

    public boolean isShowReorderGrippers() {
        return this.showReorderGrippers;
    }

    public void setShowReorderGrippers(boolean showReorderGrippers) {
        this.showReorderGrippers = showReorderGrippers;
    }

    public void addComponentReorderListener(ComponentReorderListener listener) {
        this.listeners.add(listener);
    }

    public void removeComponentReorderListener(ComponentReorderListener listener) {
        this.listeners.remove(listener);
    }

    public void fireComponentOrderChanged(Component component2, int oldIndex, int newIndex) {
        for (ComponentReorderListener listener : CollectionUtils.copy(this.listeners)) {
            listener.componentOrderChanged(component2, oldIndex, newIndex);
        }
    }
}

