/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.overlay;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.canvas.WebCanvas;
import com.alee.extended.overlay.FillOverlay;
import com.alee.extended.overlay.WebOverlay;
import com.alee.managers.style.StyleId;
import javax.swing.JComponent;

public class WebProgressOverlay
extends WebOverlay {
    @NotNull
    protected final WebCanvas progressLayer = this.createProgressLayer();

    public WebProgressOverlay() {
        this(StyleId.auto);
    }

    public WebProgressOverlay(@Nullable JComponent content) {
        this(StyleId.auto, content);
    }

    public WebProgressOverlay(@NotNull StyleId id) {
        this(id, null);
    }

    public WebProgressOverlay(@NotNull StyleId id, @Nullable JComponent content) {
        super(id, content);
        this.addOverlay(new FillOverlay(this.progressLayer));
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.progressoverlay;
    }

    @NotNull
    protected WebCanvas createProgressLayer() {
        return new WebCanvas(StyleId.progressoverlayLayer.at(this), new String[0]);
    }

    public boolean isProgressDisplayed() {
        return this.progressLayer.hasState("progress");
    }

    public void displayProgress() {
        this.progressLayer.addStates("progress");
    }

    public void hideProgress() {
        this.progressLayer.removeStates("progress");
    }
}

