/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.overlay;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.behavior.OmitOnClone;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.extended.canvas.WebCanvas;
import com.alee.managers.animation.easing.Cubic;
import com.alee.managers.animation.easing.Linear;
import com.alee.managers.animation.transition.QueueTransition;
import com.alee.managers.animation.transition.TimedTransition;
import com.alee.managers.animation.transition.Transition;
import com.alee.managers.animation.transition.TransitionAdapter;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractBackground;
import com.alee.painter.decoration.background.IBackground;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

@XStreamAlias(value="ProgressOverlayBackground")
public class ProgressOverlayBackground<C extends WebCanvas, D extends IDecoration<C, D>, I extends ProgressOverlayBackground<C, D, I>>
extends AbstractBackground<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected Integer width;
    @XStreamAsAttribute
    @Nullable
    protected Color color;
    @XStreamImplicit
    private List<IBackground> backgrounds;
    @OmitOnClone
    @OmitOnMerge
    protected transient float currentOpacity;
    @OmitOnClone
    @OmitOnMerge
    protected transient PropertyChangeListener statesListener;
    @OmitOnClone
    @OmitOnMerge
    @Nullable
    protected transient AnimationState state;
    @OmitOnClone
    @OmitOnMerge
    @Nullable
    protected transient QueueTransition opacityTransition;
    @OmitOnClone
    @OmitOnMerge
    protected transient int position;
    @OmitOnClone
    @OmitOnMerge
    @Nullable
    protected transient QueueTransition positionTransition;

    @Override
    public void activate(@NotNull C c, @NotNull D d) {
        this.currentOpacity = 0.0f;
        this.state = AnimationState.awaiting;
        this.statesListener = new PropertyChangeListener((WebCanvas)c, (IDecoration)d){
            final /* synthetic */ WebCanvas val$c;
            final /* synthetic */ IDecoration val$d;
            {
                this.val$c = webCanvas;
                this.val$d = iDecoration;
            }

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (this.val$c.getStates().contains("progress")) {
                    if (ProgressOverlayBackground.this.state == AnimationState.awaiting || ProgressOverlayBackground.this.state == AnimationState.hiding) {
                        ProgressOverlayBackground.this.playAnimation(this.val$c, this.val$d, true);
                    }
                } else if (ProgressOverlayBackground.this.state == AnimationState.displaying || ProgressOverlayBackground.this.state == AnimationState.animating) {
                    ProgressOverlayBackground.this.stopAnimation(this.val$c, this.val$d, true);
                }
            }
        };
        ((Container)c).addPropertyChangeListener("decorationStates", this.statesListener);
        if (((WebCanvas)c).getStates().contains("progress")) {
            this.playAnimation(c, d, false);
        }
    }

    @Override
    public void deactivate(@NotNull C c, @NotNull D d) {
        ((Component)c).removePropertyChangeListener("decorationStates", this.statesListener);
        this.statesListener = null;
        this.stopAnimation(c, d, false);
    }

    @Override
    public float getOpacity(@NotNull C c, @NotNull D d) {
        return this.opacity != null ? this.opacity.floatValue() : 0.5f;
    }

    public int getWidth(@NotNull C c, @NotNull D d) {
        if (this.width == null) {
            throw new DecorationException("Progress line width must be specified");
        }
        if (this.width <= 0) {
            throw new DecorationException("Progress line width must be greater than zero");
        }
        return this.width;
    }

    @NotNull
    public Color getColor(@NotNull C c, @NotNull D d) {
        if (this.color == null) {
            throw new DecorationException("Progress color must be specified");
        }
        return this.color;
    }

    @Nullable
    protected List<IBackground> getBackgrounds(@NotNull C c, @NotNull D d) {
        return this.backgrounds;
    }

    protected void playAnimation(final @NotNull C c, @NotNull D d, boolean adjustOpacity) {
        AnimationState animationState = this.state = adjustOpacity ? AnimationState.displaying : AnimationState.animating;
        if (this.opacityTransition != null) {
            this.opacityTransition.stop();
            this.opacityTransition = null;
        }
        if (adjustOpacity) {
            this.opacityTransition = new QueueTransition(false, new Transition[0]);
            this.opacityTransition.add(new TimedTransition<Float>(Float.valueOf(this.currentOpacity), Float.valueOf(this.getOpacity(c, d)), new Cubic.Out(), 600L));
            this.opacityTransition.addListener(new TransitionAdapter<Float>(){

                @Override
                public void adjusted(Transition transition, Float value) {
                    ProgressOverlayBackground.this.currentOpacity = value.floatValue();
                    c.repaint();
                }

                @Override
                public void finished(Transition transition, Float value) {
                    ProgressOverlayBackground.this.state = AnimationState.animating;
                }
            });
            this.opacityTransition.play();
        } else {
            this.currentOpacity = this.getOpacity(c, d);
        }
        if (this.positionTransition == null) {
            this.position = 0;
            this.positionTransition = new QueueTransition(true, new Transition[0]);
            this.positionTransition.add(new TimedTransition<Integer>(0, this.getWidth(c, d) * 2, new Linear(), 600L));
            this.positionTransition.addListener(new TransitionAdapter<Integer>(){

                @Override
                public void adjusted(Transition transition, Integer value) {
                    ProgressOverlayBackground.this.position = value;
                    c.repaint();
                }
            });
            this.positionTransition.play();
        }
    }

    protected void stopAnimation(final @NotNull C c, @NotNull D d, boolean adjustOpacity) {
        if (this.opacityTransition != null) {
            this.opacityTransition.stop();
            this.opacityTransition = null;
        }
        if (adjustOpacity) {
            this.opacityTransition = new QueueTransition(false, new Transition[0]);
            this.opacityTransition.add(new TimedTransition<Float>(Float.valueOf(this.currentOpacity), Float.valueOf(0.0f), new Cubic.Out(), 400L));
            this.opacityTransition.addListener(new TransitionAdapter<Float>(){

                @Override
                public void adjusted(Transition transition, Float value) {
                    ProgressOverlayBackground.this.currentOpacity = value.floatValue();
                    c.repaint();
                }

                @Override
                public void finished(Transition transition, Float value) {
                    if (ProgressOverlayBackground.this.positionTransition != null) {
                        ProgressOverlayBackground.this.positionTransition.stop();
                        ProgressOverlayBackground.this.positionTransition = null;
                        ProgressOverlayBackground.this.position = 0;
                    }
                    ProgressOverlayBackground.this.opacityTransition = null;
                    ProgressOverlayBackground.this.state = AnimationState.awaiting;
                }
            });
            this.opacityTransition.play();
        } else if (this.positionTransition != null) {
            this.positionTransition.stop();
            this.positionTransition = null;
            this.position = 0;
        }
        this.state = adjustOpacity ? AnimationState.hiding : AnimationState.awaiting;
        this.currentOpacity = 0.0f;
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d, @NotNull Shape shape) {
        if (this.currentOpacity > 0.0f) {
            Rectangle shapeBounds = shape.getBounds();
            int w = shapeBounds.width;
            int h = shapeBounds.height;
            if (w > 0 && h > 0) {
                Object aa = GraphicsUtils.setupAntialias(g2d);
                Shape oldClip = GraphicsUtils.intersectClip(g2d, shape);
                Composite oc = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(this.currentOpacity), this.currentOpacity < 1.0f);
                List<IBackground> backgrounds = this.getBackgrounds(c, d);
                if (CollectionUtils.notEmpty(backgrounds)) {
                    for (IBackground background : backgrounds) {
                        background.paint(g2d, bounds, c, d, shape);
                    }
                }
                Paint oldPaint = GraphicsUtils.setupPaint(g2d, this.getColor(c, d));
                int x = shapeBounds.x;
                int y = shapeBounds.y;
                int pw = this.getWidth(c, d);
                for (int i = this.position % (pw * 2); i < w + 2 * h; i += pw * 2) {
                    if (i <= 0) continue;
                    GeneralPath gp = new GeneralPath(0);
                    gp.moveTo(x + (i < w ? i : w), y + (i < w ? 0 : Math.min(h, i - w)));
                    if (i - pw < w && i > w) {
                        gp.lineTo(x + w, y);
                    }
                    gp.lineTo(x + (i - pw < w ? Math.max(0, i - pw) : w), y + (i - pw < w ? 0 : i - pw - w));
                    gp.lineTo(x + (i - pw < h ? 0 : i - pw - h), y + (i - pw < h ? Math.max(0, i - pw) : h));
                    if (i - pw < h && i > h) {
                        gp.lineTo(x, y + h);
                    }
                    gp.lineTo(x + (i < h ? 0 : Math.min(w, i - h)), y + (i < h ? i : h));
                    gp.closePath();
                    g2d.fill(gp);
                }
                GraphicsUtils.restorePaint(g2d, oldPaint);
                GraphicsUtils.restoreComposite(g2d, oc, this.currentOpacity < 1.0f);
                GraphicsUtils.restoreClip(g2d, oldClip);
                GraphicsUtils.restoreAntialias(g2d, aa);
            }
        }
    }

    protected static enum AnimationState {
        awaiting,
        displaying,
        animating,
        hiding;

    }
}

