/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.overlay;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.BoxOrientation;
import com.alee.extended.overlay.AbstractOverlay;
import com.alee.extended.overlay.WebOverlay;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class AlignedOverlay
extends AbstractOverlay {
    @NotNull
    protected BoxOrientation halign;
    @NotNull
    protected BoxOrientation valign;

    public AlignedOverlay(@NotNull JComponent component2, @NotNull BoxOrientation halign, @NotNull BoxOrientation valign) {
        this(component2, halign, valign, new Insets(0, 0, 0, 0));
    }

    public AlignedOverlay(@NotNull JComponent component2, @NotNull BoxOrientation halign, @NotNull BoxOrientation valign, @NotNull Insets margin) {
        super(component2, margin);
        this.halign = halign;
        this.valign = valign;
    }

    @Override
    @NotNull
    public Rectangle bounds(@NotNull WebOverlay container, @Nullable JComponent component2, @NotNull Rectangle bounds) {
        int y;
        int x;
        JComponent overlay = this.component();
        Dimension ps = overlay.getPreferredSize();
        switch (this.halign) {
            case left: {
                x = bounds.x;
                break;
            }
            default: {
                x = bounds.x + bounds.width / 2 - ps.width / 2;
                break;
            }
            case right: {
                x = bounds.x + bounds.width - ps.width;
            }
        }
        switch (this.valign) {
            case top: {
                y = bounds.y;
                break;
            }
            default: {
                y = bounds.y + bounds.height / 2 - ps.height / 2;
                break;
            }
            case bottom: {
                y = bounds.y + bounds.height - ps.height;
            }
        }
        return new Rectangle(x, y, ps.width, ps.height);
    }
}

