/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.memorybar;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.extended.memorybar.MemoryBarInputListener;
import com.alee.extended.memorybar.WMemoryBarUI;
import com.alee.extended.memorybar.WebMemoryBar;
import com.alee.laf.AbstractUIInputListener;
import com.alee.laf.UIAction;
import com.alee.laf.UIActionMap;
import com.alee.utils.LafLookup;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class WMemoryBarInputListener<C extends WebMemoryBar, U extends WMemoryBarUI<C>>
extends AbstractUIInputListener<C, U>
implements MemoryBarInputListener<C>,
MouseListener,
MouseMotionListener,
FocusListener,
AncestorListener {
    @Override
    public void install(@NotNull C component2) {
        super.install(component2);
        ((Component)component2).addMouseListener(this);
        ((Component)component2).addMouseMotionListener(this);
        ((Component)component2).addFocusListener(this);
        ((JComponent)component2).addAncestorListener(this);
        UIActionMap actionMap = new UIActionMap();
        actionMap.put(new Action<C>(component2, "pressed"));
        actionMap.put(new Action<C>(component2, "released"));
        SwingUtilities.replaceUIActionMap(component2, actionMap);
        InputMap inputMap = LafLookup.getInputMap(component2, 0);
        SwingUtilities.replaceUIInputMap(component2, 0, inputMap);
    }

    @Override
    public void uninstall(@NotNull C component2) {
        SwingUtilities.replaceUIInputMap(component2, 2, null);
        SwingUtilities.replaceUIInputMap(component2, 0, null);
        SwingUtilities.replaceUIActionMap(component2, null);
        ((JComponent)component2).removeAncestorListener(this);
        ((Component)component2).removeFocusListener(this);
        ((Component)component2).removeMouseMotionListener(this);
        ((Component)component2).removeMouseListener(this);
        super.uninstall(component2);
    }

    @Override
    public void focusGained(@NotNull FocusEvent event) {
    }

    @Override
    public void focusLost(@NotNull FocusEvent event) {
        WebMemoryBar memoryBar = (WebMemoryBar)event.getSource();
        ButtonModel model = memoryBar.getModel();
        model.setPressed(false);
        model.setArmed(false);
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent event) {
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent event) {
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent event) {
    }

    @Override
    public void mousePressed(@NotNull MouseEvent event) {
        WebMemoryBar memoryBar = (WebMemoryBar)event.getSource();
        if (SwingUtilities.isLeftMouseButton(event) && memoryBar.contains(event.getX(), event.getY())) {
            ButtonModel model = memoryBar.getModel();
            if (model.isEnabled()) {
                if (!model.isArmed()) {
                    model.setArmed(true);
                }
                model.setPressed(true);
            }
            if (memoryBar.isEnabled() && !memoryBar.hasFocus() && memoryBar.isRequestFocusEnabled()) {
                memoryBar.requestFocus();
            }
        }
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent event) {
        WebMemoryBar memoryBar = (WebMemoryBar)event.getSource();
        if (SwingUtilities.isLeftMouseButton(event)) {
            ButtonModel model = memoryBar.getModel();
            model.setPressed(false);
            model.setArmed(false);
        }
    }

    @Override
    public void mouseEntered(@NotNull MouseEvent event) {
        WebMemoryBar memoryBar = (WebMemoryBar)event.getSource();
        ButtonModel model = memoryBar.getModel();
        if (!SwingUtilities.isLeftMouseButton(event)) {
            model.setRollover(true);
        }
        if (model.isPressed()) {
            model.setArmed(true);
        }
    }

    @Override
    public void mouseExited(@NotNull MouseEvent event) {
        WebMemoryBar memoryBar = (WebMemoryBar)event.getSource();
        ButtonModel model = memoryBar.getModel();
        model.setRollover(false);
        model.setArmed(false);
    }

    @Override
    public void ancestorAdded(@NotNull AncestorEvent event) {
        WebMemoryBar memoryBar = (WebMemoryBar)event.getSource();
        memoryBar.getModel().setRollover(false);
    }

    @Override
    public void ancestorRemoved(@NotNull AncestorEvent event) {
        WebMemoryBar memoryBar = (WebMemoryBar)event.getSource();
        memoryBar.getModel().setRollover(false);
    }

    @Override
    public void ancestorMoved(@NotNull AncestorEvent event) {
        WebMemoryBar memoryBar = (WebMemoryBar)event.getSource();
        memoryBar.getModel().setRollover(false);
    }

    public static class Action<M extends WebMemoryBar>
    extends UIAction<M> {
        public static final String PRESSED = "pressed";
        public static final String RELEASED = "released";

        public Action(@NotNull M memoryBar, @NotNull String name) {
            super(memoryBar, name);
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            WebMemoryBar memoryBar = (WebMemoryBar)this.getComponent();
            String action = this.getName();
            if (Objects.equals((Object)action, (Object)PRESSED)) {
                ButtonModel model = memoryBar.getModel();
                model.setArmed(true);
                model.setPressed(true);
                if (!memoryBar.hasFocus()) {
                    memoryBar.requestFocus();
                }
            } else if (Objects.equals((Object)action, (Object)RELEASED)) {
                ButtonModel model = memoryBar.getModel();
                model.setPressed(false);
                model.setArmed(false);
            }
        }

        @Override
        public boolean isEnabled() {
            WebMemoryBar memoryBar = (WebMemoryBar)this.getComponent();
            return memoryBar == null || memoryBar.getModel().isEnabled();
        }
    }
}

