/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.memorybar;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.memorybar.WebMemoryBar;
import com.alee.graphics.data.Line;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractBackground;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.MathUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.lang.management.MemoryUsage;

@XStreamAlias(value="MemoryBarBackground")
public class MemoryBarBackground<C extends WebMemoryBar, D extends IDecoration<C, D>, I extends MemoryBarBackground<C, D, I>>
extends AbstractBackground<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected Integer round;
    @XStreamAsAttribute
    @Nullable
    protected Color usedBorderColor;
    @XStreamAsAttribute
    @Nullable
    protected Color usedFillColor;
    @XStreamAsAttribute
    @Nullable
    protected Color allocatedMarkColor;

    @Override
    @NotNull
    public String getId() {
        return this.id != null ? this.id : "memory-background";
    }

    protected int getRound(@NotNull C c, @NotNull D d) {
        if (this.round == null) {
            throw new DecorationException("Round must be specified");
        }
        return this.round;
    }

    @NotNull
    protected Color getUsedBorderColor(@NotNull C c, @NotNull D d) {
        if (this.usedBorderColor == null) {
            throw new DecorationException("Used border color must be specified");
        }
        return this.usedBorderColor;
    }

    @NotNull
    protected Color getUsedFillColor(@NotNull C c, @NotNull D d) {
        if (this.usedFillColor == null) {
            throw new DecorationException("Used fill color must be specified");
        }
        return this.usedFillColor;
    }

    @NotNull
    protected Color getAllocatedMarkColor(@NotNull C c, @NotNull D d) {
        if (this.allocatedMarkColor == null) {
            throw new DecorationException("Allocated mark color must be specified");
        }
        return this.allocatedMarkColor;
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d, @NotNull Shape shape) {
        float opacity = this.getOpacity(c, d);
        if (opacity > 0.0f) {
            long max;
            Composite oc = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(opacity), opacity < 1.0f);
            Rectangle b = shape.getBounds();
            Rectangle ib = new Rectangle(b.x + 2, b.y + 2, b.width - 4, b.height - 4);
            MemoryUsage memoryUsage = ((WebMemoryBar)c).getMemoryUsage();
            long l2 = max = ((WebMemoryBar)c).isMaximumMemoryDisplayed() ? memoryUsage.getMax() : memoryUsage.getCommitted();
            if (((WebMemoryBar)c).isMaximumMemoryDisplayed()) {
                Line line;
                boolean ltr = ((Component)c).getComponentOrientation().isLeftToRight();
                int allocatedWidth = this.getBarLength(c, d, ib, memoryUsage.getCommitted(), max, false);
                if (((WebMemoryBar)c).getOrientation().isHorizontal()) {
                    int x = ltr ? ib.x + allocatedWidth : ib.x + ib.width - allocatedWidth - 1;
                    line = new Line(x, ib.y, x, ib.y + ib.height - 1);
                } else {
                    int y = ltr ? ib.y + ib.height - allocatedWidth - 1 : ib.y + allocatedWidth;
                    line = new Line(ib.x, y, ib.x + ib.width - 1, y);
                }
                g2d.setPaint(this.getAllocatedMarkColor(c, d));
                g2d.drawLine(line.x1, line.y1, line.x2, line.y2);
            }
            g2d.setPaint(this.getUsedFillColor(c, d));
            g2d.fill(this.getBarShape(c, d, ib, memoryUsage.getUsed(), max, true));
            g2d.setPaint(this.getUsedBorderColor(c, d));
            g2d.draw(this.getBarShape(c, d, ib, memoryUsage.getUsed(), max, false));
            GraphicsUtils.restoreComposite(g2d, oc, opacity < 1.0f);
        }
    }

    @NotNull
    protected Shape getBarShape(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds, long value, long max, boolean fill) {
        int adjustment;
        boolean ltr = ((Component)c).getComponentOrientation().isLeftToRight();
        int barLength = this.getBarLength(c, d, bounds, value, max, fill);
        int n = adjustment = fill ? 0 : 1;
        RoundRectangle2D.Double barShape = ((WebMemoryBar)c).getOrientation().isHorizontal() ? new RoundRectangle2D.Double(ltr ? (double)bounds.x : (double)(bounds.x + bounds.width - adjustment - barLength), bounds.y, barLength, bounds.height - adjustment, this.getRound(c, d), this.getRound(c, d)) : new RoundRectangle2D.Double(bounds.x, ltr ? (double)(bounds.y + bounds.height - adjustment - barLength) : (double)bounds.y, bounds.width - adjustment, barLength, this.getRound(c, d), this.getRound(c, d));
        return barShape;
    }

    protected int getBarLength(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds, long value, long max, boolean fill) {
        boolean hor = ((WebMemoryBar)c).getOrientation().isHorizontal();
        return MathUtils.roundToInt((double)((hor ? bounds.width : bounds.height) - (fill ? 0 : 1)) * (double)value / (double)max);
    }
}

