/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.link;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.link.AsyncLinkAction;
import com.alee.utils.FileUtils;
import com.alee.utils.WebUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Icon;

public class FileLinkAction
extends AsyncLinkAction {
    @NotNull
    private final File file;

    public FileLinkAction(@NotNull String path) {
        this(new File(path));
    }

    public FileLinkAction(@NotNull File file) {
        this.file = file;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return FileUtils.getFileIcon(this.file);
    }

    @Override
    @Nullable
    public String getText() {
        return FileUtils.getDisplayFileName(this.file);
    }

    @Override
    protected void asyncLinkExecuted(@NotNull ActionEvent event) {
        WebUtils.openFileSafely(this.file);
    }
}

