/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.lazy;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.lazy.DataLoadListener;
import com.alee.extended.lazy.DataLoadProgress;
import com.alee.extended.lazy.ProgressCallback;
import com.alee.utils.CoreSwingUtils;
import javax.swing.event.EventListenerList;

public class LazyDataLoadProgress<D>
implements DataLoadProgress<D>,
ProgressCallback {
    protected int total;
    protected int progress;
    @Nullable
    protected Object[] progressData;
    @Nullable
    protected EventListenerList listeners;

    public LazyDataLoadProgress() {
        this(-1, -1, null);
    }

    public LazyDataLoadProgress(int total, int progress, Object ... data) {
        this.setTotal(total);
        this.setProgress(progress, data);
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    @Nullable
    public Object[] getProgressData() {
        return this.progressData;
    }

    @Override
    public void setTotal(final int total) {
        this.total = total;
        CoreSwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                LazyDataLoadProgress.this.fireTotalChanged(total);
            }
        });
    }

    @Override
    public void setProgress(final int progress, final Object ... data) {
        if (this.total != -1 && progress > this.total) {
            throw new RuntimeException("Total must be equal or greater than progress");
        }
        this.progress = progress;
        this.progressData = data;
        CoreSwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                LazyDataLoadProgress.this.fireProgressChanged(progress, data);
            }
        });
    }

    @Override
    public void addListener(@NotNull DataLoadListener<D> listener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(DataLoadListener.class, listener);
    }

    @Override
    public void removeListener(@NotNull DataLoadListener<D> listener) {
        if (this.listeners != null) {
            this.listeners.remove(DataLoadListener.class, listener);
        }
    }

    public void fireLoadingStarted() {
        if (this.listeners != null) {
            for (DataLoadListener listener : (DataLoadListener[])this.listeners.getListeners(DataLoadListener.class)) {
                listener.loadingStarted();
            }
        }
    }

    public void fireTotalChanged(int total) {
        if (this.listeners != null) {
            for (DataLoadListener listener : (DataLoadListener[])this.listeners.getListeners(DataLoadListener.class)) {
                listener.totalChanged(total);
            }
        }
    }

    public void fireProgressChanged(int progress, Object ... data) {
        if (this.listeners != null) {
            for (DataLoadListener listener : (DataLoadListener[])this.listeners.getListeners(DataLoadListener.class)) {
                listener.progressChanged(progress, data);
            }
        }
    }

    public void fireLoaded(@Nullable D data) {
        if (this.listeners != null) {
            for (DataLoadListener listener : (DataLoadListener[])this.listeners.getListeners(DataLoadListener.class)) {
                listener.loaded(data);
            }
        }
    }

    public void fireFailed(@NotNull Throwable cause) {
        if (this.listeners != null) {
            for (DataLoadListener listener : (DataLoadListener[])this.listeners.getListeners(DataLoadListener.class)) {
                listener.failed(cause);
            }
        }
    }
}

