/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.api.annotations.NotNull;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class SlidingLayout
extends AbstractLayoutManager {
    protected int slideY = 0;
    protected WebTimer animator = null;
    protected int height = 0;
    protected int slideSpeed = 5;
    protected JComponent container;

    public SlidingLayout(JComponent container) {
        this.container = container;
    }

    public void slideIn() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.stop();
        }
        this.slideY = 0;
        this.animator = new WebTimer("SlidingLayout.slideInTimer", SwingUtils.frameRateDelay(36), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SlidingLayout.this.slideY < SlidingLayout.this.height) {
                    SlidingLayout.this.slideY += SlidingLayout.this.slideSpeed;
                    SlidingLayout.this.container.revalidate();
                } else {
                    SlidingLayout.this.slideY = SlidingLayout.this.height;
                    SlidingLayout.this.animator.stop();
                }
            }
        });
        this.animator.start();
    }

    public int getSlideSpeed() {
        return this.slideSpeed;
    }

    public void setSlideSpeed(int slideSpeed) {
        this.slideSpeed = slideSpeed;
    }

    public void slideOut() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.stop();
        }
        this.slideY = this.height;
        this.animator = new WebTimer("SlidingLayout.slideOutTimer", SwingUtils.frameRateDelay(36), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SlidingLayout.this.slideY > 0) {
                    SlidingLayout.this.slideY -= SlidingLayout.this.slideSpeed;
                    SlidingLayout.this.container.revalidate();
                } else {
                    SlidingLayout.this.slideY = 0;
                    SlidingLayout.this.animator.stop();
                }
            }
        });
        this.animator.start();
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        Dimension ps = new Dimension(0, 0);
        for (Component c : container.getComponents()) {
            ps = SwingUtils.max(ps, c.getPreferredSize());
        }
        ps.height = this.slideY < ps.height ? this.slideY : ps.height;
        return ps;
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        for (Component c : container.getComponents()) {
            Dimension ps = c.getPreferredSize();
            c.setBounds(0, this.slideY < ps.height ? this.slideY - ps.height : 0, container.getWidth(), ps.height);
            this.height = Math.max(this.height, ps.height);
        }
    }
}

