/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComponentPanelLayout
extends AbstractLayoutManager {
    protected List<Component> components = new ArrayList<Component>();
    protected Map<Component, Integer> yShift = new HashMap<Component, Integer>();

    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponentShift(Component component2, Integer shift) {
        this.yShift.put(component2, shift);
    }

    public Integer getComponentShift(Component component2) {
        return this.yShift.get(component2);
    }

    public int indexOf(Component component2) {
        return this.components.indexOf(component2);
    }

    public Component getComponent(int index) {
        return this.components.get(index);
    }

    @Override
    public void addComponent(@NotNull Component component2, @Nullable Object constraints) {
        this.components.add(component2);
    }

    @Override
    public void removeComponent(@NotNull Component component2) {
        this.components.remove(component2);
    }

    public void insertLayoutComponent(int index, Component component2) {
        this.components.add(index, component2);
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        Insets insets = container.getInsets();
        int width = insets.left + insets.right;
        int height = insets.top + insets.bottom;
        for (Component component2 : this.components) {
            Dimension ps = component2.getPreferredSize();
            width = Math.max(width, insets.left + ps.width + insets.right);
            height += ps.height;
        }
        return new Dimension(width, height);
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        Insets insets = container.getInsets();
        int y = insets.top;
        for (Component component2 : this.components) {
            Dimension ps = component2.getPreferredSize();
            Integer shift = this.yShift.get(component2);
            component2.setBounds(insets.left, shift == null ? y : y + shift, container.getWidth() - insets.left - insets.right, ps.height);
            y += ps.height;
        }
    }
}

