/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.utils.CollectionUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.swing.ZOrderComparator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingConstants;

public abstract class AbstractLineLayout
extends AbstractLayoutManager
implements SwingConstants {
    @NotNull
    public static final String START = "START";
    @NotNull
    public static final String MIDDLE = "MIDDLE";
    @NotNull
    public static final String FILL = "FILL";
    @NotNull
    public static final String END = "END";
    @NotNull
    public static final String TRIM = "TRIM";
    @NotNull
    protected static final ZOrderComparator COMPONENTS_COMPARATOR = new ZOrderComparator();
    @NotNull
    protected static final Rectangle HIDE_BOUNDS = new Rectangle(-1, -1, 0, 0);
    protected int spacing;
    protected int partsSpacing;
    @NotNull
    protected transient Map<Component, String> constraints;
    @NotNull
    protected transient Map<String, List<Component>> components;

    public AbstractLineLayout(int spacing, int partsSpacing) {
        this.spacing = spacing;
        this.partsSpacing = partsSpacing;
        this.constraints = new HashMap<Component, String>(10);
        this.components = new HashMap<String, List<Component>>(4);
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int getPartsSpacing() {
        return this.partsSpacing;
    }

    public void setPartsSpacing(int partsSpacing) {
        this.partsSpacing = partsSpacing;
    }

    @Override
    public void addComponent(@NotNull Component component2, @Nullable Object constraints) {
        String actualConstraints;
        String value = (String)constraints;
        if (!TextUtils.isBlank(value) && Objects.notEquals((Object)value, START, MIDDLE, FILL, END, TRIM)) {
            String msg = "Unsupported layout constraints: %s";
            throw new IllegalArgumentException(String.format("Unsupported layout constraints: %s", value));
        }
        String string = actualConstraints = value == null || value.trim().equals("") ? START : value;
        if (Objects.equals((Object)actualConstraints, (Object)MIDDLE) && this.components.containsKey(FILL)) {
            throw new RuntimeException("Layout already contains element under `FILL` constraints");
        }
        if (Objects.equals((Object)actualConstraints, (Object)FILL) && (this.components.containsKey(MIDDLE) || this.components.containsKey(FILL))) {
            throw new RuntimeException("Layout already contains element under `MIDDLE` or `FILL` constraints");
        }
        if (Objects.equals((Object)actualConstraints, (Object)TRIM) && this.components.containsKey(TRIM)) {
            throw new RuntimeException("Layout already contains element under `TRIM` constraints");
        }
        this.constraints.put(component2, actualConstraints);
        List<Component> components = this.components.get(actualConstraints);
        if (components == null) {
            components = new ArrayList<Component>(1);
        }
        components.add(component2);
        this.components.put(actualConstraints, components);
    }

    @Override
    public void removeComponent(@NotNull Component component2) {
        String constraints = this.constraints.get(component2);
        this.constraints.remove(component2);
        List<Component> components = this.components.get(constraints);
        components.remove(component2);
        if (components.isEmpty()) {
            this.components.remove(constraints);
        }
    }

    @Override
    public void migrate(@NotNull Container container, @Nullable LayoutManager oldLayout) {
        if (oldLayout != null && oldLayout instanceof AbstractLineLayout) {
            AbstractLineLayout oldLineLayout = (AbstractLineLayout)oldLayout;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component2 = container.getComponent(i);
                if (!oldLineLayout.constraints.containsKey(component2)) continue;
                this.addComponent(component2, oldLineLayout.constraints.get(component2));
            }
        }
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        boolean fit;
        int orientation = this.getOrientation(container);
        boolean horizontal = orientation == 0;
        Insets insets = container.getInsets();
        Dimension size = container.getSize();
        boolean ltr = container.getComponentOrientation().isLeftToRight();
        int lineWidth = horizontal ? size.height - insets.top - insets.bottom : size.width - insets.left - insets.right;
        HashMap<Component, Dimension> cache = new HashMap<Component, Dimension>();
        Dimension preferredSize = this.preferredLayoutSize(container, cache);
        Dimension trimSize = this.preferredPartSize(TRIM, orientation, ltr, cache);
        Rectangle available = new Rectangle(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
        boolean bl = horizontal ? preferredSize.width <= size.width : (fit = preferredSize.height <= size.height);
        if (fit) {
            Dimension startSize = this.preferredPartSize(START, orientation, ltr, cache);
            if (startSize.width > 0) {
                Point startPoint = new Point(insets.left, insets.top);
                this.placeComponents(START, startPoint, orientation, ltr, lineWidth, available, cache);
            }
            Dimension endSize = this.preferredPartSize(END, orientation, ltr, cache);
            if (endSize.width > 0) {
                Point endPoint = new Point(horizontal ? size.width - insets.right - endSize.width : insets.left, horizontal ? insets.top : size.height - insets.bottom - endSize.height);
                this.placeComponents(END, endPoint, orientation, ltr, lineWidth, available, cache);
            }
            Dimension middleSize = this.preferredPartSize(MIDDLE, orientation, ltr, cache);
            Dimension fillSize = this.preferredPartSize(FILL, orientation, ltr, cache);
            if (middleSize.width > 0 || fillSize.width > 0) {
                int xEndLength;
                int yStartLength;
                int xStartLength;
                int n = horizontal ? startSize.width + (startSize.width > 0 ? this.partsSpacing : 0) : (xStartLength = 0);
                int n2 = horizontal ? 0 : (yStartLength = startSize.height + (startSize.height > 0 ? this.partsSpacing : 0));
                int n3 = horizontal ? endSize.width + (endSize.width > 0 ? this.partsSpacing : 0) : (xEndLength = 0);
                int yEndLength = horizontal ? 0 : endSize.height + (endSize.height > 0 ? this.partsSpacing : 0);
                Rectangle fillBounds = new Rectangle(insets.left + xStartLength, insets.top + yStartLength, size.width - insets.left - xStartLength - xEndLength - insets.right, size.height - insets.top - yStartLength - yEndLength - insets.bottom);
                if (middleSize.width > 0) {
                    Point middlePoint = new Point(horizontal ? fillBounds.x + fillBounds.width / 2 - middleSize.width / 2 : fillBounds.x, horizontal ? fillBounds.y : fillBounds.y + fillBounds.height / 2 - middleSize.height / 2);
                    this.placeComponents(MIDDLE, middlePoint, orientation, ltr, lineWidth, available, cache);
                } else {
                    this.placeFillComponent(fillBounds, available);
                }
            }
        } else {
            Rectangle trimmed = trimSize.width > 0 ? new Rectangle(available.x + (horizontal && !ltr ? trimSize.width + this.spacing : 0), available.y, available.width - (horizontal ? trimSize.width + this.spacing : 0), available.height - (!horizontal ? trimSize.height + this.spacing : 0)) : available;
            Point point = new Point(insets.left + (horizontal && !ltr ? size.width - preferredSize.width : 0), insets.top);
            Dimension startSize = this.preferredPartSize(START, orientation, ltr, cache);
            if (startSize.width > 0) {
                this.placeComponents(START, point, orientation, ltr, lineWidth, trimmed, cache);
                point.x = point.x + (horizontal ? this.partsSpacing : 0);
                point.y = point.y + (horizontal ? 0 : this.partsSpacing);
            }
            Dimension middleSize = this.preferredPartSize(MIDDLE, orientation, ltr, cache);
            if (middleSize.width > 0) {
                this.placeComponents(MIDDLE, point, orientation, ltr, lineWidth, trimmed, cache);
                point.x = point.x + (horizontal ? this.partsSpacing : 0);
                point.y = point.y + (horizontal ? 0 : this.partsSpacing);
            }
            Dimension fillSize = this.preferredPartSize(FILL, orientation, ltr, cache);
            if (fillSize.width > 0) {
                this.placeComponents(FILL, point, orientation, ltr, lineWidth, trimmed, cache);
                point.x = point.x + (horizontal ? this.partsSpacing : 0);
                point.y = point.y + (horizontal ? 0 : this.partsSpacing);
            }
            Dimension endSize = this.preferredPartSize(END, orientation, ltr, cache);
            if (endSize.width > 0) {
                this.placeComponents(END, point, orientation, ltr, lineWidth, trimmed, cache);
            }
        }
        if (trimSize.width > 0) {
            this.placeTrimComponent(trimSize, orientation, ltr, available, fit);
        }
    }

    protected void placeComponents(@NotNull String c, @NotNull Point point, int orientation, boolean ltr, int lineWidth, @NotNull Rectangle available, @NotNull Map<Component, Dimension> cache) {
        String constraints = this.constraints(c, orientation, ltr);
        boolean horizontal = orientation == 0;
        List<Component> components = this.components.get(constraints);
        CollectionUtils.sort(components, COMPONENTS_COMPARATOR);
        if (ltr || !horizontal) {
            for (Component component2 : components) {
                Dimension cps = this.preferredSize(component2, cache);
                Rectangle bounds = new Rectangle(point.x, point.y, horizontal ? cps.width : lineWidth, horizontal ? lineWidth : cps.height);
                if (available.contains(bounds)) {
                    component2.setBounds(bounds);
                } else {
                    component2.setBounds(HIDE_BOUNDS);
                }
                point.x = point.x + (horizontal ? bounds.width + this.spacing : 0);
                point.y = point.y + (horizontal ? 0 : bounds.height + this.spacing);
            }
        } else {
            for (int i = components.size() - 1; i >= 0; --i) {
                Component component3 = components.get(i);
                Dimension cps = this.preferredSize(component3, cache);
                Rectangle bounds = new Rectangle(point.x, point.y, cps.width, lineWidth);
                if (available.contains(bounds)) {
                    component3.setBounds(bounds);
                } else {
                    component3.setBounds(HIDE_BOUNDS);
                }
                point.x += bounds.width + this.spacing;
            }
        }
        point.x = point.x - (horizontal ? this.spacing : 0);
        point.y = point.y - (horizontal ? 0 : this.spacing);
    }

    protected void placeFillComponent(@NotNull Rectangle bounds, @NotNull Rectangle available) {
        if (available.contains(bounds)) {
            this.components.get(FILL).get(0).setBounds(bounds);
        } else {
            this.components.get(FILL).get(0).setBounds(HIDE_BOUNDS);
        }
    }

    protected void placeTrimComponent(@NotNull Dimension trimSize, int orientation, boolean ltr, @NotNull Rectangle available, boolean fit) {
        if (!fit) {
            boolean horizontal = orientation == 0;
            Rectangle trimBounds = new Rectangle(horizontal && ltr ? available.x + available.width - trimSize.width : available.x, horizontal ? available.y : available.y + available.height - trimSize.height, horizontal ? trimSize.width : available.width, horizontal ? available.height : trimSize.height);
            this.components.get(TRIM).get(0).setBounds(trimBounds);
        } else {
            this.components.get(TRIM).get(0).setBounds(HIDE_BOUNDS);
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        return this.preferredLayoutSize(container, new HashMap<Component, Dimension>());
    }

    protected Dimension preferredLayoutSize(@NotNull Container container, @NotNull Map<Component, Dimension> cache) {
        Dimension ps = new Dimension(0, 0);
        int orientation = this.getOrientation(container);
        boolean ltr = container.getComponentOrientation().isLeftToRight();
        this.expandSizeFromPart(ps, START, this.partsSpacing, orientation, ltr, cache);
        this.expandSizeFromPart(ps, MIDDLE, this.partsSpacing, orientation, ltr, cache);
        this.expandSizeFromPart(ps, FILL, this.partsSpacing, orientation, ltr, cache);
        this.expandSizeFromPart(ps, END, this.partsSpacing, orientation, ltr, cache);
        Insets insets = container.getInsets();
        ps.width += insets.left + insets.right;
        ps.height += insets.top + insets.bottom;
        return ps;
    }

    protected void expandSizeFromPart(@NotNull Dimension size, @NotNull String constraints, int spacing, int orientation, boolean ltr, @NotNull Map<Component, Dimension> cache) {
        Dimension partSize = this.preferredPartSize(constraints, orientation, ltr, cache);
        if (partSize.width > 0) {
            boolean horizontal;
            boolean bl = horizontal = orientation == 0;
            int n = horizontal ? size.width + (size.width > 0 ? spacing : 0) + partSize.width : (size.width = Math.max(size.width, partSize.width));
            size.height = horizontal ? Math.max(size.height, partSize.height) : size.height + (size.height > 0 ? spacing : 0) + partSize.height;
        }
    }

    @NotNull
    protected Dimension preferredPartSize(@NotNull String c, int orientation, boolean ltr, @NotNull Map<Component, Dimension> cache) {
        Dimension ps = new Dimension(0, 0);
        String constraints = this.constraints(c, orientation, ltr);
        List<Component> components = this.components.get(constraints);
        if (CollectionUtils.notEmpty(components)) {
            boolean horizontal = orientation == 0;
            for (Component component2 : components) {
                Dimension cps = this.preferredSize(component2, cache);
                ps.width = horizontal ? ps.width + cps.width + this.spacing : Math.max(ps.width, cps.width);
                ps.height = horizontal ? Math.max(ps.height, cps.height) : ps.height + cps.height + this.spacing;
            }
            ps.width = ps.width - (horizontal ? this.spacing : 0);
            ps.height = ps.height - (horizontal ? 0 : this.spacing);
        }
        return ps;
    }

    @NotNull
    protected Dimension preferredSize(@NotNull Component component2, @NotNull Map<Component, Dimension> cache) {
        Dimension ps = cache.get(component2);
        if (ps == null) {
            ps = component2.getPreferredSize();
            cache.put(component2, ps);
        }
        return ps;
    }

    @NotNull
    protected String constraints(@NotNull String constraints, int orientation, boolean ltr) {
        String c = Objects.equals((Object)constraints, (Object)START) ? (ltr || orientation != 0 ? START : END) : (Objects.equals((Object)constraints, (Object)END) ? (ltr || orientation != 0 ? END : START) : constraints);
        return c;
    }

    public abstract int getOrientation(@NotNull Container var1);
}

