/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.language;

import com.alee.extended.label.WebStyledLabel;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Value;
import com.alee.managers.style.StyleId;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class DictionariesTreeRenderer
extends WebStyledLabel
implements TreeCellRenderer {
    private static final ImageIcon multidicIcon = new ImageIcon(DictionariesTreeRenderer.class.getResource("icons/multidic.png"));
    private static final ImageIcon dicIcon = new ImageIcon(DictionariesTreeRenderer.class.getResource("icons/dic.png"));
    private static final ImageIcon recordIcon = new ImageIcon(DictionariesTreeRenderer.class.getResource("icons/record.png"));
    private static final ImageIcon textIcon = new ImageIcon(DictionariesTreeRenderer.class.getResource("icons/text.png"));

    @Override
    public WebStyledLabel getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setStyleId(StyleId.treeCellRenderer.at(tree));
        this.setFont(tree.getFont());
        this.setEnabled(tree.isEnabled());
        this.setComponentOrientation(tree.getComponentOrientation());
        Object val = ((DefaultMutableTreeNode)value).getUserObject();
        if (val == null) {
            this.setIcon(multidicIcon);
            this.setText("Dictionaries");
        } else if (val instanceof Dictionary) {
            Dictionary d = (Dictionary)val;
            this.setIcon(dicIcon);
            this.setText("{" + d.getPrefix() + ":b} - " + d.getName());
        } else if (val instanceof Record) {
            Record r = (Record)val;
            this.setIcon(recordIcon);
            this.setText(expanded ? "{" + r.getKey() + ":b}" : r.toString(true));
        } else if (val instanceof Value) {
            Value v = (Value)val;
            this.setIcon(UILanguageManager.getLocaleIcon(v.getLocale()));
            this.setText(v.getLocale().toString());
        } else if (val instanceof Text) {
            Text text = (Text)val;
            this.setIcon(textIcon);
            this.setText(text.getState() == null ? text.toString() : "{" + text.getState() + ":b} -> " + text.toString());
        }
        return this;
    }
}

