/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.label.IStyleRanges;
import com.alee.extended.label.IStyleSettings;
import com.alee.extended.label.StyleRange;
import com.alee.extended.label.StyleSettings;
import com.alee.extended.label.TextRange;
import com.alee.utils.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class StyleRanges
implements IStyleRanges {
    @Nullable
    protected final String styledText;
    @Nullable
    protected String plainText;
    @Nullable
    protected List<StyleRange> styleRanges;

    public StyleRanges(@Nullable String styledText) {
        this.styledText = styledText;
    }

    @Override
    @Nullable
    public String getStyledText() {
        return this.styledText;
    }

    @Override
    @Nullable
    public String getPlainText() {
        return this.parseStyledText().plainText;
    }

    @Override
    @NotNull
    public List<StyleRange> getStyleRanges() {
        List<StyleRange> styleRanges = this.parseStyledText().styleRanges;
        if (styleRanges == null) {
            throw new RuntimeException("Unable to parse style ranges for text: " + this.styledText);
        }
        return styleRanges;
    }

    @NotNull
    protected StyleRanges parseStyledText() {
        if (this.styleRanges == null) {
            this.styleRanges = new ArrayList<StyleRange>();
            if (TextUtils.notEmpty(this.styledText)) {
                int begin = this.nextUnescaped(this.styledText, "{", 0);
                if (begin != -1) {
                    int end;
                    this.plainText = "";
                    String trimmedText = this.styledText;
                    while (begin != -1 && (end = this.nextUnescaped(trimmedText, "}", begin + 1)) != -1) {
                        String statement = trimmedText.substring(begin + 1, end);
                        if (statement.equals("br")) {
                            this.plainText = this.plainText + trimmedText.substring(0, begin) + "\n";
                        } else {
                            TextRange range = this.parseStatement(this.plainText.length() + begin, statement);
                            if (range != null && range.getStyleRange() != null) {
                                this.plainText = this.plainText + trimmedText.substring(0, begin) + range.getText();
                                this.styleRanges.add(range.getStyleRange());
                            } else {
                                this.plainText = this.plainText + trimmedText.substring(0, end + 1);
                            }
                        }
                        trimmedText = trimmedText.substring(end + 1);
                        begin = this.nextUnescaped(trimmedText, "{", 0);
                    }
                    this.plainText = this.plainText + trimmedText;
                } else {
                    this.plainText = this.styledText;
                }
            } else {
                this.plainText = null;
            }
        }
        return this;
    }

    protected int nextUnescaped(@NotNull String text, @NotNull String pattern, int from) {
        return text.indexOf(pattern, from);
    }

    @Nullable
    protected TextRange parseStatement(int startIndex, @NotNull String statement) {
        TextRange textRange = null;
        try {
            int sep = statement.lastIndexOf(":");
            if (sep != -1) {
                String text = statement.substring(0, sep);
                String settings2 = statement.substring(sep + 1);
                IStyleSettings styleSettings = this.getStyleSettings(startIndex, text.length(), settings2);
                StyleRange styleRange = styleSettings.getStyleRange();
                if (styleRange != null) {
                    textRange = new TextRange(text, styleRange);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return textRange;
    }

    @NotNull
    protected IStyleSettings getStyleSettings(int startIndex, int length, @NotNull String settings2) {
        return new StyleSettings(startIndex, length, settings2);
    }
}

