/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.inspector.info;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.icon.StackIcon;
import com.alee.extended.inspector.info.ComponentPreview;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.xml.InsetsConverter;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public abstract class AbstractComponentPreview<C extends Component>
implements ComponentPreview<C> {
    public static final ImageIcon opaque = new ImageIcon(AbstractComponentPreview.class.getResource("icons/opaque.png"));
    public static final ImageIcon frameType = new ImageIcon(AbstractComponentPreview.class.getResource("icons/frame.png"));
    public static final ImageIcon dialogType = new ImageIcon(AbstractComponentPreview.class.getResource("icons/dialog.png"));
    public static final ImageIcon windowType = new ImageIcon(AbstractComponentPreview.class.getResource("icons/window.png"));
    public static final ImageIcon glassPaneType = new ImageIcon(AbstractComponentPreview.class.getResource("icons/glasspane.png"));
    public static final ImageIcon unknownType = new ImageIcon(AbstractComponentPreview.class.getResource("icons/unknown.png"));
    protected static final Map<String, Icon> stackIconCache = new HashMap<String, Icon>(30);
    protected static final String visibleColor = "black";
    protected static final String visibleAwtColor = "165,145,70";
    protected static final String hiddenColor = "180,180,180";
    protected static final String styleIdColor = "30,110,30";
    protected static final String marginColor = "190,190,0";
    protected static final String paddingColor = "0,150,70";

    @Override
    @NotNull
    public Icon getIcon(@NotNull C component2) {
        Icon icon = this.getIconImpl(component2);
        if (SwingUtils.isOpaque(component2)) {
            String key = icon.hashCode() + "," + opaque.hashCode();
            if (stackIconCache.containsKey(key)) {
                icon = stackIconCache.get(key);
            } else {
                icon = new StackIcon(icon, opaque);
                stackIconCache.put(key, icon);
            }
        }
        return icon;
    }

    @NotNull
    protected abstract Icon getIconImpl(@NotNull C var1);

    @NotNull
    protected String getTitleColor(@NotNull C component2) {
        return ((Component)component2).isShowing() ? (component2 instanceof JComponent ? visibleColor : visibleAwtColor) : hiddenColor;
    }

    @NotNull
    protected String renderLayout(@Nullable LayoutManager layout) {
        return layout != null ? " {[" + ReflectUtils.getCompleteClassName(layout) + "]:b}" : "";
    }

    @NotNull
    protected String renderInsets(@Nullable Insets insets, @NotNull String color) {
        String text = !SwingUtils.isEmpty(insets) ? " {[ " + InsetsConverter.insetsToString(insets) + " ]:b;c(" + color + ")}" : "";
        return text;
    }
}

