/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.inspector;

import com.alee.api.annotations.NotNull;
import com.alee.extended.inspector.InterfaceTreeNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Comparator;

public class InterfaceTreeNodeComparator
implements Comparator<InterfaceTreeNode> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compare(@NotNull InterfaceTreeNode node1, @NotNull InterfaceTreeNode node2) {
        Component component1 = (Component)node1.getUserObject();
        Component component2 = (Component)node2.getUserObject();
        if (component1 instanceof Window && component2 instanceof Window) {
            return 0;
        }
        if (component1 == null) throw new RuntimeException("Compared nodes cannot have null components");
        if (component2 == null) throw new RuntimeException("Compared nodes cannot have null components");
        Container parent1 = component1.getParent();
        Container parent2 = component2.getParent();
        if (parent1 != null && parent2 != null) {
            if (parent1 != parent2) throw new RuntimeException("Compared nodes cannot have different parent");
        }
        int zIndex1 = parent1 != null ? parent1.getComponentZOrder(component1) : 0;
        int zIndex2 = parent2 != null ? parent2.getComponentZOrder(component2) : 0;
        return new Integer(zIndex2).compareTo(zIndex1);
    }
}

