/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.icon;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.behavior.OmitOnClone;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.painter.decoration.background.AlphaLayerBackground;
import com.alee.utils.GraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    @Nullable
    protected final Color color;
    protected final int width;
    protected final int height;
    @OmitOnMerge
    @OmitOnClone
    @Nullable
    protected transient BufferedImage alphaTexture;

    public ColorIcon(@Nullable Color color) {
        this(color, 14, 14);
    }

    public ColorIcon(@Nullable Color color, int width, int height) {
        this.color = color;
        this.width = width;
        this.height = height;
        this.alphaTexture = null;
    }

    @Override
    public void paintIcon(@NotNull Component c, @NotNull Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        GraphicsUtils.setupAntialias(g2d);
        if (this.color == null || this.color.getTransparency() < 255) {
            if (this.alphaTexture == null) {
                this.alphaTexture = AlphaLayerBackground.createAlphaBackgroundTexture(new Dimension(new Dimension(this.width / 2, this.width / 2)));
            }
            g2d.setPaint(new TexturePaint(this.alphaTexture, new Rectangle(x, y, this.alphaTexture.getWidth(), this.alphaTexture.getHeight())));
            g2d.fillRect(x, y, this.width, this.height);
        } else if (this.alphaTexture != null) {
            this.alphaTexture.flush();
            this.alphaTexture = null;
        }
        if (this.color != null) {
            g2d.setPaint(this.color);
            g2d.fillRect(x, y, this.width, this.height);
        }
        g2d.setPaint(new Color(87, 89, 91));
        g2d.drawRect(x, y, this.width - 1, this.height - 1);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

