/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.heatmap;

import com.alee.laf.WebLookAndFeel;
import com.alee.utils.ColorUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.concurrent.DaemonThreadFactory;
import com.alee.utils.swing.WebTimer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;

public class HeatMap
extends JComponent {
    protected static final Integer HEAT_MAP_LAYER = 10000;
    protected static final Color[] HEAT_COLORS = new Color[]{new Color(0, 0, 255, 32), new Color(0, 255, 255, 32), new Color(0, 255, 0, 32), new Color(255, 255, 0, 32), new Color(255, 0, 0, 32)};
    protected Mode mode;
    protected long updateDeplay;
    protected Dimension sectorSize;
    protected boolean displayTimeMetrics;
    protected transient ComponentAdapter resizeListener;
    protected transient BufferedImage buffer;
    protected transient BufferedImage renderer;
    protected transient BufferedImage merger;
    protected final transient WebTimer updater;
    protected transient JRootPane rootPane;
    protected volatile transient boolean measuring;
    protected final transient ExecutorService EXECUTOR = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), new DaemonThreadFactory("HeatMap"), new ThreadPoolExecutor.DiscardOldestPolicy());

    public HeatMap() {
        this.setOpaque(false);
        this.setEnabled(false);
        this.mode = Mode.grid;
        this.updateDeplay = 250L;
        this.sectorSize = new Dimension(40, 40);
        this.displayTimeMetrics = true;
        this.updater = new WebTimer(this.updateDeplay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatMap.this.updateHeatMap();
            }
        });
        this.updater.setUseEventDispatchThread(false);
        this.updater.setUseDaemonThread(true);
        this.updater.setRepeats(false);
        this.resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                HeatMap.this.updateHeatMap();
            }
        };
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.updateHeatMap();
    }

    public long getUpdateDeplay() {
        return this.updateDeplay;
    }

    public void setUpdateDeplay(long delay) {
        this.updateDeplay = delay;
        this.updateHeatMap();
    }

    public Dimension getSectorSize() {
        return this.sectorSize;
    }

    public void setSectorSize(Dimension size) {
        this.sectorSize = size;
        this.updateHeatMap();
    }

    public boolean isDisplayTimeMetrics() {
        return this.displayTimeMetrics;
    }

    public void setDisplayTimeMetrics(boolean display) {
        this.displayTimeMetrics = display;
        this.updateHeatMap();
    }

    protected void updateHeatMap() {
        this.EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                if (HeatMap.this.isDisplayed()) {
                    HeatMap.this.repaintHeatMap();
                    HeatMap.this.updater.setDelay(HeatMap.this.updateDeplay);
                    HeatMap.this.updater.restart();
                } else {
                    HeatMap.this.disposeHeatMap();
                    HeatMap.this.updater.stop();
                }
            }
        });
    }

    protected void repaintHeatMap() {
        if (this.renderer == null || this.renderer.getWidth() != this.sectorSize.width || this.renderer.getHeight() != this.sectorSize.height) {
            if (this.renderer != null) {
                this.renderer.flush();
                this.renderer = null;
            }
            this.renderer = ImageUtils.createCompatibleImage(this.sectorSize.width, this.sectorSize.height, 1);
        }
        Graphics2D rendererGraphics = this.renderer.createGraphics();
        rendererGraphics.setClip(0, 0, this.sectorSize.width, this.sectorSize.height);
        JLayeredPane layeredPane = this.rootPane.getLayeredPane();
        final Dimension size = layeredPane.getSize();
        int w = size.width / this.sectorSize.width + 1;
        int h = size.height / this.sectorSize.height + 1;
        long[][] times2 = new long[w][h];
        long min = 0L;
        long max = 0L;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                if (!this.isDisplayed()) {
                    return;
                }
                long time = this.benchmarkSector(layeredPane, rendererGraphics, x * this.sectorSize.width, y * this.sectorSize.height);
                if (min != max && (double)(time - min) > (double)(max - min) * 1.4) {
                    time = this.benchmarkSector(layeredPane, rendererGraphics, x * this.sectorSize.width, y * this.sectorSize.height);
                }
                times2[x][y] = time;
                min = Math.min(min, time);
                max = Math.max(max, time);
            }
        }
        if (this.buffer == null || this.buffer.getWidth() != size.width || this.buffer.getHeight() != size.height) {
            if (this.buffer != null) {
                this.buffer.flush();
            }
            this.buffer = ImageUtils.createCompatibleImage(size.width, size.height, 3);
        }
        Graphics2D bufferGraphics = this.buffer.createGraphics();
        bufferGraphics.setClip(0, 0, size.width, size.height);
        bufferGraphics.setComposite(AlphaComposite.getInstance(2));
        if (this.merger == null || this.merger.getWidth() != this.sectorSize.width || this.merger.getHeight() != this.sectorSize.height) {
            if (this.merger != null) {
                this.merger.flush();
                this.merger = null;
            }
            this.merger = ImageUtils.createCompatibleImage(this.sectorSize.width, this.sectorSize.height, 3);
        }
        Graphics2D m2d = this.merger.createGraphics();
        m2d.setFont(new Font("Tahoma", 0, 9));
        m2d.setBackground(new Color(255, 255, 255, 0));
        m2d.setClip(0, 0, this.sectorSize.width, this.sectorSize.height);
        DecimalFormat df = new DecimalFormat("0.00");
        FontMetrics fm = m2d.getFontMetrics();
        int ty = this.sectorSize.height / 2 + fm.getAscent() / 2;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                if (!this.isDisplayed()) {
                    return;
                }
                long time = times2[x][y];
                Color color = this.getHeatColor(min, max, time);
                m2d.setPaint(color);
                m2d.clearRect(0, 0, this.sectorSize.width, this.sectorSize.height);
                m2d.fillRect(0, 0, this.sectorSize.width, this.sectorSize.height);
                if (this.displayTimeMetrics) {
                    String ms = df.format((double)time / 1000000.0);
                    int tx = this.sectorSize.width / 2 - fm.stringWidth(ms) / 2;
                    m2d.setPaint(Color.BLACK);
                    m2d.drawString(ms, tx, ty);
                }
                bufferGraphics.drawImage((Image)this.merger, x * this.sectorSize.width, y * this.sectorSize.height, null);
            }
        }
        m2d.dispose();
        bufferGraphics.dispose();
        CoreSwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle b = new Rectangle(0, 0, size.width, size.height);
                if (!HeatMap.this.getBounds().equals(b)) {
                    HeatMap.this.setBounds(b);
                }
                HeatMap.this.repaint();
            }
        });
    }

    protected void disposeHeatMap() {
        if (this.buffer != null) {
            this.buffer.flush();
            this.buffer = null;
        }
        if (this.renderer != null) {
            this.renderer.flush();
            this.renderer = null;
        }
        if (this.merger != null) {
            this.merger.flush();
            this.merger = null;
        }
    }

    protected long benchmarkSector(final JComponent component2, final Graphics2D g2d, final int x, final int y) {
        try {
            final long[] time = new long[]{0L};
            CoreSwingUtils.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    HeatMap.this.measuring = true;
                    g2d.clearRect(0, 0, HeatMap.this.sectorSize.width, HeatMap.this.sectorSize.height);
                    g2d.translate(-x, -y);
                    time[0] = System.nanoTime();
                    component2.paintAll(g2d);
                    time[0] = System.nanoTime() - time[0];
                    g2d.translate(x, y);
                    HeatMap.this.measuring = false;
                }
            }, false);
            long l2 = time[0];
            return l2;
        }
        catch (Exception e) {
            throw new UtilityException("Unable to render sector: " + x + "," + y, e);
        }
        finally {
            this.measuring = false;
        }
    }

    protected Color getHeatColor(long min, long max, long value) {
        float progress = (float)(value - min) / (float)(max - min);
        int floor = (int)Math.round(Math.floor((float)(HEAT_COLORS.length - 1) * progress));
        int ceil = (int)Math.round(Math.ceil((float)(HEAT_COLORS.length - 1) * progress));
        return ColorUtils.intermediate(HEAT_COLORS[floor], HEAT_COLORS[ceil], (float)(HEAT_COLORS.length - 1) * progress - (float)floor);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isDisplayed() && !this.measuring) {
            if (this.buffer != null) {
                g.drawImage(this.buffer, 0, 0, null);
            } else {
                g.setColor(HEAT_COLORS[0]);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    public void displayOrDispose(Component component2) {
        if (!this.isDisplayed()) {
            this.display(component2);
        } else {
            this.dispose();
        }
    }

    public void display(Component component2) {
        WebLookAndFeel.checkEventDispatchThread();
        if (component2 == null) {
            throw new IllegalArgumentException("Provided component must not be null");
        }
        if (!component2.isShowing()) {
            throw new IllegalArgumentException("Provided component is not displayed on screen: " + component2);
        }
        this.rootPane = CoreSwingUtils.getNonNullRootPane(component2);
        this.rootPane.addComponentListener(this.resizeListener);
        this.displayOnLayeredPane();
        this.updateHeatMap();
    }

    protected void displayOnLayeredPane() {
        if (!this.isDisplayed()) {
            this.setEnabled(true);
            JLayeredPane layeredPane = this.rootPane.getLayeredPane();
            layeredPane.add((Component)this, HEAT_MAP_LAYER);
            Dimension size = layeredPane.getSize();
            Rectangle b = new Rectangle(0, 0, size.width, size.height);
            if (!this.getBounds().equals(b)) {
                this.setBounds(b);
            }
            layeredPane.revalidate();
            layeredPane.repaint();
        }
    }

    public void dispose() {
        WebLookAndFeel.checkEventDispatchThread();
        this.disposeFromLayeredPane();
        this.rootPane.removeComponentListener(this.resizeListener);
        this.rootPane = null;
        this.updateHeatMap();
    }

    protected void disposeFromLayeredPane() {
        if (this.isDisplayed()) {
            JLayeredPane layeredPane = this.rootPane.getLayeredPane();
            layeredPane.remove(this);
            layeredPane.revalidate();
            layeredPane.repaint();
            this.setEnabled(false);
        }
    }

    public boolean isDisplayed() {
        return this.isEnabled();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(0, 0);
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }

    public static enum Mode {
        grid;

    }
}

