/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.filechooser.FileTableColumns;
import com.alee.managers.language.LM;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class WebFileTableModel
extends AbstractTableModel
implements FileTableColumns {
    private List<String> columns;
    private final List<File> files;

    public WebFileTableModel() {
        this(new ArrayList<File>(), CollectionUtils.copy(DEFAULT_COLUMNS));
    }

    public WebFileTableModel(String ... columns) {
        this(new ArrayList<File>(), CollectionUtils.asList(columns));
    }

    public WebFileTableModel(List<String> columns) {
        this(new ArrayList<File>(), columns);
    }

    public WebFileTableModel(Collection<File> files2) {
        this(files2, CollectionUtils.copy(DEFAULT_COLUMNS));
    }

    public WebFileTableModel(Collection<File> files2, String ... columns) {
        this(files2, CollectionUtils.asList(columns));
    }

    public WebFileTableModel(Collection<File> files2, List<String> columns) {
        this.columns = columns;
        this.files = new ArrayList<File>(files2);
    }

    public void setFiles(Collection<File> files2) {
        this.files.clear();
        this.files.addAll(files2);
        this.fireTableDataChanged();
    }

    public void addFiles(Collection<File> files2) {
        if (files2.size() > 0) {
            int lastIndex = this.files.size();
            this.files.addAll(files2);
            this.fireTableRowsInserted(lastIndex, lastIndex + files2.size() - 1);
        }
    }

    public int getFileRow(File file) {
        return this.files.indexOf(file);
    }

    public File getFileAtRow(int row) {
        return this.files.get(row);
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
        this.fireTableStructureChanged();
    }

    public String getColumnId(int column) {
        return this.columns.get(column);
    }

    public boolean isColumnDisplayed(String column) {
        return this.columns.contains(column);
    }

    public int getColumnIndex(String column) {
        return this.columns.indexOf(column);
    }

    @Override
    public String getColumnName(int column) {
        return LM.get(this.columns.get(column), new Object[0]);
    }

    @Override
    public int getRowCount() {
        return this.files.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.files.get(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.files.set(rowIndex, (File)aValue);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return File.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.getColumnId(columnIndex).equals("weblaf.filechooser.table.column.name") && FileUtils.isNameEditable(this.getFileAtRow(rowIndex));
    }
}

