/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.filechooser.DirectoryChooserAdapter;
import com.alee.extended.filechooser.DirectoryChooserListener;
import com.alee.extended.filechooser.PathFieldListener;
import com.alee.extended.layout.TableLayout;
import com.alee.extended.panel.GroupPanel;
import com.alee.extended.pathfield.WebPathField;
import com.alee.extended.tree.FileTreeNode;
import com.alee.extended.tree.FileTreeRootType;
import com.alee.extended.tree.WebFileTree;
import com.alee.laf.button.WebButton;
import com.alee.laf.optionpane.WebOptionPane;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.toolbar.WebToolBar;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyCondition;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.icon.Icons;
import com.alee.managers.language.LM;
import com.alee.managers.style.StyleId;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.filefilter.AbstractFileFilter;
import com.alee.utils.filefilter.DirectoriesFilter;
import com.alee.utils.filefilter.FilterGroupType;
import com.alee.utils.filefilter.GroupedFileFilter;
import com.alee.utils.filefilter.NonHiddenFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class WebDirectoryChooserPanel
extends WebPanel {
    protected List<DirectoryChooserListener> listeners = new ArrayList<DirectoryChooserListener>(1);
    protected File selectedDirectory = FileUtils.getDiskRoots()[0];
    protected AbstractFileFilter filter = new GroupedFileFilter(FilterGroupType.AND, new DirectoriesFilter(), new NonHiddenFilter());
    protected WebButton folderUp;
    protected WebButton folderHome;
    protected WebButton folderDesktop;
    protected WebButton folderNew;
    protected WebButton refresh;
    protected WebButton remove;
    protected WebPathField webPathField;
    protected WebFileTree fileTree;
    protected TreeSelectionListener fileTreeListener;
    protected WebButton acceptButton;
    protected WebButton cancelButton;

    public WebDirectoryChooserPanel() {
        this(StyleId.directorychooser);
    }

    public WebDirectoryChooserPanel(StyleId id) {
        super(id, new TableLayout(new double[][]{{-1.0}, {-2.0, -2.0, -1.0, -2.0}}), new Component[0]);
        this.add((Component)this.createToolBar(), (Object)"0,0");
        this.add((Component)this.createPathField(), (Object)"0,1");
        this.add((Component)this.createFileTree(), (Object)"0,2");
        this.add((Component)this.createControlsPanel(), (Object)"0,3");
        this.updateSelectedDirectory(null, true, true);
        this.updateToolbarControlsState();
        HotkeyManager.installShowAllHotkeysAction(this, Hotkey.F1);
        HotkeyManager.addContainerHotkeyCondition(this, new HotkeyCondition(){

            @Override
            public boolean checkCondition(Component component2) {
                return WebDirectoryChooserPanel.this.allowHotkeys();
            }
        });
    }

    protected WebScrollPane createFileTree() {
        WebScrollPane treeScroll = new WebScrollPane(StyleId.directorychooserScroll.at(this));
        treeScroll.setPreferredWidth(400);
        this.fileTree = new WebFileTree(StyleId.directorychooserFileSystem.at(treeScroll), FileTreeRootType.drives);
        this.fileTree.setVisibleRowCount(15);
        this.fileTree.setFileFilter(this.filter);
        this.fileTree.setSelectedFile(this.selectedDirectory, true);
        this.fileTree.setSelectionMode(1);
        this.fileTree.setEditable(true);
        treeScroll.setViewportView(this.fileTree);
        this.fileTreeListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                WebDirectoryChooserPanel.this.updateSelectedDirectory(WebDirectoryChooserPanel.this.fileTree.getSelectedFile(), true, false);
            }
        };
        this.fileTree.addTreeSelectionListener(this.fileTreeListener);
        this.fileTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                WebDirectoryChooserPanel.this.updateToolbarControlsState();
            }
        });
        return treeScroll;
    }

    protected WebPathField createPathField() {
        this.webPathField = new WebPathField(StyleId.directorychooserPathField.at(this), this.selectedDirectory);
        this.webPathField.setFileFilter(this.filter);
        this.webPathField.addPathFieldListener(new PathFieldListener(){

            @Override
            public void directoryChanged(File newDirectory) {
                WebDirectoryChooserPanel.this.updateSelectedDirectory(WebDirectoryChooserPanel.this.webPathField.getSelectedPath(), false, true);
            }
        });
        return this.webPathField;
    }

    protected WebToolBar createToolBar() {
        WebToolBar toolBar = new WebToolBar(StyleId.directorychooserToolbar.at(this));
        StyleId folderUpId = StyleId.directorychooserFolderUpButton.at(toolBar);
        this.folderUp = new WebButton(folderUpId, "weblaf.ex.dirchooser.folderup", (Icon)Icons.folderUp);
        this.folderUp.addHotkey(this, Hotkey.ALT_UP).setHotkeyDisplayWay(TooltipWay.down);
        this.folderUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebDirectoryChooserPanel.this.selectedDirectory != null) {
                    WebDirectoryChooserPanel.this.updateSelectedDirectory(FileUtils.getParent(WebDirectoryChooserPanel.this.selectedDirectory), true, true);
                }
            }
        });
        toolBar.add((Component)this.folderUp);
        StyleId folderHomeId = StyleId.directorychooserHomeButton.at(toolBar);
        this.folderHome = new WebButton(folderHomeId, "weblaf.ex.dirchooser.home", (Icon)Icons.folderHome);
        this.folderHome.addHotkey(this, Hotkey.ALT_H).setHotkeyDisplayWay(TooltipWay.trailing);
        this.folderHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebDirectoryChooserPanel.this.updateSelectedDirectory(FileUtils.getUserHome(), true, true);
            }
        });
        toolBar.add((Component)this.folderHome);
        final File desktop = FileUtils.getDesktop();
        if (desktop != null) {
            StyleId desktopHomeId = StyleId.directorychooserDesktopButton.at(toolBar);
            this.folderDesktop = new WebButton(desktopHomeId, "weblaf.ex.dirchooser.desktop", (Icon)Icons.folderDesktop);
            this.folderDesktop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebDirectoryChooserPanel.this.updateSelectedDirectory(desktop, true, true);
                }
            });
            toolBar.add((Component)this.folderDesktop);
        }
        toolBar.addSeparator();
        for (final File file : FileTreeRootType.drives.getRoots()) {
            StyleId driveId = StyleId.directorychooserDriveButton.at(toolBar);
            WebButton drive = new WebButton(driveId, (Icon)Icons.drive);
            drive.setToolTip(FileUtils.getDisplayFileName(file));
            drive.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebDirectoryChooserPanel.this.updateSelectedDirectory(file, true, true);
                }
            });
            toolBar.add((Component)drive);
        }
        StyleId refreshId = StyleId.directorychooserRefreshButton.at(toolBar);
        this.refresh = new WebButton(refreshId, "weblaf.ex.dirchooser.refresh", (Icon)Icons.refresh);
        this.refresh.addHotkey(this, Hotkey.F5).setHotkeyDisplayWay(TooltipWay.leading);
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebDirectoryChooserPanel.this.selectedDirectory != null) {
                    WebDirectoryChooserPanel.this.fileTree.reloadChildren(WebDirectoryChooserPanel.this.selectedDirectory);
                } else {
                    WebDirectoryChooserPanel.this.fileTree.reloadRootNode();
                }
            }
        });
        toolBar.add((Component)this.refresh, (Object)"END");
        StyleId folderNewId = StyleId.directorychooserNewFolderButton.at(toolBar);
        this.folderNew = new WebButton(folderNewId, "weblaf.ex.dirchooser.newfolder", (Icon)Icons.folderNew);
        this.folderNew.addHotkey(this, Hotkey.CTRL_N).setHotkeyDisplayWay(TooltipWay.down);
        this.folderNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebDirectoryChooserPanel.this.selectedDirectory != null) {
                    String defaultName = LM.get("weblaf.ex.dirchooser.newfolder.name", new Object[0]);
                    String freeName = FileUtils.getAvailableName(WebDirectoryChooserPanel.this.selectedDirectory, defaultName);
                    File file = new File(WebDirectoryChooserPanel.this.selectedDirectory, freeName);
                    if (file.mkdir()) {
                        WebDirectoryChooserPanel.this.fileTree.addFile(WebDirectoryChooserPanel.this.selectedDirectory, file);
                        WebDirectoryChooserPanel.this.fileTree.startEditingFile(file);
                    } else {
                        String message = LM.get("weblaf.ex.dirchooser.newfolder.error.text", new Object[0]);
                        String title = LM.get("weblaf.ex.dirchooser.newfolder.error.title", new Object[0]);
                        WebOptionPane.showMessageDialog(WebDirectoryChooserPanel.this, message, title, 0);
                    }
                }
            }
        });
        toolBar.add((Component)this.folderNew, (Object)"END");
        StyleId removeId = StyleId.directorychooserDeleteButton.at(toolBar);
        this.remove = new WebButton(removeId, "weblaf.ex.dirchooser.delete", (Icon)Icons.remove);
        this.remove.addHotkey(this, Hotkey.DELETE).setHotkeyDisplayWay(TooltipWay.down);
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String title;
                File file = WebDirectoryChooserPanel.this.fileTree.getSelectedFile();
                if (file == null) {
                    return;
                }
                String message = LM.get("weblaf.ex.dirchooser.delete.confirm.text", new Object[0]);
                int confirm = WebOptionPane.showConfirmDialog(WebDirectoryChooserPanel.this, message, title = LM.get("weblaf.ex.dirchooser.delete.confirm.title", new Object[0]), 0, 3);
                if (confirm == 0) {
                    FileTreeNode parentNode = (FileTreeNode)((FileTreeNode)WebDirectoryChooserPanel.this.fileTree.getSelectedNode()).getParent();
                    int index = parentNode.indexOfFileChild(file);
                    int count = parentNode.getChildCount();
                    FileUtils.deleteFile(file);
                    WebDirectoryChooserPanel.this.fileTree.removeFile(file);
                    WebDirectoryChooserPanel.this.fileTree.setSelectedNode(count == 1 ? parentNode : (index < count - 1 ? (FileTreeNode)parentNode.getChildAt(index) : (FileTreeNode)parentNode.getChildAt(index - 1)));
                }
            }
        });
        toolBar.add((Component)this.remove, (Object)"END");
        return toolBar;
    }

    protected WebPanel createControlsPanel() {
        StyleId controlsPanelId = StyleId.directorychooserControlsPanel.at(this);
        WebPanel controlsPanel = new WebPanel(controlsPanelId, new BorderLayout(0, 0), new Component[0]);
        StyleId acceptButtonId = StyleId.directorychooserAcceptButton.at(controlsPanel);
        this.acceptButton = new WebButton(acceptButtonId, "weblaf.ex.dirchooser.choose", (Icon)Icons.accept);
        this.acceptButton.addHotkey(Hotkey.CTRL_ENTER);
        this.acceptButton.setEnabled(false);
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebDirectoryChooserPanel.this.fireAccepted(WebDirectoryChooserPanel.this.getSelectedDirectory());
            }
        });
        StyleId cancelButtonId = StyleId.directorychooserCancelButton.at(controlsPanel);
        this.cancelButton = new WebButton(cancelButtonId, "weblaf.ex.dirchooser.cancel", (Icon)Icons.cancel);
        this.cancelButton.addHotkey(Hotkey.ESCAPE);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebDirectoryChooserPanel.this.fireCancelled();
            }
        });
        controlsPanel.add((Component)new GroupPanel(4, this.acceptButton, this.cancelButton), (Object)"After");
        ImmutableList<String> properties = new ImmutableList<String>("text");
        SwingUtils.equalizeComponentsWidth(properties, this.acceptButton, this.cancelButton);
        this.updateButtonsState(this.getSelectedDirectory());
        this.addDirectoryChooserListener(new DirectoryChooserAdapter(){

            @Override
            public void selectionChanged(File file) {
                WebDirectoryChooserPanel.this.updateButtonsState(file);
            }
        });
        return controlsPanel;
    }

    protected void updateButtonsState(File file) {
        this.acceptButton.setEnabled(file != null);
    }

    protected void updateToolbarControlsState() {
        File selectedFile = this.fileTree.getSelectedFile();
        this.folderUp.setEnabled(selectedFile != null && FileUtils.getParent(selectedFile) != null);
        this.folderNew.setEnabled(selectedFile != null && selectedFile.canWrite());
        this.remove.setEnabled(selectedFile != null && FileUtils.getParent(selectedFile) != null && selectedFile.canWrite());
    }

    protected void updateSelectedDirectory(final File directory, boolean updatePath, boolean updateTree) {
        this.selectedDirectory = directory;
        if (updatePath) {
            this.webPathField.setSelectedPath(directory);
        }
        if (updateTree) {
            if (directory != null) {
                this.fileTree.expandToFile(directory, false, true, new Runnable(){

                    @Override
                    public void run() {
                        WebDirectoryChooserPanel.this.fileTree.removeTreeSelectionListener(WebDirectoryChooserPanel.this.fileTreeListener);
                        WebDirectoryChooserPanel.this.fileTree.setSelectedNode(WebDirectoryChooserPanel.this.fileTree.getNode(directory));
                        WebDirectoryChooserPanel.this.fileTree.addTreeSelectionListener(WebDirectoryChooserPanel.this.fileTreeListener);
                    }
                });
            } else {
                this.fileTree.clearSelection();
                this.fileTree.scrollToStart();
            }
        }
        this.fireSelectionChanged(this.selectedDirectory);
    }

    public AbstractFileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(AbstractFileFilter filter2) {
        this.filter = filter2;
        this.fileTree.setFileFilter(filter2);
    }

    public File getSelectedDirectory() {
        return this.selectedDirectory;
    }

    public void setSelectedDirectory(File selectedDirectory) {
        this.updateSelectedDirectory(selectedDirectory, true, true);
    }

    public boolean allowHotkeys() {
        return !this.fileTree.isEditing() && !this.webPathField.isEditing();
    }

    public void addDirectoryChooserListener(DirectoryChooserListener listener) {
        this.listeners.add(listener);
    }

    public void removeDirectoryChooserListener(DirectoryChooserListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireSelectionChanged(File file) {
        for (DirectoryChooserListener listener : CollectionUtils.copy(this.listeners)) {
            listener.selectionChanged(file);
        }
    }

    protected void fireAccepted(File file) {
        for (DirectoryChooserListener listener : CollectionUtils.copy(this.listeners)) {
            listener.accepted(file);
        }
    }

    protected void fireCancelled() {
        for (DirectoryChooserListener listener : CollectionUtils.copy(this.listeners)) {
            listener.cancelled();
        }
    }
}

