/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.filechooser.DirectoryChooserAdapter;
import com.alee.extended.filechooser.DirectoryChooserListener;
import com.alee.extended.filechooser.WebDirectoryChooserPanel;
import com.alee.laf.window.WebDialog;
import com.alee.managers.icon.Icons;
import com.alee.utils.ImageUtils;
import com.alee.utils.filefilter.AbstractFileFilter;
import com.alee.utils.swing.DialogOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

public class WebDirectoryChooser
extends WebDialog
implements DialogOptions {
    protected WebDirectoryChooserPanel directoryChooserPanel;
    protected int result = -2;

    public WebDirectoryChooser(Window parent) {
        this(parent, (String)null);
    }

    public WebDirectoryChooser(Window parent, String title) {
        super(parent, title != null ? title : "weblaf.ex.dirchooser.title");
        this.setIconImage(ImageUtils.toBufferedImage(Icons.dir));
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.directoryChooserPanel = new WebDirectoryChooserPanel();
        this.directoryChooserPanel.addDirectoryChooserListener(new DirectoryChooserAdapter(){

            @Override
            public void accepted(File file) {
                WebDirectoryChooser.this.result = 0;
                WebDirectoryChooser.this.dispose();
            }

            @Override
            public void cancelled() {
                WebDirectoryChooser.this.result = 1;
                WebDirectoryChooser.this.dispose();
            }
        });
        this.getContentPane().add((Component)this.directoryChooserPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                WebDirectoryChooser.this.result = -1;
            }
        });
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.pack();
    }

    public AbstractFileFilter getFilter() {
        return this.directoryChooserPanel.getFilter();
    }

    public void setFilter(AbstractFileFilter filter2) {
        this.directoryChooserPanel.setFilter(filter2);
    }

    public int getResult() {
        return this.result;
    }

    public File getSelectedDirectory() {
        return this.directoryChooserPanel.getSelectedDirectory();
    }

    public void setSelectedDirectory(File selectedDirectory) {
        this.directoryChooserPanel.setSelectedDirectory(selectedDirectory);
    }

    public void addDirectoryChooserListener(DirectoryChooserListener listener) {
        this.directoryChooserPanel.addDirectoryChooserListener(listener);
    }

    public void removeDirectoryChooserListener(DirectoryChooserListener listener) {
        this.directoryChooserPanel.removeDirectoryChooserListener(listener);
    }

    public int showDialog() {
        this.setVisible(true);
        return this.getResult();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.result = -2;
            this.setLocationRelativeTo(this.getOwner());
        }
        super.setVisible(b);
    }

    public static File showDialog(Window parent) {
        return WebDirectoryChooser.showDialog(parent, null, null);
    }

    public static File showDialog(Window parent, String title) {
        return WebDirectoryChooser.showDialog(parent, title, null);
    }

    public static File showDialog(Window parent, File directory) {
        return WebDirectoryChooser.showDialog(parent, null, directory);
    }

    public static File showDialog(Window parent, String title, File directory) {
        WebDirectoryChooser wdc = new WebDirectoryChooser(parent, title);
        if (directory != null) {
            wdc.setSelectedDirectory(directory);
        }
        wdc.setVisible(true);
        return wdc.getResult() == 0 ? wdc.getSelectedDirectory() : null;
    }
}

