/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock.drag;

import com.alee.api.annotations.NotNull;
import com.alee.extended.dock.WebDockableFrame;
import com.alee.extended.dock.WebDockablePane;
import com.alee.extended.dock.drag.FrameDragData;
import com.alee.extended.dock.drag.FrameTransferable;
import com.alee.managers.drag.DragException;
import com.alee.managers.drag.view.ComponentDragViewHandler;
import com.alee.utils.SwingUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;

public class FrameDragViewHandler
extends ComponentDragViewHandler<WebDockableFrame, FrameDragData> {
    @NotNull
    protected final WeakReference<WebDockablePane> dockablePane;

    public FrameDragViewHandler(@NotNull WebDockablePane dockablePane) {
        this.dockablePane = new WeakReference<WebDockablePane>(dockablePane);
    }

    @Override
    @NotNull
    public DataFlavor getObjectFlavor() {
        return FrameTransferable.dataFlavor;
    }

    @Override
    public boolean supports(@NotNull FrameDragData object, @NotNull DragSourceDragEvent event) {
        WebDockablePane dockablePane = (WebDockablePane)this.dockablePane.get();
        return dockablePane != null && dockablePane.findFrame(object.getId()) != null;
    }

    @Override
    @NotNull
    public WebDockableFrame getComponent(@NotNull FrameDragData object, @NotNull DragSourceDragEvent event) {
        WebDockablePane pane = (WebDockablePane)this.dockablePane.get();
        if (pane != null) {
            return pane.getFrame(object.getId());
        }
        String msg = "Unable to resolve WebDockablePane for dragged frame with identifier: %s";
        throw new DragException(String.format("Unable to resolve WebDockablePane for dragged frame with identifier: %s", object.getId()));
    }

    @Override
    @NotNull
    protected Point calculateViewRelativeLocation(@NotNull WebDockableFrame frame, @NotNull DragSourceDragEvent event) {
        Point location = super.calculateViewRelativeLocation(frame, event);
        WebDockablePane pane = frame.getDockablePane();
        if (pane != null) {
            Dimension size = pane.getModel().getElement(frame.getId()).getSize();
            Dimension current = frame.getSize();
            if (current.width > size.width && Math.abs(location.x) > size.width) {
                location.x = location.x * size.width / current.width;
            }
            return location;
        }
        throw new DragException("Unable to drag frame that is not attached to a WebDockablePane: " + frame.getId());
    }

    @Override
    @NotNull
    protected BufferedImage createComponentView(@NotNull WebDockableFrame frame) {
        WebDockablePane pane = frame.getDockablePane();
        if (pane != null) {
            Dimension size = pane.getModel().getElement(frame.getId()).getSize();
            return SwingUtils.createComponentSnapshot(frame, size.width, size.height, this.getSnapshotOpacity());
        }
        throw new DragException("Unable to drag frame that is not attached to a WebDockablePane: " + frame.getId());
    }
}

