/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.CompassDirection;
import com.alee.api.jdk.Objects;
import com.alee.extended.WebContainer;
import com.alee.extended.dock.DockableFrameState;
import com.alee.extended.dock.DockablePaneListener;
import com.alee.extended.dock.DockablePaneModel;
import com.alee.extended.dock.SidebarButtonAction;
import com.alee.extended.dock.SidebarButtonVisibility;
import com.alee.extended.dock.WDockablePaneUI;
import com.alee.extended.dock.WebDockableFrame;
import com.alee.extended.dock.WebDockablePaneModel;
import com.alee.extended.dock.data.DockableContainer;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.utils.CollectionUtils;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class WebDockablePane
extends WebContainer<WebDockablePane, WDockablePaneUI> {
    public static final String SIDEBAR_BUTTON_VISIBILITY_PROPERTY = "sidebarButtonVisibility";
    public static final String SIDEBAR_BUTTON_ACTION_PROPERTY = "sidebarButtonAction";
    public static final String GROUP_ELEMENTS_PROPERTY = "groupElements";
    public static final String SIDEBAR_SPACING_PROPERTY = "sidebarSpacing";
    public static final String CONTENT_SPACING_PROPERTY = "contentSpacing";
    public static final String RESIZE_GRIPPER_WIDTH_PROPERTY = "resizeGripperWidth";
    public static final String MINIMUM_ELEMENT_SIZE_PROPERTY = "minimumElementSize";
    public static final String OCCUPY_MINIMUM_SIZE_FOR_CHILDREN_PROPERTY = "occupyMinimumSizeForChildren";
    public static final String MODEL_PROPERTY = "model";
    public static final String MODEL_STATE_PROPERTY = "modelState";
    public static final String GLASS_LAYER_PROPERTY = "glassLayer";
    public static final String FRAMES_PROPERTY = "frames";
    public static final String FRAME_PROPERTY = "frame";
    public static final String CONTENT_PROPERTY = "content";
    @NotNull
    protected SidebarButtonVisibility sidebarButtonVisibility = SidebarButtonVisibility.minimized;
    @NotNull
    protected SidebarButtonAction sidebarButtonAction = SidebarButtonAction.restore;
    protected boolean groupElements = false;
    protected int sidebarSpacing = 0;
    protected int contentSpacing = 0;
    protected int resizeGripperWidth = 10;
    @NotNull
    protected Dimension minimumElementSize = new Dimension(40, 40);
    protected boolean occupyMinimumSizeForChildren = true;
    protected DockablePaneModel model;
    protected JComponent glassLayer;
    protected final List<WebDockableFrame> frames = new ArrayList<WebDockableFrame>(3);
    protected JComponent content;

    public WebDockablePane() {
        this(StyleId.auto);
    }

    public WebDockablePane(@NotNull StyleId id) {
        this.setModel(this.createDefaultModel());
        this.updateUI();
        this.setStyleId(id);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.dockablepane;
    }

    @NotNull
    public SidebarButtonVisibility getSidebarButtonVisibility() {
        return this.sidebarButtonVisibility;
    }

    @NotNull
    public WebDockablePane setSidebarButtonVisibility(@NotNull SidebarButtonVisibility condition) {
        if (this.sidebarButtonVisibility != condition) {
            SidebarButtonVisibility old = this.sidebarButtonVisibility;
            this.sidebarButtonVisibility = condition;
            this.firePropertyChange(SIDEBAR_BUTTON_VISIBILITY_PROPERTY, (Object)old, (Object)condition);
        }
        return this;
    }

    @NotNull
    public SidebarButtonAction getSidebarButtonAction() {
        return this.sidebarButtonAction;
    }

    @NotNull
    public WebDockablePane setSidebarButtonAction(@NotNull SidebarButtonAction action) {
        if (this.sidebarButtonAction != action) {
            SidebarButtonAction old = this.sidebarButtonAction;
            this.sidebarButtonAction = action;
            this.firePropertyChange(SIDEBAR_BUTTON_ACTION_PROPERTY, (Object)old, (Object)action);
        }
        return this;
    }

    public boolean isGroupElements() {
        return this.groupElements;
    }

    @NotNull
    public WebDockablePane setGroupElements(boolean group) {
        if (this.groupElements != group) {
            boolean old = this.groupElements;
            this.groupElements = group;
            this.firePropertyChange(GROUP_ELEMENTS_PROPERTY, old, group);
        }
        return this;
    }

    public int getSidebarSpacing() {
        return this.sidebarSpacing;
    }

    @NotNull
    public WebDockablePane setSidebarSpacing(int spacing) {
        if (this.sidebarSpacing != spacing) {
            int old = this.sidebarSpacing;
            this.sidebarSpacing = spacing;
            this.firePropertyChange(SIDEBAR_SPACING_PROPERTY, old, spacing);
        }
        return this;
    }

    public int getContentSpacing() {
        return this.contentSpacing;
    }

    @NotNull
    public WebDockablePane setContentSpacing(int spacing) {
        if (this.contentSpacing != spacing) {
            int old = this.contentSpacing;
            this.contentSpacing = spacing;
            this.firePropertyChange(CONTENT_SPACING_PROPERTY, old, spacing);
        }
        return this;
    }

    public int getResizeGripperWidth() {
        return this.resizeGripperWidth;
    }

    @NotNull
    public WebDockablePane setResizeGripperWidth(int resizeGripperWidth) {
        if (this.resizeGripperWidth != resizeGripperWidth) {
            int old = this.resizeGripperWidth;
            this.resizeGripperWidth = resizeGripperWidth;
            this.firePropertyChange(RESIZE_GRIPPER_WIDTH_PROPERTY, old, resizeGripperWidth);
        }
        return this;
    }

    @NotNull
    public Dimension getMinimumElementSize() {
        return this.minimumElementSize;
    }

    @NotNull
    public WebDockablePane setMinimumElementSize(@NotNull Dimension size) {
        if (this.minimumElementSize != size) {
            Dimension old = this.minimumElementSize;
            this.minimumElementSize = size;
            this.firePropertyChange(MINIMUM_ELEMENT_SIZE_PROPERTY, old, size);
        }
        return this;
    }

    public boolean isOccupyMinimumSizeForChildren() {
        return this.occupyMinimumSizeForChildren;
    }

    @NotNull
    public WebDockablePane setOccupyMinimumSizeForChildren(boolean occupy) {
        if (this.occupyMinimumSizeForChildren != occupy) {
            boolean old = this.occupyMinimumSizeForChildren;
            this.occupyMinimumSizeForChildren = occupy;
            this.firePropertyChange(OCCUPY_MINIMUM_SIZE_FOR_CHILDREN_PROPERTY, old, occupy);
        }
        return this;
    }

    @NotNull
    public DockablePaneModel getModel() {
        return this.model;
    }

    @NotNull
    public WebDockablePane setModel(@NotNull DockablePaneModel model) {
        if (this.model != model) {
            DockablePaneModel old = this.model;
            this.model = model;
            this.setLayout(model);
            this.firePropertyChange(MODEL_PROPERTY, old, model);
        }
        return this;
    }

    @NotNull
    protected DockablePaneModel createDefaultModel() {
        return new WebDockablePaneModel();
    }

    @NotNull
    public DockableContainer getState() {
        return this.getModel().getRoot();
    }

    @NotNull
    public WebDockablePane setState(@NotNull DockableContainer state) {
        if (this.getModel().getRoot() != state) {
            DockableContainer old = this.getModel().getRoot();
            this.getModel().setRoot(state);
            this.firePropertyChange(MODEL_STATE_PROPERTY, old, this.model);
        }
        return this;
    }

    @Nullable
    public JComponent getGlassLayer() {
        return this.glassLayer;
    }

    @NotNull
    public WebDockablePane setGlassLayer(@Nullable JComponent glassLayer) {
        if (this.glassLayer != glassLayer) {
            JComponent old = this.glassLayer;
            this.glassLayer = glassLayer;
            this.firePropertyChange(GLASS_LAYER_PROPERTY, old, glassLayer);
        }
        return this;
    }

    @NotNull
    public List<WebDockableFrame> getFrames() {
        return CollectionUtils.copy(this.frames);
    }

    @NotNull
    public List<WebDockableFrame> getFrames(@NotNull CompassDirection position) {
        ArrayList<WebDockableFrame> positioned = new ArrayList<WebDockableFrame>(this.frames.size());
        for (WebDockableFrame frame : this.frames) {
            if (frame.getPosition() != position) continue;
            positioned.add(frame);
        }
        return positioned;
    }

    @NotNull
    public WebDockableFrame getFrame(@NotNull String id) {
        WebDockableFrame frameById = this.findFrame(id);
        if (frameById == null) {
            throw new RuntimeException("Unable to find frame with identifier: " + id);
        }
        return frameById;
    }

    @Nullable
    public WebDockableFrame findFrame(@NotNull String id) {
        WebDockableFrame frameById = null;
        for (WebDockableFrame frame : this.frames) {
            if (!Objects.equals((Object)id, (Object)frame.getId())) continue;
            frameById = frame;
            break;
        }
        return frameById;
    }

    @Nullable
    public WebDockableFrame getMaximizedFrame() {
        WebDockableFrame maximizedFrame = null;
        for (WebDockableFrame frame : this.frames) {
            if (!frame.isMaximized()) continue;
            maximizedFrame = frame;
            break;
        }
        return maximizedFrame;
    }

    @NotNull
    public WebDockableFrame addFrame(@NotNull WebDockableFrame frame) {
        if (!this.frames.contains(frame)) {
            ArrayList<WebDockableFrame> old = CollectionUtils.copy(this.frames);
            this.frames.add(frame);
            this.firePropertyChange(FRAMES_PROPERTY, old, this.frames);
            this.firePropertyChange(FRAME_PROPERTY, null, frame);
        }
        return frame;
    }

    @NotNull
    public WebDockableFrame removeFrame(@NotNull WebDockableFrame frame) {
        if (this.frames.contains(frame)) {
            ArrayList<WebDockableFrame> old = CollectionUtils.copy(this.frames);
            this.frames.remove(frame);
            this.firePropertyChange(FRAMES_PROPERTY, old, this.frames);
            this.firePropertyChange(FRAME_PROPERTY, frame, null);
        }
        return frame;
    }

    @Nullable
    public JComponent getContent() {
        return this.content;
    }

    @Nullable
    public JComponent setContent(@Nullable JComponent content) {
        JComponent old = this.content;
        if (this.content != content) {
            this.content = content;
            this.firePropertyChange(CONTENT_PROPERTY, old, content);
        }
        return old;
    }

    public void addDockablePaneListener(@NotNull DockablePaneListener listener) {
        this.listenerList.add(DockablePaneListener.class, listener);
    }

    public void removeDockablePaneListener(@NotNull DockablePaneListener listener) {
        this.listenerList.remove(DockablePaneListener.class, listener);
    }

    public void fireFrameAdded(@NotNull WebDockableFrame frame, @NotNull WebDockablePane dockablePane) {
        for (DockablePaneListener listener : (DockablePaneListener[])this.listenerList.getListeners(DockablePaneListener.class)) {
            listener.frameAdded(frame, dockablePane);
        }
    }

    public void fireFrameStateChanged(@NotNull WebDockableFrame frame, @NotNull DockableFrameState oldState, @NotNull DockableFrameState newState) {
        for (DockablePaneListener listener : (DockablePaneListener[])this.listenerList.getListeners(DockablePaneListener.class)) {
            listener.frameStateChanged(frame, oldState, newState);
        }
    }

    public void fireFrameMoved(@NotNull WebDockableFrame frame, @NotNull CompassDirection position) {
        for (DockablePaneListener listener : (DockablePaneListener[])this.listenerList.getListeners(DockablePaneListener.class)) {
            listener.frameMoved(frame, position);
        }
    }

    public void fireFrameRemoved(@NotNull WebDockableFrame frame, @NotNull WebDockablePane dockablePane) {
        for (DockablePaneListener listener : (DockablePaneListener[])this.listenerList.getListeners(DockablePaneListener.class)) {
            listener.frameRemoved(frame, dockablePane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyComponentOrientation(@NotNull ComponentOrientation orientation) {
        this.setComponentOrientation(orientation);
        Object object = this.getTreeLock();
        synchronized (object) {
            for (WebDockableFrame frame : this.frames) {
                frame.applyComponentOrientation(orientation);
            }
            JComponent content = this.getContent();
            if (content != null) {
                content.applyComponentOrientation(orientation);
            }
        }
    }

    @Override
    public WDockablePaneUI getUI() {
        return (WDockablePaneUI)this.ui;
    }

    public void setUI(WDockablePaneUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

