/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.behavior.VisibilityBehavior;
import com.alee.extended.dock.WebDockablePane;
import com.alee.extended.dock.data.DockableElement;
import com.alee.extended.dock.data.ResizeData;
import com.alee.extended.dock.drag.FrameDragData;
import com.alee.extended.dock.drag.FrameDragViewHandler;
import com.alee.extended.dock.drag.FrameDropData;
import com.alee.extended.dock.drag.FrameTransferable;
import com.alee.managers.drag.DragAdapter;
import com.alee.managers.drag.DragManager;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.SwingUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.slf4j.LoggerFactory;

public class DockablePaneGlassLayer
extends JComponent {
    @NotNull
    protected final WebDockablePane dockablePane;
    @Nullable
    protected FrameDropData frameDropData;
    @Nullable
    protected ResizeData resizeData;

    public DockablePaneGlassLayer(final @NotNull WebDockablePane dockablePane) {
        this.dockablePane = dockablePane;
        this.setOpaque(false);
        ProprietaryUtils.enableMixingCutoutShape(this);
        MouseAdapter mouseListener = new MouseAdapter(){
            @Nullable
            private Point initialPoint = null;
            @Nullable
            private DockableElement left = null;
            @Nullable
            private DockableElement right = null;
            @Nullable
            private Dimension initialLeftSize = null;
            @Nullable
            private Dimension initialRightSize = null;

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (!SwingUtils.isLeftMouseButton(e)) return;
                this.initialPoint = e.getPoint();
                DockablePaneGlassLayer.this.resizeData = DockablePaneGlassLayer.this.getResizeData(e.getX(), e.getY());
                if (DockablePaneGlassLayer.this.resizeData == null) {
                    this.cleanupResizeVariables();
                    return;
                }
                this.left = dockablePane.getModel().getElement(DockablePaneGlassLayer.this.resizeData.leftElementId());
                this.right = dockablePane.getModel().getElement(DockablePaneGlassLayer.this.resizeData.rightElementId());
                Rectangle leftBounds = this.left.getBounds();
                if (leftBounds == null) {
                    String leftId = DockablePaneGlassLayer.this.resizeData.leftElementId();
                    this.cleanupResizeVariables();
                    throw new RuntimeException("Unable to retrieve left element bounds: " + leftId);
                }
                this.initialLeftSize = leftBounds.getSize();
                Rectangle rightBounds = this.right.getBounds();
                if (rightBounds == null) {
                    String rightId = DockablePaneGlassLayer.this.resizeData.rightElementId();
                    this.cleanupResizeVariables();
                    throw new RuntimeException("Unable to retrieve bounds: " + rightId);
                }
                this.initialRightSize = rightBounds.getSize();
            }

            @Override
            public void mouseDragged(@NotNull MouseEvent e) {
                if (this.initialPoint != null && DockablePaneGlassLayer.this.resizeData != null && this.left != null && this.right != null && this.initialLeftSize != null && this.initialRightSize != null) {
                    Dimension minLeft = this.left.getMinimumSize(dockablePane);
                    Dimension minRight = this.right.getMinimumSize(dockablePane);
                    if (DockablePaneGlassLayer.this.resizeData.orientation().isHorizontal()) {
                        int change;
                        int m = e.getX() - this.initialPoint.x;
                        int n = change = m < 0 ? Math.max(minLeft.width - this.initialLeftSize.width, m) : Math.min(this.initialRightSize.width - minRight.width, m);
                        if (!this.left.isContent()) {
                            this.left.setSize(new Dimension(this.initialLeftSize.width + change, this.left.getSize().height));
                        }
                        if (!this.right.isContent()) {
                            this.right.setSize(new Dimension(this.initialRightSize.width - change, this.right.getSize().height));
                        }
                    } else {
                        int change;
                        int m = e.getY() - this.initialPoint.y;
                        int n = change = m < 0 ? Math.max(minLeft.height - this.initialLeftSize.height, m) : Math.min(this.initialRightSize.height - minRight.height, m);
                        if (!this.left.isContent()) {
                            this.left.setSize(new Dimension(this.left.getSize().width, this.initialLeftSize.height + change));
                        }
                        if (!this.right.isContent()) {
                            this.right.setSize(new Dimension(this.right.getSize().width, this.initialRightSize.height - change));
                        }
                    }
                    dockablePane.revalidate();
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (SwingUtils.isLeftMouseButton(e) && DockablePaneGlassLayer.this.resizeData != null) {
                    this.cleanupResizeVariables();
                }
            }

            private void cleanupResizeVariables() {
                this.initialPoint = null;
                DockablePaneGlassLayer.this.resizeData = null;
                this.left = null;
                this.right = null;
            }

            @Override
            public void mouseMoved(@NotNull MouseEvent e) {
                ResizeData data = DockablePaneGlassLayer.this.getResizeData(e.getX(), e.getY());
                if (data != null) {
                    if (data.orientation().isVertical()) {
                        DockablePaneGlassLayer.this.setCursor(Cursor.getPredefinedCursor(9));
                    } else {
                        DockablePaneGlassLayer.this.setCursor(Cursor.getPredefinedCursor(11));
                    }
                } else {
                    DockablePaneGlassLayer.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        };
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(@NotNull TransferHandler.TransferSupport support) {
                FrameDropData old = DockablePaneGlassLayer.this.frameDropData;
                FrameDropData frameDropData = DockablePaneGlassLayer.this.frameDropData = support.isDataFlavorSupported(FrameTransferable.dataFlavor) ? dockablePane.getModel().dropData(dockablePane, support) : null;
                if (old != DockablePaneGlassLayer.this.frameDropData) {
                    DockablePaneGlassLayer.this.repaint();
                }
                return DockablePaneGlassLayer.this.frameDropData != null;
            }

            @Override
            public boolean importData(@NotNull TransferHandler.TransferSupport support) {
                boolean imported;
                try {
                    imported = dockablePane.getModel().drop(dockablePane, support);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(CoreSwingUtils.class).error("Unable to complete drop operation", e);
                    imported = false;
                }
                return imported;
            }
        });
        final DragAdapter dragListener = new DragAdapter(){

            @Override
            public void exited(@NotNull DragSourceEvent event) {
                this.clearDropLocation();
            }

            @Override
            public void finished(@NotNull DragSourceDropEvent event) {
                this.clearDropLocation();
            }

            private void clearDropLocation() {
                if (DockablePaneGlassLayer.this.frameDropData != null) {
                    DockablePaneGlassLayer.this.frameDropData = null;
                    dockablePane.repaint();
                }
            }
        };
        final FrameDragViewHandler dragViewHandler = new FrameDragViewHandler(dockablePane);
        new VisibilityBehavior<DockablePaneGlassLayer>(this){

            @Override
            protected void displayed(@NotNull DockablePaneGlassLayer component2) {
                DragManager.addDragListener(component2, dragListener);
                DragManager.registerViewHandler(dragViewHandler);
            }

            @Override
            protected void hidden(@NotNull DockablePaneGlassLayer component2) {
                DragManager.unregisterViewHandler(dragViewHandler);
                DragManager.removeDragListener(component2, dragListener);
            }
        }.install();
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        if (this.frameDropData != null) {
            Graphics2D g2d = (Graphics2D)g;
            int sw = 3;
            boolean delta = true;
            int hf = (int)Math.round(Math.floor(1.5));
            Stroke os = GraphicsUtils.setupStroke(g2d, new BasicStroke(3.0f));
            Rectangle dl = this.frameDropData.getHighlight();
            g2d.setPaint(new Color(0, 0, 255, 55));
            g2d.fillRect(dl.x + 3, dl.y + 3, dl.width - 6 + 1, dl.height - 6 + 1);
            g2d.setPaint(new Color(0, 0, 0, 100));
            g2d.drawRect(dl.x + hf, dl.y + hf, dl.width - hf * 2, dl.height - hf * 2);
            GraphicsUtils.restoreStroke(g2d, os);
        }
    }

    @Override
    public boolean contains(int x, int y) {
        return this.checkDrag() || this.checkResize(x, y);
    }

    protected boolean checkDrag() {
        boolean isDragged = false;
        if (this.frameDropData != null) {
            isDragged = true;
        } else if (DragManager.isDragging(FrameTransferable.dataFlavor)) {
            try {
                Transferable transferable = DragManager.getTransferable();
                FrameDragData data = (FrameDragData)transferable.getTransferData(FrameTransferable.dataFlavor);
                isDragged = this.dockablePane.findFrame(data.getId()) != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isDragged;
    }

    protected boolean checkResize(int x, int y) {
        return this.resizeData != null || this.getResizeData(x, y) != null;
    }

    @Nullable
    protected ResizeData getResizeData(int x, int y) {
        return this.dockablePane.getModel().getResizeData(x, y);
    }
}

