/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.date;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.date.DateFieldState;
import com.alee.extended.date.DateListener;
import com.alee.extended.date.WebDateField;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;
import java.util.Date;

public class DateFieldSettingsProcessor
extends SettingsProcessor<WebDateField, DateFieldState, Configuration<DateFieldState>> {
    protected transient DateListener dateListener;

    public DateFieldSettingsProcessor(WebDateField dateField, Configuration configuration) {
        super(dateField, configuration);
    }

    @Override
    protected void register(@NotNull WebDateField dateField) {
        this.dateListener = new DateListener(){

            @Override
            public void dateChanged(@Nullable Date date) {
                DateFieldSettingsProcessor.this.save();
            }
        };
        dateField.addDateListener(this.dateListener);
    }

    @Override
    protected void unregister(@NotNull WebDateField dateField) {
        dateField.removeDateListener(this.dateListener);
        this.dateListener = null;
    }

    @Override
    @Nullable
    protected DateFieldState createDefaultValue() {
        return new DateFieldState((WebDateField)this.component());
    }

    @Override
    protected void loadSettings(@NotNull WebDateField dateField) {
        ((DateFieldState)this.loadSettings()).apply(dateField);
    }

    @Override
    protected void saveSettings(@NotNull WebDateField dateField) {
        this.saveSettings(new DateFieldState(dateField));
    }
}

