/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.colorchooser;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.extended.colorchooser.GradientColorData;
import com.alee.extended.colorchooser.GradientData;
import com.alee.extended.colorchooser.WebGradientColorChooserStyle;
import com.alee.laf.colorchooser.WebColorChooser;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.UISettingsManager;
import com.alee.utils.ColorUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.extensions.SizeMethods;
import com.alee.utils.swing.extensions.SizeMethodsImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WebGradientColorChooser
extends JComponent
implements MouseListener,
MouseMotionListener,
FocusListener,
SettingsMethods,
SizeMethods<WebGradientColorChooser> {
    private static final Color borderColor = Color.DARK_GRAY;
    private static final Color disabledBorderColor = Color.LIGHT_GRAY;
    private static final Color foreground = Color.BLACK;
    private static final Color disabledForeground = new Color(178, 178, 178);
    private static final Color innerBorderColor = WebGradientColorChooser.whiteColor(180);
    private static final float[] overlayFractions = new float[]{0.0f, 0.4f, 0.41f, 1.0f};
    private static final Color[] lineOverlayColors = new Color[]{WebGradientColorChooser.whiteColor(160), WebGradientColorChooser.whiteColor(120), WebGradientColorChooser.whiteColor(100), WebGradientColorChooser.whiteColor(40)};
    private static final Color[] controlOverlayColors = new Color[]{WebGradientColorChooser.whiteColor(80), WebGradientColorChooser.whiteColor(50), WebGradientColorChooser.whiteColor(20), ColorUtils.transparent()};
    private static final float closestPoint = 0.001f;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>(1);
    private GradientData gradientData;
    private int shadeWidth = WebGradientColorChooserStyle.shadeWidth;
    private int lineWidth = WebGradientColorChooserStyle.lineWidth;
    private Dimension gripperSize = WebGradientColorChooserStyle.gripperSize;
    private Insets margin = WebGradientColorChooserStyle.margin;
    private boolean paintLabels = WebGradientColorChooserStyle.paintLabels;
    private GradientColorData draggedGripper = null;
    private boolean draggedOut = false;

    public WebGradientColorChooser() {
        this(new GradientData());
    }

    public WebGradientColorChooser(GradientData gradientData) {
        this.setGradientData(gradientData);
        this.setFocusable(true);
        this.setFont(WebGradientColorChooserStyle.labelsFont);
        this.setForeground(WebGradientColorChooserStyle.foreground);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Color newColor;
        GradientColorData colorData;
        if (!this.isEnabled()) {
            return;
        }
        if (SwingUtils.isDoubleClick(e) && (colorData = this.getColorDataUnderPoint(e.getPoint())) != null && (newColor = WebColorChooser.showDialog((Component)this, colorData.getColor())) != null) {
            colorData.setColor(newColor);
            this.fireStateChanged();
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        GradientColorData colorData;
        if (!this.isEnabled()) {
            return;
        }
        if (!this.isFocusOwner()) {
            this.requestFocusInWindow();
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            float newLocation;
            GradientColorData colorData2 = this.getColorDataUnderPoint(e.getPoint());
            if (colorData2 != null) {
                if (SwingUtils.isAlt(e)) {
                    this.draggedGripper = colorData2.clone();
                    this.draggedGripper.setLocation(this.findFreeLocation(this.draggedGripper.getLocation()));
                    this.gradientData.addGradientColorData(this.draggedGripper);
                    this.draggedOut = false;
                    this.fireStateChanged();
                    this.repaint();
                } else {
                    this.draggedGripper = colorData2;
                    this.draggedOut = false;
                }
            }
            if (this.draggedGripper == null && e.getY() > 0 && this.isFree(newLocation = this.getLocationForPoint(e))) {
                this.draggedGripper = new GradientColorData(newLocation, this.getColorForLocation(newLocation));
                this.gradientData.addGradientColorData(this.draggedGripper);
                this.draggedOut = false;
                this.fireStateChanged();
                this.repaint();
            }
        } else if ((SwingUtils.isMiddleMouseButton(e) || SwingUtils.isRightMouseButton(e)) && this.gradientData.size() > 2 && (colorData = this.getColorDataUnderPoint(e.getPoint())) != null) {
            this.gradientData.removeGradientColorData(colorData);
            this.fireStateChanged();
            this.repaint();
        }
    }

    public GradientColorData getColorDataUnderPoint(Point point) {
        GradientColorData colorData = null;
        for (int i = this.gradientData.size() - 1; i >= 0; --i) {
            GradientColorData gcd = this.gradientData.get(i);
            if (!this.getGripperBounds(gcd).contains(point)) continue;
            colorData = gcd;
            break;
        }
        return colorData;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.draggedGripper != null) {
            if (e.getY() < -10 && this.gradientData.size() + (this.draggedOut ? 1 : 0) > 2) {
                if (!this.draggedOut) {
                    this.draggedOut = true;
                    this.gradientData.removeGradientColorData(this.draggedGripper);
                    this.fireStateChanged();
                    this.repaint();
                }
            } else {
                if (this.draggedOut) {
                    this.draggedOut = false;
                    this.gradientData.addGradientColorData(this.draggedGripper);
                }
                float newLocation = this.getLocationForPoint(e);
                newLocation = this.findFreeLocation(newLocation);
                this.draggedGripper.setLocation(newLocation);
                this.fireStateChanged();
                this.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.draggedGripper = null;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public boolean isFree(float location) {
        return !this.gradientData.containtsLocation(location);
    }

    private float findFreeLocation(float newLocation) {
        block4: {
            if (!this.gradientData.containtsLocation(newLocation)) break block4;
            if (newLocation == 1.0f) {
                while (this.gradientData.containtsLocation(newLocation)) {
                    newLocation -= 0.001f;
                }
            } else {
                while (this.gradientData.containtsLocation(newLocation)) {
                    newLocation += 0.001f;
                }
            }
        }
        return newLocation;
    }

    public Rectangle getGripperBounds(int index) {
        return this.getGripperBounds(this.gradientData.getGradientColorsData().get(index));
    }

    public Rectangle getGripperBounds(GradientColorData colorData) {
        float location = colorData.getLocation();
        Rectangle lineBounds = this.getLineBounds();
        int x = lineBounds.x + 2 + Math.round((float)(lineBounds.width - 4) * location) - this.gripperSize.width / 2;
        int y = lineBounds.y + lineBounds.height - this.gripperSize.height / 2;
        return new Rectangle(x, y, this.gripperSize.width, this.gripperSize.height);
    }

    private float getLocationForPoint(MouseEvent e) {
        return this.getLocationForPoint(e.getPoint());
    }

    public float getLocationForPoint(Point point) {
        Rectangle lineBounds = this.getLineBounds();
        int x = lineBounds.x + 2;
        int w = lineBounds.width - 4;
        return (float)Math.max(0, Math.min(point.x - x, w)) / (float)w;
    }

    public Color getColorForLocation(float location) {
        return this.gradientData.getColorForLocation(location);
    }

    public GradientData getGradientData() {
        return this.gradientData;
    }

    public void setGradientData(GradientData gradientData) {
        if (Objects.notEquals((Object)this.gradientData, (Object)gradientData)) {
            this.gradientData = gradientData;
            this.draggedGripper = null;
            this.fireStateChanged();
            this.repaint();
        }
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.updateBorder();
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public Dimension getGripperSize() {
        return this.gripperSize;
    }

    public void setGripperSize(Dimension gripperSize) {
        this.gripperSize = gripperSize;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    public void setMargin(int spacing) {
        this.setMargin(spacing, spacing, spacing, spacing);
    }

    private void updateBorder() {
        this.setBorder(BorderFactory.createEmptyBorder(this.margin.top, this.margin.left, this.margin.bottom, this.margin.right));
    }

    public boolean isPaintLabels() {
        return this.paintLabels;
    }

    public void setPaintLabels(boolean paintLabels) {
        this.paintLabels = paintLabels;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias(g2d);
        Rectangle lineBounds = this.getLineBounds();
        this.paintBorderedBackground(g2d, lineBounds, this.getLineBackgroundPainter(lineBounds), this.getLineOverlayPainter(lineBounds), false);
        this.paintControls(g2d, lineBounds);
        GraphicsUtils.restoreAntialias(g2d, aa);
    }

    private void paintControls(Graphics2D g2d, Rectangle lineBounds) {
        int x = lineBounds.x + 2;
        int w = lineBounds.width - 4;
        int y = lineBounds.y + lineBounds.height - this.gripperSize.height / 2;
        int textY = y + this.gripperSize.height;
        FontMetrics fm = g2d.getFontMetrics();
        int lineY = textY - LafUtils.getTextCenterShiftY(fm) - 1;
        for (int i = 0; i < this.gradientData.size(); ++i) {
            int gapInPercents;
            int textWidth;
            GradientColorData gradientColorData = this.gradientData.get(i);
            float currentLocation = gradientColorData.getLocation();
            int currentX = x + Math.round((float)w * currentLocation) - this.gripperSize.width / 2;
            Rectangle controlBounds = new Rectangle(currentX, y, this.gripperSize.width, this.gripperSize.height);
            this.paintBorderedBackground(g2d, controlBounds, gradientColorData.getColor(), this.getControlOverlayPainter(controlBounds), true);
            if (!this.paintLabels || i >= this.gradientData.size() - 1) continue;
            GradientColorData nextGradientColorData = this.gradientData.get(i + 1);
            int gapX1 = currentX + this.gripperSize.width;
            int gapX2 = x + Math.round((float)w * nextGradientColorData.getLocation()) - this.gripperSize.width / 2;
            if (gapX2 - gapX1 <= (textWidth = fm.stringWidth((gapInPercents = Math.round((nextGradientColorData.getLocation() - currentLocation) * 100.0f)) + "")) + 4) continue;
            int textX = (gapX1 + gapX2) / 2 - textWidth / 2;
            g2d.setPaint(this.isEnabled() ? foreground : disabledForeground);
            g2d.drawString(gapInPercents + "", textX, textY);
            if (gapX2 - gapX1 <= textWidth + 14) continue;
            g2d.setPaint(new GradientPaint(gapX1 + 2, 0.0f, ColorUtils.transparent(), textX - 2, 0.0f, Color.LIGHT_GRAY));
            g2d.drawLine(gapX1 + 2, lineY, textX - 2, lineY);
            g2d.setPaint(new GradientPaint(textX + textWidth + 2, 0.0f, Color.LIGHT_GRAY, gapX2 - 2, 0.0f, ColorUtils.transparent()));
            g2d.drawLine(textX + textWidth + 2, lineY, gapX2 - 2, lineY);
        }
    }

    private void paintBorderedBackground(Graphics2D g2d, Rectangle bounds, Paint background, Paint overlay, boolean control2) {
        if (this.isEnabled() && !control2) {
            GraphicsUtils.drawShade(g2d, new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, 4.0, 4.0), this.isFocusOwner() ? new Color(85, 142, 239) : new Color(170, 170, 170), this.shadeWidth);
        }
        g2d.setPaint(background);
        g2d.fillRoundRect(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2, 2, 2);
        g2d.setPaint(innerBorderColor);
        g2d.drawRoundRect(bounds.x + 1, bounds.y + 1, bounds.width - 3, bounds.height - 3, 2, 2);
        if (control2) {
            int alpha = 180;
            g2d.setPaint(new GradientPaint(bounds.x + 2, bounds.y + 2, WebGradientColorChooser.whiteColor(180), bounds.x + bounds.width * 2 / 3, bounds.y + bounds.height - 2, ColorUtils.transparent()));
            g2d.fillRect(bounds.x + 2, bounds.y + 2, bounds.width - 4, bounds.height - 4);
        }
        g2d.setPaint(overlay);
        g2d.fillRect(bounds.x + 2, bounds.y + 2, bounds.width - 4, bounds.height - 4);
        g2d.setPaint(this.isEnabled() ? borderColor : disabledBorderColor);
        g2d.drawRoundRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, 4, 4);
    }

    private LinearGradientPaint getLineBackgroundPainter(Rectangle lineBounds) {
        return new LinearGradientPaint(lineBounds.x + 1, 0.0f, lineBounds.x + lineBounds.width - 1, 0.0f, this.gradientData.getFractions(), this.gradientData.getColors());
    }

    private LinearGradientPaint getLineOverlayPainter(Rectangle bounds) {
        return this.getOverlayPainter(bounds, overlayFractions, lineOverlayColors);
    }

    private LinearGradientPaint getControlOverlayPainter(Rectangle bounds) {
        return this.getOverlayPainter(bounds, overlayFractions, controlOverlayColors);
    }

    private LinearGradientPaint getOverlayPainter(Rectangle bounds, float[] overlayFractions, Color[] overlayColors) {
        return new LinearGradientPaint(0.0f, bounds.y + 2, 0.0f, bounds.y + bounds.height - 2, overlayFractions, overlayColors);
    }

    private Rectangle getLineBounds() {
        Insets insets = this.getInsets();
        return new Rectangle(insets.left + Math.max(this.gripperSize.width / 2, this.shadeWidth) - 2, insets.top + this.shadeWidth, this.getWidth() - insets.left - insets.right - Math.max(this.gripperSize.width, this.shadeWidth * 2) + 4, this.lineWidth);
    }

    public List<ChangeListener> getChangeListeners() {
        return this.changeListeners;
    }

    public void addChangeListener(ChangeListener dataChangeListener) {
        this.changeListeners.add(dataChangeListener);
    }

    public void removeChangeListener(ChangeListener dataChangeListener) {
        this.changeListeners.remove(dataChangeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener dataChangeListener : this.changeListeners) {
            dataChangeListener.stateChanged(changeEvent);
        }
    }

    @Override
    public void registerSettings(Configuration configuration) {
        UISettingsManager.registerComponent((JComponent)this, configuration);
    }

    @Override
    public void registerSettings(SettingsProcessor processor) {
        UISettingsManager.registerComponent((JComponent)this, processor);
    }

    @Override
    public void unregisterSettings() {
        UISettingsManager.unregisterComponent(this);
    }

    @Override
    public void loadSettings() {
        UISettingsManager.loadSettings(this);
    }

    @Override
    public void saveSettings() {
        UISettingsManager.saveSettings(this);
    }

    @Override
    public int getPreferredWidth() {
        return SizeMethodsImpl.getPreferredWidth(this);
    }

    @Override
    @NotNull
    public WebGradientColorChooser setPreferredWidth(int preferredWidth) {
        return (WebGradientColorChooser)SizeMethodsImpl.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeMethodsImpl.getPreferredHeight(this);
    }

    @Override
    @NotNull
    public WebGradientColorChooser setPreferredHeight(int preferredHeight) {
        return (WebGradientColorChooser)SizeMethodsImpl.setPreferredHeight(this, preferredHeight);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return SizeMethodsImpl.getPreferredSize(this, this.getActualPreferredSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalPreferredSize() {
        return SizeMethodsImpl.getOriginalPreferredSize(this, this.getActualPreferredSize());
    }

    @Override
    @NotNull
    public WebGradientColorChooser setPreferredSize(int width, int height) {
        return (WebGradientColorChooser)SizeMethodsImpl.setPreferredSize(this, width, height);
    }

    @Override
    public int getMaximumWidth() {
        return SizeMethodsImpl.getMaximumWidth(this);
    }

    @Override
    @NotNull
    public WebGradientColorChooser setMaximumWidth(int maximumWidth) {
        return (WebGradientColorChooser)SizeMethodsImpl.setMaximumWidth(this, maximumWidth);
    }

    @Override
    public int getMaximumHeight() {
        return SizeMethodsImpl.getMaximumHeight(this);
    }

    @Override
    @NotNull
    public WebGradientColorChooser setMaximumHeight(int maximumHeight) {
        return (WebGradientColorChooser)SizeMethodsImpl.setMaximumHeight(this, maximumHeight);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return SizeMethodsImpl.getMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMaximumSize() {
        return SizeMethodsImpl.getOriginalMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public WebGradientColorChooser setMaximumSize(int width, int height) {
        return (WebGradientColorChooser)SizeMethodsImpl.setMaximumSize(this, width, height);
    }

    @Override
    public int getMinimumWidth() {
        return SizeMethodsImpl.getMinimumWidth(this);
    }

    @Override
    @NotNull
    public WebGradientColorChooser setMinimumWidth(int minimumWidth) {
        return (WebGradientColorChooser)SizeMethodsImpl.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeMethodsImpl.getMinimumHeight(this);
    }

    @Override
    @NotNull
    public WebGradientColorChooser setMinimumHeight(int minimumHeight) {
        return (WebGradientColorChooser)SizeMethodsImpl.setMinimumHeight(this, minimumHeight);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return SizeMethodsImpl.getMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMinimumSize() {
        return SizeMethodsImpl.getOriginalMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public WebGradientColorChooser setMinimumSize(int width, int height) {
        return (WebGradientColorChooser)SizeMethodsImpl.setMinimumSize(this, width, height);
    }

    protected Dimension getActualPreferredSize() {
        Insets i = this.getInsets();
        int width = i.left + this.gripperSize.width * 5 + Math.max(this.gripperSize.width, this.shadeWidth * 2) - 4 + i.right;
        int height = i.top + this.shadeWidth * 2 + this.lineWidth + this.gripperSize.height / 2 + (this.gripperSize.height % 2 == 0 ? 0 : 1) + i.bottom;
        return new Dimension(width, height);
    }

    @NotNull
    private static Color whiteColor(int alpha) {
        return new Color(255, 255, 255, alpha);
    }
}

