/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.colorchooser;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.colorchooser.ColorChooserListener;
import com.alee.extended.colorchooser.ColorDisplayType;
import com.alee.extended.icon.ColorIcon;
import com.alee.extended.window.PopOverAlignment;
import com.alee.extended.window.PopOverDirection;
import com.alee.extended.window.WebPopOver;
import com.alee.laf.button.WebButton;
import com.alee.laf.colorchooser.WebColorChooserPanel;
import com.alee.laf.label.WebLabel;
import com.alee.laf.text.WebTextField;
import com.alee.laf.window.WebWindow;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.icon.Icons;
import com.alee.managers.style.BoundsType;
import com.alee.managers.style.StyleId;
import com.alee.utils.ColorUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.TextUtils;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.slf4j.LoggerFactory;

public class WebColorChooserField
extends WebTextField {
    protected ColorDisplayType colorDisplayType;
    protected boolean displayEyedropper = true;
    protected final int eyedropperImageSide = 9;
    protected final int eyedropperImagePixelSize = 11;
    protected String lastCorrectColorText = "";
    protected Color color;
    protected final WebButton colorButton;
    protected Robot robot;
    protected WebButton eyedropperPicker;
    protected WebPopOver popup;
    protected WebColorChooserPanel colorChooserPanel;

    public WebColorChooserField() {
        this(StyleId.auto);
    }

    public WebColorChooserField(@Nullable Color color) {
        this(StyleId.auto, color);
    }

    public WebColorChooserField(@NotNull StyleId id) {
        this(id, (Color)null);
    }

    public WebColorChooserField(@NotNull StyleId id, @Nullable Color color) {
        super(id);
        this.setHorizontalAlignment(0);
        this.updateEyedropper();
        StyleId colorButtonId = StyleId.colorchooserfieldColorButton.at(this);
        this.colorButton = new WebButton(colorButtonId, (Icon)new ColorIcon(color));
        this.colorButton.setCursor(Cursor.getDefaultCursor());
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebColorChooserField.this.showColorChooserPopup();
            }
        });
        this.setTrailingComponent(this.colorButton);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebColorChooserField.this.updateColorFromField();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                WebColorChooserField.this.updateColorFromField();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (WebColorChooserField.this.isEnabled() && SwingUtilities.isRightMouseButton(e)) {
                    WebColorChooserField.this.showColorChooserPopup();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (WebColorChooserField.this.isEnabled()) {
                    if (Hotkey.ESCAPE.isTriggered(e)) {
                        WebColorChooserField.this.updateViewFromColor();
                    } else if (Hotkey.DOWN.isTriggered(e)) {
                        WebColorChooserField.this.showColorChooserPopup();
                    }
                }
            }
        });
        this.setColorDisplayType(ColorDisplayType.rgb);
        this.setColorImpl(color);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.colorchooserfield;
    }

    public boolean isDisplayEyedropper() {
        return this.displayEyedropper;
    }

    public void setDisplayEyedropper(boolean displayEyedropper) {
        this.displayEyedropper = displayEyedropper;
        this.updateEyedropper();
    }

    @Nullable
    public Color getColor() {
        return this.color;
    }

    public void setColor(@Nullable Color color) {
        this.setColorImpl(color);
    }

    protected void setColorImpl(@Nullable Color color) {
        Color oldColor = this.color;
        this.color = color;
        this.updateViewFromColor();
        this.fireColorChanged(oldColor, color);
    }

    @NotNull
    public ColorDisplayType getColorDisplayType() {
        return this.colorDisplayType;
    }

    public void setColorDisplayType(@NotNull ColorDisplayType colorDisplayType) {
        this.colorDisplayType = colorDisplayType;
        this.updateFieldType();
    }

    protected void updateViewFromColor() {
        this.colorButton.setIcon(new ColorIcon(this.color));
        this.updateText();
    }

    protected void updateColorFromField() {
        String text = this.getText();
        if (!text.equals(this.lastCorrectColorText)) {
            if (TextUtils.notEmpty(text)) {
                try {
                    boolean hex = this.colorDisplayType.equals((Object)ColorDisplayType.hex);
                    this.setColorImpl(hex ? ColorUtils.fromHex(text) : ColorUtils.fromRGBA(text));
                }
                catch (Exception e) {
                    this.updateViewFromColor();
                }
            } else {
                this.setColor(null);
            }
        }
    }

    protected void updateFieldType() {
        boolean hex = this.colorDisplayType.equals((Object)ColorDisplayType.hex);
        this.setColumns(hex ? 6 : 9);
        this.updateText();
    }

    protected void updateText() {
        String text = this.getColorText(this.color);
        this.setText(text);
        this.lastCorrectColorText = text;
    }

    protected String getColorText(@Nullable Color color) {
        boolean hex;
        String text = color != null ? ((hex = this.colorDisplayType.equals((Object)ColorDisplayType.hex)) ? ColorUtils.toHex(color) : color.getRed() + "," + color.getGreen() + "," + color.getBlue() + (color.getAlpha() < 255 ? "," + color.getAlpha() : "")) : "";
        return text;
    }

    protected void updateEyedropper() {
        if (this.displayEyedropper) {
            this.installEyedropper();
        } else {
            this.uninstallEyedropper();
        }
        this.revalidate();
    }

    protected void installEyedropper() {
        if (this.eyedropperPicker == null) {
            StyleId eyedropperButtonId = StyleId.colorchooserfieldEyedropperButton.at(this);
            this.eyedropperPicker = new WebButton(eyedropperButtonId, (Icon)Icons.eyedropper, (Icon)Icons.eyedropperHover);
            this.eyedropperPicker.setPadding(0, 2, 0, 2);
            try {
                this.robot = new Robot();
            }
            catch (AWTException e) {
                LoggerFactory.getLogger(WebColorChooserField.class).error(e.toString(), e);
            }
            if (this.robot != null) {
                MouseAdapter mouseAdapter = new MouseAdapter(){
                    private boolean shouldUpdateColor;
                    private WebWindow window;
                    private JComponent screen;
                    private WebLabel info;
                    private boolean updating = false;
                    private BufferedImage screenshot;
                    private Color color;

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (WebColorChooserField.this.displayEyedropper && SwingUtils.isLeftMouseButton(e) && WebColorChooserField.this.isEnabled() && this.window == null) {
                            this.shouldUpdateColor = true;
                            this.createPreviewWindow();
                            this.updateWindowLocation();
                            this.window.pack();
                            this.window.setVisible(true);
                            this.screen.requestFocusInWindow();
                            this.updateScreenView();
                        }
                    }

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        if (WebColorChooserField.this.displayEyedropper && SwingUtils.isLeftMouseButton(e) && this.window != null) {
                            this.updateWindowLocation();
                            this.updateScreenView();
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        if (WebColorChooserField.this.displayEyedropper && SwingUtils.isLeftMouseButton(e) && this.window != null) {
                            this.window.dispose();
                        }
                    }

                    private void updateScreenView() {
                        if (!this.updating) {
                            this.updating = true;
                            Thread updater = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    if (screen != null) {
                                        Point p = CoreSwingUtils.getMouseLocation();
                                        screenshot = WebColorChooserField.this.robot.createScreenCapture(new Rectangle(p.x - 4, p.y - 4, 9, 9));
                                        color = new Color(screenshot.getRGB(4, 4));
                                        if (screen != null) {
                                            screen.repaint();
                                            CoreSwingUtils.invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    info.setText(WebColorChooserField.this.getColorText(color));
                                                }
                                            });
                                        } else {
                                            screenshot.flush();
                                            screenshot = null;
                                            color = null;
                                        }
                                    }
                                    updating = false;
                                }
                            });
                            updater.setDaemon(true);
                            updater.start();
                        }
                    }

                    private void createPreviewWindow() {
                        this.window = new WebWindow(WebColorChooserField.this.eyedropperPicker);
                        this.window.setLayout(new BorderLayout());
                        this.window.setAlwaysOnTop(true);
                        this.window.setFocusableWindowState(false);
                        this.window.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent e) {
                                window.removeWindowListener(this);
                                if (screenshot != null) {
                                    if (shouldUpdateColor) {
                                        WebColorChooserField.this.setColorImpl(color);
                                    }
                                    screenshot.flush();
                                    screenshot = null;
                                }
                                HotkeyManager.unregisterHotkeys(screen);
                                window = null;
                                screen = null;
                            }
                        });
                        this.screen = new JComponent(){

                            @Override
                            protected void paintComponent(Graphics g) {
                                if (window.isShowing() && WebColorChooserField.this.robot != null) {
                                    Graphics2D g2d = (Graphics2D)g;
                                    Rectangle bounds = BoundsType.margin.bounds(this);
                                    g2d.drawImage(screenshot, bounds.x + 2, bounds.y + 2, bounds.width - 4, bounds.height - 4, null);
                                    g2d.setPaint(Color.BLACK);
                                    g2d.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
                                    g2d.setPaint(Color.WHITE);
                                    g2d.drawRect(bounds.x + 1, bounds.y + 1, bounds.width - 3, bounds.height - 3);
                                    int mx = bounds.x + bounds.width / 2;
                                    int my = bounds.y + bounds.height / 2;
                                    g2d.setPaint(Color.WHITE);
                                    g2d.drawLine(mx - 1, my - 7, mx - 1, my + 7);
                                    g2d.drawLine(mx + 1, my - 7, mx + 1, my + 7);
                                    g2d.drawLine(mx - 7, my - 1, mx + 7, my - 1);
                                    g2d.drawLine(mx - 7, my + 1, mx + 7, my + 1);
                                    g2d.setPaint(Color.BLACK);
                                    g2d.drawLine(mx, my - 7, mx, my + 7);
                                    g2d.drawLine(mx - 7, my, mx + 7, my);
                                }
                            }
                        };
                        this.screen.setFocusable(true);
                        this.screen.setPreferredSize(new Dimension(103, 103));
                        this.window.add((Component)this.screen, "Center");
                        this.info = new WebLabel(10);
                        this.info.setIcon(new Icon(){

                            @Override
                            public void paintIcon(Component c, Graphics g, int x, int y) {
                                if (color != null) {
                                    Graphics2D g2d = (Graphics2D)g;
                                    g2d.setPaint(Color.BLACK);
                                    g2d.drawRect(x, y, 15, 15);
                                    g2d.setPaint(Color.WHITE);
                                    g2d.drawRect(x + 1, y + 1, 13, 13);
                                    g2d.setPaint(color);
                                    g2d.fillRect(x + 2, y + 2, 12, 12);
                                }
                            }

                            @Override
                            public int getIconWidth() {
                                return 16;
                            }

                            @Override
                            public int getIconHeight() {
                                return 16;
                            }
                        });
                        this.window.add((Component)this.info, "South");
                        HotkeyManager.registerHotkey(this.screen, Hotkey.ESCAPE, new HotkeyRunnable(){

                            @Override
                            public void run(@NotNull KeyEvent e) {
                                if (window != null) {
                                    shouldUpdateColor = false;
                                    window.dispose();
                                }
                            }
                        });
                    }

                    private void updateWindowLocation() {
                        Point p = CoreSwingUtils.getMouseLocation();
                        Rectangle b = SystemUtils.getDeviceBounds(p, true);
                        int ww = this.window.getWidth();
                        int wh = this.window.getHeight();
                        int x = p.x + 20 + ww < b.x + b.width ? p.x + 20 : p.x - 20 - ww;
                        int y = p.y + 20 + wh < b.y + b.height ? p.y + 20 : p.y - 20 - wh;
                        this.window.setLocation(x, y);
                    }
                };
                this.eyedropperPicker.addMouseListener(mouseAdapter);
                this.eyedropperPicker.addMouseMotionListener(mouseAdapter);
                this.eyedropperPicker.setCursor(Cursor.getDefaultCursor());
            }
        }
        this.setLeadingComponent(this.eyedropperPicker);
    }

    protected void uninstallEyedropper() {
        this.setLeadingComponent(null);
    }

    protected void showColorChooserPopup() {
        if (!this.requestFocusInWindow() && !this.isFocusOwner()) {
            return;
        }
        this.updateColorFromField();
        if (this.popup == null || this.colorChooserPanel == null) {
            Window ancestor = CoreSwingUtils.getNonNullWindowAncestor(this);
            this.popup = new WebPopOver(ancestor);
            this.popup.setPadding(5);
            this.popup.setCloseOnFocusLoss(true);
            this.colorChooserPanel = new WebColorChooserPanel(true);
            this.colorChooserPanel.setColor(this.color);
            this.popup.add(this.colorChooserPanel);
            this.updatePopupLocation();
            ancestor.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    if (WebColorChooserField.this.popup.isShowing()) {
                        WebColorChooserField.this.updatePopupLocation();
                    }
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    if (WebColorChooserField.this.popup.isShowing()) {
                        WebColorChooserField.this.updatePopupLocation();
                    }
                }
            });
            ancestor.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (WebColorChooserField.this.popup.isShowing()) {
                        WebColorChooserField.this.updatePopupLocation();
                    }
                }
            });
            this.colorChooserPanel.addColorChooserListener(new com.alee.laf.colorchooser.ColorChooserListener(){

                @Override
                public void okPressed(ActionEvent e) {
                    WebColorChooserField.this.setColorImpl(WebColorChooserField.this.colorChooserPanel.getColor());
                    WebColorChooserField.this.popup.setVisible(false);
                }

                @Override
                public void resetPressed(ActionEvent e) {
                }

                @Override
                public void cancelPressed(ActionEvent e) {
                    WebColorChooserField.this.popup.setVisible(false);
                }
            });
        } else {
            this.updatePopupLocation();
            this.colorChooserPanel.setColor(this.color);
        }
        SwingUtils.copyOrientation(this, this.popup);
        this.popup.show((Component)this, PopOverDirection.down, PopOverAlignment.centered);
        this.colorChooserPanel.requestFocusInWindow();
    }

    protected void updatePopupLocation() {
        Point los = CoreSwingUtils.locationOnScreen(this);
        Rectangle gb = SystemUtils.getDeviceBounds(this.popup.getGraphicsConfiguration(), true);
        boolean shadeWidth = false;
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        int w = this.getWidth();
        int h = this.getHeight();
        int x = ltr ? (los.x + 0 + this.popup.getWidth() <= gb.x + gb.width ? los.x + 0 : los.x + w - 0 - this.popup.getWidth()) : (los.x + w - 0 - this.popup.getWidth() >= gb.x ? los.x + w - 0 - this.popup.getWidth() : los.x + 0);
        int y = los.y + h + this.popup.getHeight() <= gb.y + gb.height ? los.y + h : los.y - this.popup.getHeight();
        this.popup.setLocation(x, y);
    }

    public void addColorChooserListener(@NotNull ColorChooserListener listener) {
        this.listenerList.add(ColorChooserListener.class, listener);
    }

    public void removeColorChooserListener(@NotNull ColorChooserListener listener) {
        this.listenerList.remove(ColorChooserListener.class, listener);
    }

    public void fireColorChanged(@Nullable Color oldColor, @Nullable Color newColor) {
        for (ColorChooserListener listener : (ColorChooserListener[])this.listenerList.getListeners(ColorChooserListener.class)) {
            listener.selected(oldColor, newColor);
        }
    }
}

