/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.collapsible;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.collapsible.CollapsiblePaneAdapter;
import com.alee.extended.collapsible.CollapsiblePaneState;
import com.alee.extended.collapsible.WebCollapsiblePane;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;

public class CollapsiblePaneSettingsProcessor
extends SettingsProcessor<WebCollapsiblePane, CollapsiblePaneState, Configuration<CollapsiblePaneState>> {
    protected transient CollapsiblePaneAdapter collapsiblePaneListener;

    public CollapsiblePaneSettingsProcessor(WebCollapsiblePane collapsiblePane, Configuration configuration) {
        super(collapsiblePane, configuration);
    }

    @Override
    protected void register(@NotNull WebCollapsiblePane collapsiblePane) {
        this.collapsiblePaneListener = new CollapsiblePaneAdapter(){

            @Override
            public void expanding(@NotNull WebCollapsiblePane pane) {
                CollapsiblePaneSettingsProcessor.this.save();
            }

            @Override
            public void collapsing(@NotNull WebCollapsiblePane pane) {
                CollapsiblePaneSettingsProcessor.this.save();
            }
        };
        collapsiblePane.addCollapsiblePaneListener(this.collapsiblePaneListener);
    }

    @Override
    protected void unregister(@NotNull WebCollapsiblePane collapsiblePane) {
        collapsiblePane.removeCollapsiblePaneListener(this.collapsiblePaneListener);
        this.collapsiblePaneListener = null;
    }

    @Override
    @Nullable
    protected CollapsiblePaneState createDefaultValue() {
        return new CollapsiblePaneState((WebCollapsiblePane)this.component());
    }

    @Override
    protected void loadSettings(@NotNull WebCollapsiblePane collapsiblePane) {
        ((CollapsiblePaneState)this.loadSettings()).apply(collapsiblePane);
    }

    @Override
    protected void saveSettings(@NotNull WebCollapsiblePane collapsiblePane) {
        this.saveSettings(new CollapsiblePaneState(collapsiblePane));
    }
}

