/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.collapsible;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.behavior.OmitOnClone;
import com.alee.api.data.BoxOrientation;
import com.alee.api.jdk.Objects;
import com.alee.api.merge.Mergeable;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.extended.collapsible.AbstractHeaderPanel;
import com.alee.extended.collapsible.WebCollapsiblePane;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.managers.animation.easing.Easing;
import com.alee.managers.animation.transition.QueueTransition;
import com.alee.managers.animation.transition.TimedTransition;
import com.alee.managers.animation.transition.Transition;
import com.alee.managers.animation.transition.TransitionAdapter;
import com.alee.managers.style.StyleId;
import com.alee.utils.SwingUtils;
import com.alee.utils.parsing.DurationUnits;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.SwingUtilities;

@XStreamAlias(value="CollapsiblePaneLayout")
public class CollapsiblePaneLayout
extends AbstractLayoutManager
implements PropertyChangeListener,
Mergeable,
Cloneable,
Serializable {
    @Nullable
    protected Boolean fitHeader;
    @Nullable
    protected Easing easing;
    @Nullable
    protected String duration;
    @OmitOnClone
    @OmitOnMerge
    protected transient QueueTransition transitionsQueue;
    @OmitOnClone
    @OmitOnMerge
    protected transient float contentSize;

    public CollapsiblePaneLayout() {
        this(null, null, null);
    }

    public CollapsiblePaneLayout(@Nullable Boolean fitHeader) {
        this(fitHeader, null, null);
    }

    public CollapsiblePaneLayout(@Nullable Boolean fitHeader, @Nullable Easing easing, @Nullable Long duration) {
        this.setFitHeader(fitHeader);
        this.setEasing(easing);
        this.setDuration(duration);
    }

    public boolean isFitHeader() {
        return this.fitHeader == null || this.fitHeader != false;
    }

    public void setFitHeader(@Nullable Boolean fitHeader) {
        this.fitHeader = fitHeader;
    }

    @Nullable
    public Easing getEasing() {
        return this.easing;
    }

    public void setEasing(@Nullable Easing easing) {
        this.easing = easing;
    }

    public long getDuration() {
        return this.duration != null ? DurationUnits.get().fromString(this.duration) : 0L;
    }

    public void setDuration(@Nullable Long duration) {
        this.duration = duration != null ? DurationUnits.get().toString(duration) : null;
    }

    public void install(@NotNull WebCollapsiblePane pane) {
        this.contentSize = pane.isExpanded() ? 1.0f : 0.0f;
        pane.addPropertyChangeListener(this);
    }

    public void uninstall(@NotNull WebCollapsiblePane pane) {
        pane.removePropertyChangeListener(this);
        if (this.transitionsQueue != null) {
            this.transitionsQueue.stop();
            this.transitionsQueue = null;
        }
        this.contentSize = 0.0f;
    }

    @Override
    public void addComponent(@NotNull Component component2, @Nullable Object constraints) {
        WebCollapsiblePane collapsiblePane = (WebCollapsiblePane)component2.getParent();
        if (component2 == collapsiblePane.getHeaderComponent() && collapsiblePane.getHeaderComponent() instanceof AbstractHeaderPanel.UIResource) {
            StyleId.collapsiblepaneHeaderPanel.at(collapsiblePane).set((AbstractHeaderPanel.UIResource)collapsiblePane.getHeaderComponent());
        }
    }

    @Override
    public void removeComponent(@NotNull Component component2) {
        WebCollapsiblePane collapsiblePane = (WebCollapsiblePane)component2.getParent();
        if (component2 == collapsiblePane.getHeaderComponent() && collapsiblePane.getHeaderComponent() instanceof AbstractHeaderPanel.UIResource) {
            ((AbstractHeaderPanel.UIResource)collapsiblePane.getHeaderComponent()).resetStyleId();
        }
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        final WebCollapsiblePane pane = (WebCollapsiblePane)event.getSource();
        String property = event.getPropertyName();
        if (Objects.equals((Object)property, (Object)"expanded")) {
            boolean expanded = (Boolean)event.getNewValue();
            Easing easing = this.getEasing();
            long fullDuration = this.getDuration();
            if (pane.isAnimated() && pane.isShowing() && easing != null && fullDuration > 0L) {
                float target;
                float f = target = expanded ? 1.0f : 0.0f;
                if (this.transitionsQueue == null) {
                    this.contentSize = expanded ? 0.0f : 1.0f;
                    this.transitionsQueue = new QueueTransition(false, new Transition[0]);
                    this.transitionsQueue.add(new TimedTransition<Float>(Float.valueOf(this.contentSize), Float.valueOf(target), easing, fullDuration));
                    this.transitionsQueue.addListener(new TransitionAdapter<Float>(){

                        @Override
                        public void adjusted(Transition transition, Float value) {
                            CollapsiblePaneLayout.this.contentSize = value.floatValue();
                            SwingUtils.update(pane);
                        }

                        @Override
                        public void finished(Transition transition, Float value) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    CollapsiblePaneLayout.this.transitionsQueue = null;
                                    if (pane.isExpanded()) {
                                        pane.fireExpanded();
                                    } else {
                                        pane.fireCollapsed();
                                    }
                                }
                            });
                        }
                    });
                    this.transitionsQueue.play();
                } else {
                    this.transitionsQueue.stop();
                    this.transitionsQueue.clear();
                    float targetDistance = expanded ? 1.0f - this.contentSize : this.contentSize;
                    long partialDuration = Math.round((float)fullDuration * targetDistance);
                    this.transitionsQueue.add(new TimedTransition<Float>(Float.valueOf(this.contentSize), Float.valueOf(target), easing, partialDuration));
                    this.transitionsQueue.play();
                }
                if (expanded) {
                    pane.fireExpanding();
                } else {
                    pane.fireCollapsing();
                }
            } else {
                float f = this.contentSize = expanded ? 1.0f : 0.0f;
                if (expanded) {
                    pane.fireExpanding();
                    pane.fireExpanded();
                } else {
                    pane.fireCollapsing();
                    pane.fireCollapsed();
                }
                SwingUtils.update(pane);
            }
        } else if (Objects.equals((Object)property, "titleComponent", "title", "headerPosition", "content")) {
            SwingUtils.update(pane);
        }
    }

    public boolean isInTransition() {
        return this.transitionsQueue != null;
    }

    @Override
    public void layoutContainer(@NotNull Container parent) {
        WebCollapsiblePane pane = (WebCollapsiblePane)parent;
        Component header = pane.getHeaderComponent();
        Component content = pane.getContent();
        Insets insets = pane.getInsets();
        int availableWidth = pane.getWidth() - insets.left - insets.right;
        int availableHeight = pane.getHeight() - insets.top - insets.bottom;
        Rectangle bounds = new Rectangle(insets.left, insets.top, availableWidth, availableHeight);
        boolean ltr = pane.getComponentOrientation().isLeftToRight();
        BoxOrientation position = pane.getHeaderPosition();
        Dimension hps = header.getPreferredSize();
        int x = position.isTop() || position.isBottom() || (ltr ? position.isLeft() : position.isRight()) ? bounds.x : bounds.x + bounds.width - Math.min(availableWidth, hps.width);
        int y = position.isTop() || position.isLeft() || position.isRight() ? bounds.y : bounds.y + bounds.height - Math.min(availableHeight, hps.height);
        int w = position.isTop() || position.isBottom() ? availableWidth : Math.min(availableWidth, hps.width);
        int h = position.isLeft() || position.isRight() ? availableHeight : Math.min(availableHeight, hps.height);
        header.setBounds(x, y, w, h);
        if (content != null) {
            if (position.isTop()) {
                bounds.y += h;
                bounds.height -= h;
            } else if (position.isBottom()) {
                bounds.height -= h;
            } else if (ltr && position.isLeft() || !ltr && position.isRight()) {
                bounds.x += w;
                bounds.width -= w;
            } else {
                bounds.width -= w;
            }
            content.setBounds(bounds);
            content.setVisible(this.transitionsQueue != null || pane.isExpanded());
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        WebCollapsiblePane pane = (WebCollapsiblePane)parent;
        Component header = pane.getHeaderComponent();
        Component content = pane.getContent();
        Insets insets = pane.getInsets();
        Dimension ps = new Dimension(0, 0);
        BoxOrientation position = pane.getHeaderPosition();
        if (content != null) {
            Dimension cps = content.getPreferredSize();
            ps.width = position.isLeft() || position.isRight() ? Math.round((float)cps.width * this.contentSize) : cps.width;
            ps.height = position.isTop() || position.isBottom() ? Math.round((float)cps.height * this.contentSize) : cps.height;
        }
        Dimension hps = header.getPreferredSize();
        if (position.isTop() || position.isBottom()) {
            if (this.isFitHeader()) {
                ps.width = Math.max(ps.width, hps.width);
            }
            ps.height += hps.height;
        } else {
            if (this.isFitHeader()) {
                ps.height = Math.max(ps.height, hps.height);
            }
            ps.width += hps.width;
        }
        ps.width += insets.left + insets.right;
        ps.height += insets.top + insets.bottom;
        return ps;
    }

    @XStreamAlias(value="CollapsiblePaneLayout$UIResource")
    public static final class UIResource
    extends CollapsiblePaneLayout
    implements javax.swing.plaf.UIResource {
    }
}

