/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.collapsible;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.BoxOrientation;
import com.alee.extended.label.WebStyledLabel;
import com.alee.managers.language.LM;
import com.alee.managers.style.StyleId;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.Stateful;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public abstract class AbstractTitleLabel
extends WebStyledLabel
implements Stateful {
    public AbstractTitleLabel() {
        this(StyleId.auto);
    }

    public AbstractTitleLabel(@NotNull StyleId id) {
        super(id);
    }

    @Override
    public void setIcon(@Nullable Icon icon) {
        super.setIcon(icon);
        DecorationUtils.fireStatesChanged(this);
    }

    @Override
    public void setText(@Nullable String text) {
        if (text != null && LM.contains(text)) {
            this.setLanguage(text, new Object[0]);
        } else {
            super.setText(text);
        }
    }

    @NotNull
    public abstract BoxOrientation getHeaderPosition();

    public abstract boolean isExpanded();

    public abstract boolean isInTransition();

    @Override
    @Nullable
    public List<String> getStates() {
        ArrayList<String> states = new ArrayList<String>(3);
        states.add(this.getHeaderPosition().name());
        states.add(this.isExpanded() || this.isInTransition() ? "expanded" : "collapsed");
        if (this.isInTransition()) {
            states.add(this.isExpanded() ? "expanding" : "collapsing");
        }
        if (this.getIcon() != null) {
            states.add("has-icon");
        }
        return states;
    }

    public static abstract class UIResource
    extends AbstractTitleLabel
    implements javax.swing.plaf.UIResource {
    }
}

