/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.button;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.button.SplitButtonListener;
import com.alee.extended.button.WSplitButtonUI;
import com.alee.laf.menu.PopupMenuWay;
import com.alee.laf.menu.WebPopupMenuUI;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.language.DictionaryListener;
import com.alee.managers.language.LanguageEventMethods;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.LanguageUpdater;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.UISettingsManager;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.managers.tooltip.ToolTipMethods;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.extensions.EventMethods;
import com.alee.utils.swing.extensions.EventMethodsImpl;
import com.alee.utils.swing.extensions.FocusEventRunnable;
import com.alee.utils.swing.extensions.FontMethods;
import com.alee.utils.swing.extensions.FontMethodsImpl;
import com.alee.utils.swing.extensions.KeyEventRunnable;
import com.alee.utils.swing.extensions.MouseEventRunnable;
import com.alee.utils.swing.extensions.SizeMethods;
import com.alee.utils.swing.extensions.SizeMethodsImpl;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class WebSplitButton
extends JButton
implements ActionListener,
Styleable,
EventMethods,
ToolTipMethods,
LanguageMethods,
LanguageEventMethods,
SettingsMethods,
FontMethods<WebSplitButton>,
SizeMethods<WebSplitButton> {
    public static final String POPUP_MENU_PROPERTY = "popupMenu";
    public static final String MENU_ICON_PROPERTY = "menuIcon";
    protected boolean alwaysShowMenu = false;
    protected PopupMenuWay popupMenuWay = PopupMenuWay.belowStart;
    protected JPopupMenu popupMenu;
    protected Icon menuIcon;

    public WebSplitButton() {
    }

    public WebSplitButton(Icon icon) {
        this(StyleId.auto, icon);
    }

    public WebSplitButton(Icon icon, Icon rolloverIcon) {
        this(StyleId.auto, icon, rolloverIcon);
    }

    public WebSplitButton(String text) {
        this(StyleId.auto, text);
    }

    public WebSplitButton(String text, Icon icon) {
        this(StyleId.auto, text, icon);
    }

    public WebSplitButton(ActionListener listener) {
        this(StyleId.auto, listener);
    }

    public WebSplitButton(Icon icon, ActionListener listener) {
        this(StyleId.auto, icon, listener);
    }

    public WebSplitButton(String text, ActionListener listener) {
        this(StyleId.auto, text, listener);
    }

    public WebSplitButton(String text, Icon icon, ActionListener listener) {
        this(StyleId.auto, text, icon, listener);
    }

    public WebSplitButton(Action action) {
        this(StyleId.auto, action);
    }

    public WebSplitButton(StyleId id) {
        this(id, null, null, null);
    }

    public WebSplitButton(StyleId id, Icon icon) {
        this(id, null, icon, null);
    }

    public WebSplitButton(StyleId id, String text) {
        this(id, text, null, null);
    }

    public WebSplitButton(StyleId id, String text, Icon icon) {
        this(id, text, icon, null);
    }

    public WebSplitButton(StyleId id, ActionListener listener) {
        this(id, null, null, listener);
    }

    public WebSplitButton(StyleId id, Icon icon, ActionListener listener) {
        this(id, null, icon, listener);
    }

    public WebSplitButton(StyleId id, String text, ActionListener listener) {
        this(id, text, null, listener);
    }

    public WebSplitButton(StyleId id, Icon icon, Icon rolloverIcon) {
        this(id, null, icon, null);
        this.setRolloverIcon(rolloverIcon);
    }

    public WebSplitButton(StyleId id, Action action) {
        this(id, null, null, null);
        this.setAction(action);
    }

    public WebSplitButton(StyleId id, String text, Icon icon, ActionListener listener) {
        super(text, icon);
        if (listener != null) {
            this.addActionListener(listener);
        }
        this.setStyleId(id);
    }

    @Override
    protected void init(String text, Icon icon) {
        super.init(UILanguageManager.getInitialText(text, new Object[0]), icon);
        UILanguageManager.registerInitialLanguage(this, text, new Object[0]);
        this.addActionListener(this);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return this.getIcon() != null && this.getText() == null ? StyleId.splitbuttonIcon : StyleId.splitbutton;
    }

    @Override
    @NotNull
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this);
    }

    @Override
    @NotNull
    public StyleId setStyleId(@NotNull StyleId id) {
        return StyleManager.setStyleId(this, id);
    }

    @Override
    @NotNull
    public StyleId resetStyleId() {
        return StyleManager.resetStyleId(this);
    }

    @Override
    @NotNull
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    @Nullable
    public Skin resetSkin() {
        return StyleManager.resetSkin(this);
    }

    @Override
    public void addStyleListener(@NotNull StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(@NotNull StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    @Nullable
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    @Nullable
    public Painter setCustomPainter(@NotNull Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public boolean resetCustomPainter() {
        return StyleManager.resetCustomPainter(this);
    }

    @Override
    @NotNull
    public Shape getPainterShape() {
        return PainterSupport.getShape(this);
    }

    @Override
    public boolean isShapeDetectionEnabled() {
        return PainterSupport.isShapeDetectionEnabled(this);
    }

    @Override
    public void setShapeDetectionEnabled(boolean enabled) {
        PainterSupport.setShapeDetectionEnabled(this, enabled);
    }

    @Override
    @Nullable
    public Insets getMargin() {
        return PainterSupport.getMargin(this);
    }

    @Override
    public void setMargin(int margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    public void setMargin(int top, int left, int bottom, int right) {
        PainterSupport.setMargin(this, top, left, bottom, right);
    }

    @Override
    public void setMargin(@Nullable Insets margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    @Nullable
    public Insets getPadding() {
        return PainterSupport.getPadding(this);
    }

    @Override
    public void setPadding(int padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    @Override
    public void setPadding(int top, int left, int bottom, int right) {
        PainterSupport.setPadding(this, top, left, bottom, right);
    }

    @Override
    public void setPadding(@Nullable Insets padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        JPopupMenu old = this.popupMenu;
        this.popupMenu = popupMenu;
        SwingUtils.firePropertyChanged(this, POPUP_MENU_PROPERTY, old, popupMenu);
    }

    public boolean isAlwaysShowMenu() {
        return this.alwaysShowMenu;
    }

    public void setAlwaysShowMenu(boolean alwaysShowMenu) {
        this.alwaysShowMenu = alwaysShowMenu;
    }

    public PopupMenuWay getPopupMenuWay() {
        return this.popupMenuWay;
    }

    public void setPopupMenuWay(PopupMenuWay way) {
        this.popupMenuWay = way;
    }

    public Icon getMenuIcon() {
        return this.menuIcon;
    }

    public void setMenuIcon(Icon menuIcon) {
        Icon oldIcon = this.menuIcon;
        this.menuIcon = menuIcon;
        this.firePropertyChange(MENU_ICON_PROPERTY, oldIcon, menuIcon);
    }

    public void addSplitButtonListener(SplitButtonListener listener) {
        this.listenerList.add(SplitButtonListener.class, listener);
    }

    public void removeSplitButtonListener(SplitButtonListener listener) {
        if (listener != null && this.getAction() == listener) {
            this.setAction(null);
        } else {
            this.listenerList.remove(SplitButtonListener.class, listener);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getUI().isOnSplit()) {
            this.showPopupMenu();
            this.fireSplitbuttonClicked(e);
        } else {
            if (this.isAlwaysShowMenu()) {
                this.showPopupMenu();
            }
            this.fireButtonClicked(e);
        }
    }

    public boolean isPopupMenuVisible() {
        return this.popupMenu != null && this.popupMenu.isShowing();
    }

    public void showPopupMenu() {
        if (this.popupMenu != null) {
            if (this.popupMenu.getUI() instanceof WebPopupMenuUI) {
                ((WebPopupMenuUI)this.popupMenu.getUI()).setPopupMenuWay(this.popupMenuWay);
            }
            if (this.getComponentOrientation().isLeftToRight()) {
                this.popupMenu.show(this, 0, this.getHeight());
            } else {
                this.popupMenu.show(this, this.getWidth() - this.popupMenu.getPreferredSize().width, this.getHeight());
            }
        }
    }

    protected void fireButtonClicked(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SplitButtonListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                if (actionCommand == null) {
                    actionCommand = this.getActionCommand();
                }
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((SplitButtonListener)listeners[i + 1]).buttonClicked(e);
        }
    }

    protected void fireSplitbuttonClicked(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SplitButtonListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                if (actionCommand == null) {
                    actionCommand = this.getActionCommand();
                }
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((SplitButtonListener)listeners[i + 1]).splitButtonClicked(e);
        }
    }

    @Override
    @NotNull
    public MouseAdapter onMousePress(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMousePress(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMousePress(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMousePress(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseEnter(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseEnter(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseExit(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseExit(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseDrag(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseDrag(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseDrag(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseDrag(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseClick(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseClick(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseClick(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseClick(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDoubleClick(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDoubleClick(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMenuTrigger(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMenuTrigger(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyType(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyType(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyType(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyType(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyPress(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyPress(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyPress(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyPress(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyRelease(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyRelease(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyRelease(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyRelease(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public FocusAdapter onFocusGain(@NotNull FocusEventRunnable runnable) {
        return EventMethodsImpl.onFocusGain(this, runnable);
    }

    @Override
    @NotNull
    public FocusAdapter onFocusLoss(@NotNull FocusEventRunnable runnable) {
        return EventMethodsImpl.onFocusLoss(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDragStart(int shift, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDragStart(this, shift, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDragStart(int shift, @Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDragStart(this, shift, mouseButton, runnable);
    }

    @Override
    public WebCustomTooltip setToolTip(String tooltip) {
        return TooltipManager.setTooltip((JComponent)this, tooltip);
    }

    @Override
    public WebCustomTooltip setToolTip(Icon icon, String tooltip) {
        return TooltipManager.setTooltip((JComponent)this, icon, tooltip);
    }

    @Override
    public WebCustomTooltip setToolTip(String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip((JComponent)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip setToolTip(Icon icon, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip((JComponent)this, icon, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip setToolTip(String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip((JComponent)this, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip setToolTip(Icon icon, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip(this, icon, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip) {
        return TooltipManager.setTooltip((JComponent)this, tooltip);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip, int delay) {
        return TooltipManager.setTooltip((JComponent)this, tooltip, delay);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip((JComponent)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip((JComponent)this, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(String tooltip) {
        return TooltipManager.addTooltip((JComponent)this, tooltip);
    }

    @Override
    public WebCustomTooltip addToolTip(Icon icon, String tooltip) {
        return TooltipManager.addTooltip((JComponent)this, icon, tooltip);
    }

    @Override
    public WebCustomTooltip addToolTip(String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip((JComponent)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip addToolTip(Icon icon, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip((JComponent)this, icon, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip addToolTip(String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip((JComponent)this, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(Icon icon, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip((JComponent)this, icon, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip) {
        return TooltipManager.addTooltip((JComponent)this, tooltip);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip, int delay) {
        return TooltipManager.addTooltip((JComponent)this, tooltip, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip((JComponent)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip((JComponent)this, tooltip, tooltipWay, delay);
    }

    @Override
    public void removeToolTip(WebCustomTooltip tooltip) {
        TooltipManager.removeTooltip(this, tooltip);
    }

    @Override
    public void removeToolTips() {
        TooltipManager.removeTooltips(this);
    }

    @Override
    public void removeToolTips(WebCustomTooltip ... tooltips) {
        TooltipManager.removeTooltips((JComponent)this, tooltips);
    }

    @Override
    public void removeToolTips(List<WebCustomTooltip> tooltips) {
        TooltipManager.removeTooltips((JComponent)this, tooltips);
    }

    @Override
    @Nullable
    public String getLanguage() {
        return UILanguageManager.getComponentKey(this);
    }

    @Override
    public void setLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.registerComponent(this, key, data);
    }

    @Override
    public void updateLanguage(Object ... data) {
        UILanguageManager.updateComponent((JComponent)this, data);
    }

    @Override
    public void updateLanguage(@NotNull String key, Object ... data) {
        UILanguageManager.updateComponent((JComponent)this, key, data);
    }

    @Override
    public void removeLanguage() {
        UILanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return UILanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(@NotNull LanguageUpdater updater) {
        UILanguageManager.registerLanguageUpdater(this, updater);
    }

    @Override
    public void removeLanguageUpdater() {
        UILanguageManager.unregisterLanguageUpdater(this);
    }

    @Override
    public void addLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.addLanguageListener(this.getRootPane(), listener);
    }

    @Override
    public void removeLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.removeLanguageListener(this.getRootPane(), listener);
    }

    @Override
    public void removeLanguageListeners() {
        UILanguageManager.removeLanguageListeners(this.getRootPane());
    }

    @Override
    public void addDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.addDictionaryListener(this.getRootPane(), listener);
    }

    @Override
    public void removeDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.removeDictionaryListener(this.getRootPane(), listener);
    }

    @Override
    public void removeDictionaryListeners() {
        UILanguageManager.removeDictionaryListeners(this.getRootPane());
    }

    @Override
    public void registerSettings(Configuration configuration) {
        UISettingsManager.registerComponent((JComponent)this, configuration);
    }

    @Override
    public void registerSettings(SettingsProcessor processor) {
        UISettingsManager.registerComponent((JComponent)this, processor);
    }

    @Override
    public void unregisterSettings() {
        UISettingsManager.unregisterComponent(this);
    }

    @Override
    public void loadSettings() {
        UISettingsManager.loadSettings(this);
    }

    @Override
    public void saveSettings() {
        UISettingsManager.saveSettings(this);
    }

    @Override
    public WebSplitButton setPlainFont() {
        return (WebSplitButton)FontMethodsImpl.setPlainFont(this);
    }

    @Override
    public WebSplitButton setPlainFont(boolean apply2) {
        return (WebSplitButton)FontMethodsImpl.setPlainFont(this, apply2);
    }

    @Override
    public boolean isPlainFont() {
        return FontMethodsImpl.isPlainFont(this);
    }

    @Override
    public WebSplitButton setBoldFont() {
        return (WebSplitButton)FontMethodsImpl.setBoldFont(this);
    }

    @Override
    public WebSplitButton setBoldFont(boolean apply2) {
        return (WebSplitButton)FontMethodsImpl.setBoldFont(this, apply2);
    }

    @Override
    public boolean isBoldFont() {
        return FontMethodsImpl.isBoldFont(this);
    }

    @Override
    public WebSplitButton setItalicFont() {
        return (WebSplitButton)FontMethodsImpl.setItalicFont(this);
    }

    @Override
    public WebSplitButton setItalicFont(boolean apply2) {
        return (WebSplitButton)FontMethodsImpl.setItalicFont(this, apply2);
    }

    @Override
    public boolean isItalicFont() {
        return FontMethodsImpl.isItalicFont(this);
    }

    @Override
    public WebSplitButton setFontStyle(boolean bold, boolean italic) {
        return (WebSplitButton)FontMethodsImpl.setFontStyle(this, bold, italic);
    }

    @Override
    public WebSplitButton setFontStyle(int style) {
        return (WebSplitButton)FontMethodsImpl.setFontStyle(this, style);
    }

    @Override
    public WebSplitButton setFontSize(int fontSize) {
        return (WebSplitButton)FontMethodsImpl.setFontSize(this, fontSize);
    }

    @Override
    public WebSplitButton changeFontSize(int change) {
        return (WebSplitButton)FontMethodsImpl.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return FontMethodsImpl.getFontSize(this);
    }

    @Override
    public WebSplitButton setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return (WebSplitButton)FontMethodsImpl.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebSplitButton setFontSizeAndStyle(int fontSize, int style) {
        return (WebSplitButton)FontMethodsImpl.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebSplitButton setFontName(String fontName) {
        return (WebSplitButton)FontMethodsImpl.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return FontMethodsImpl.getFontName(this);
    }

    @Override
    public int getPreferredWidth() {
        return SizeMethodsImpl.getPreferredWidth(this);
    }

    @Override
    @NotNull
    public WebSplitButton setPreferredWidth(int preferredWidth) {
        return (WebSplitButton)SizeMethodsImpl.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeMethodsImpl.getPreferredHeight(this);
    }

    @Override
    @NotNull
    public WebSplitButton setPreferredHeight(int preferredHeight) {
        return (WebSplitButton)SizeMethodsImpl.setPreferredHeight(this, preferredHeight);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return SizeMethodsImpl.getPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalPreferredSize() {
        return SizeMethodsImpl.getOriginalPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public WebSplitButton setPreferredSize(int width, int height) {
        return (WebSplitButton)SizeMethodsImpl.setPreferredSize(this, width, height);
    }

    @Override
    public int getMaximumWidth() {
        return SizeMethodsImpl.getMaximumWidth(this);
    }

    @Override
    @NotNull
    public WebSplitButton setMaximumWidth(int maximumWidth) {
        return (WebSplitButton)SizeMethodsImpl.setMaximumWidth(this, maximumWidth);
    }

    @Override
    public int getMaximumHeight() {
        return SizeMethodsImpl.getMaximumHeight(this);
    }

    @Override
    @NotNull
    public WebSplitButton setMaximumHeight(int maximumHeight) {
        return (WebSplitButton)SizeMethodsImpl.setMaximumHeight(this, maximumHeight);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return SizeMethodsImpl.getMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMaximumSize() {
        return SizeMethodsImpl.getOriginalMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public WebSplitButton setMaximumSize(int width, int height) {
        return (WebSplitButton)SizeMethodsImpl.setMaximumSize(this, width, height);
    }

    @Override
    public int getMinimumWidth() {
        return SizeMethodsImpl.getMinimumWidth(this);
    }

    @Override
    @NotNull
    public WebSplitButton setMinimumWidth(int minimumWidth) {
        return (WebSplitButton)SizeMethodsImpl.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeMethodsImpl.getMinimumHeight(this);
    }

    @Override
    @NotNull
    public WebSplitButton setMinimumHeight(int minimumHeight) {
        return (WebSplitButton)SizeMethodsImpl.setMinimumHeight(this, minimumHeight);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return SizeMethodsImpl.getMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMinimumSize() {
        return SizeMethodsImpl.getOriginalMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public WebSplitButton setMinimumSize(int width, int height) {
        return (WebSplitButton)SizeMethodsImpl.setMinimumSize(this, width, height);
    }

    @Override
    public WSplitButtonUI getUI() {
        return (WSplitButtonUI)super.getUI();
    }

    public void setUI(WSplitButtonUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

