/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.breadcrumb;

import com.alee.api.annotations.NotNull;
import com.alee.extended.WebContainer;
import com.alee.extended.breadcrumb.BreadcrumbLayout;
import com.alee.extended.breadcrumb.WBreadcrumbUI;
import com.alee.extended.breadcrumb.element.BreadcrumbElementData;
import com.alee.extended.breadcrumb.element.BreadcrumbElementPainter;
import com.alee.extended.button.WebSplitButton;
import com.alee.extended.checkbox.WebTristateCheckBox;
import com.alee.extended.date.WebDateField;
import com.alee.extended.label.WebStyledLabel;
import com.alee.extended.link.WebLink;
import com.alee.managers.style.ComponentException;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.painter.decoration.DecorationUtils;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class WebBreadcrumb
extends WebContainer<WebBreadcrumb, WBreadcrumbUI> {
    public static final String FORCE_STYLE_PROPERTY = "forceStyle";
    protected boolean forceStyle = true;
    protected transient Map<JComponent, BreadcrumbElementData> data = new HashMap<JComponent, BreadcrumbElementData>(5);

    public WebBreadcrumb() {
        this(StyleId.auto);
    }

    public WebBreadcrumb(StyleId id) {
        this.updateUI();
        this.setStyleId(id);
    }

    @Override
    public BreadcrumbLayout getLayout() {
        return (BreadcrumbLayout)super.getLayout();
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.breadcrumb;
    }

    public boolean isForceStyle() {
        return this.forceStyle;
    }

    public void setForceStyle(boolean forceStyle) {
        boolean previous = this.forceStyle;
        this.forceStyle = forceStyle;
        this.firePropertyChange(FORCE_STYLE_PROPERTY, previous, forceStyle);
    }

    @Override
    protected void addImpl(Component component2, Object constraints, int index) {
        Component next;
        Component previous;
        if (this.isSupported(component2)) {
            this.data.put((JComponent)component2, new BreadcrumbElementData());
            if (component2 instanceof JPanel) {
                StyleManager.setStyleId((JPanel)component2, StyleId.breadcrumbPanel.at(this));
            } else if (component2 instanceof WebLink) {
                StyleManager.setStyleId((WebLink)component2, StyleId.breadcrumbLink.at(this));
            } else if (component2 instanceof WebStyledLabel) {
                StyleManager.setStyleId((WebStyledLabel)component2, StyleId.breadcrumbStyledLabel.at(this));
            } else if (component2 instanceof JLabel) {
                StyleManager.setStyleId((JLabel)component2, StyleId.breadcrumbLabel.at(this));
            } else if (component2 instanceof WebTristateCheckBox) {
                StyleManager.setStyleId((WebTristateCheckBox)component2, StyleId.breadcrumbTristateCheckBox.at(this));
            } else if (component2 instanceof JCheckBox) {
                StyleManager.setStyleId((JCheckBox)component2, StyleId.breadcrumbCheckBox.at(this));
            } else if (component2 instanceof JRadioButton) {
                StyleManager.setStyleId((JRadioButton)component2, StyleId.breadcrumbRadioButton.at(this));
            } else if (component2 instanceof WebSplitButton) {
                StyleManager.setStyleId((WebSplitButton)component2, StyleId.breadcrumbSplitButton.at(this));
            } else if (component2 instanceof JToggleButton) {
                StyleManager.setStyleId((JToggleButton)component2, StyleId.breadcrumbToggleButton.at(this));
            } else if (component2 instanceof JButton) {
                StyleManager.setStyleId((JButton)component2, StyleId.breadcrumbButton.at(this));
            } else if (component2 instanceof JFormattedTextField) {
                StyleManager.setStyleId((JFormattedTextField)component2, StyleId.breadcrumbFormattedTextField.at(this));
            } else if (component2 instanceof JPasswordField) {
                StyleManager.setStyleId((JPasswordField)component2, StyleId.breadcrumbPasswordField.at(this));
            } else if (component2 instanceof JTextField) {
                StyleManager.setStyleId((JTextField)component2, StyleId.breadcrumbTextField.at(this));
            } else if (component2 instanceof JComboBox) {
                StyleManager.setStyleId((JComboBox)component2, StyleId.breadcrumbComboBox.at(this));
            } else if (component2 instanceof WebDateField) {
                StyleManager.setStyleId((WebDateField)component2, StyleId.breadcrumbDateField.at(this));
            } else {
                throw new ComponentException("Unsupported breadcrumb element: " + component2);
            }
        }
        super.addImpl(component2, constraints, index);
        int actualIndex = this.getComponentZOrder(component2);
        DecorationUtils.fireStatesChanged((JComponent)component2);
        if (actualIndex > 0 && PainterSupport.isDecoratable(previous = this.getComponent(actualIndex - 1))) {
            DecorationUtils.fireStatesChanged((JComponent)previous);
        }
        if (actualIndex < this.getComponentCount() - 1 && PainterSupport.isDecoratable(next = this.getComponent(actualIndex + 1))) {
            DecorationUtils.fireStatesChanged((JComponent)next);
        }
    }

    protected boolean isSupported(Component component2) {
        return component2 instanceof JPanel || component2 instanceof JLabel || component2 instanceof WebStyledLabel || component2 instanceof WebLink || component2 instanceof JButton || component2 instanceof JToggleButton || component2 instanceof WebSplitButton || component2 instanceof JComboBox || component2 instanceof WebDateField || component2 instanceof JCheckBox || component2 instanceof WebTristateCheckBox || component2 instanceof JRadioButton || component2 instanceof JTextField || component2 instanceof JFormattedTextField || component2 instanceof JPasswordField;
    }

    @Override
    public void remove(int index) {
        Component next;
        Component previous;
        Component component2 = this.getComponent(index);
        if (this.isApplied(component2)) {
            this.data.remove(component2);
        }
        super.remove(index);
        DecorationUtils.fireStatesChanged((JComponent)component2);
        if (index > 0 && PainterSupport.isDecoratable(previous = this.getComponent(index - 1))) {
            DecorationUtils.fireStatesChanged((JComponent)previous);
        }
        if (index < this.getComponentCount() && PainterSupport.isDecoratable(next = this.getComponent(index))) {
            DecorationUtils.fireStatesChanged((JComponent)next);
        }
    }

    protected boolean isApplied(@NotNull Component component2) {
        return PainterSupport.getPainter(component2) instanceof BreadcrumbElementPainter;
    }

    public boolean isFirst(Component component2) {
        return component2 == this.getFirstComponent();
    }

    public boolean isLast(Component component2) {
        return component2 == this.getLastComponent();
    }

    public BreadcrumbElementData.ProgressType getProgressType(JComponent component2) {
        return this.data(component2).getProgressType();
    }

    public void setProgressType(JComponent component2, BreadcrumbElementData.ProgressType type) {
        this.data(component2).setProgressType(type);
        DecorationUtils.fireStatesChanged(component2);
        this.repaint();
    }

    public double getProgress(JComponent component2) {
        return this.data(component2).getProgress();
    }

    public void setProgress(JComponent component2, double progress) {
        this.data(component2).setProgress(progress);
        DecorationUtils.fireStatesChanged(component2);
        this.repaint();
    }

    protected BreadcrumbElementData data(JComponent component2) {
        BreadcrumbElementData data = this.data.get(component2);
        if (data == null) {
            throw new ComponentException("Specified JComponent is representing breadcrumb element: " + component2);
        }
        return data;
    }

    @Override
    public WBreadcrumbUI getUI() {
        return (WBreadcrumbUI)this.ui;
    }

    public void setUI(WBreadcrumbUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }
}

