/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.behavior.AbstractComponentBehavior;
import com.alee.utils.CollectionUtils;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public abstract class ParentChangeBehavior<C extends JComponent>
extends AbstractComponentBehavior<C>
implements AncestorListener {
    private final boolean initTriggers;
    private final boolean directParentOnly;
    private List<Container> parents;

    public ParentChangeBehavior(@NotNull C component2, boolean initTriggers, boolean directParentOnly) {
        super(component2);
        this.initTriggers = initTriggers;
        this.directParentOnly = directParentOnly;
    }

    @NotNull
    protected List<Container> getParents() {
        ArrayList<Container> parents;
        if (this.directParentOnly) {
            parents = CollectionUtils.asList(((JComponent)this.component).getParent());
        } else {
            Container parent = ((JComponent)this.component).getParent();
            if (parent != null) {
                parents = new ArrayList(5);
                while (parent != null) {
                    parents.add(parent);
                    parent = parent.getParent();
                }
            } else {
                parents = CollectionUtils.asList(new Container[]{null});
            }
        }
        return parents;
    }

    public void install() {
        this.parents = this.getParents();
        ((JComponent)this.component).addAncestorListener(this);
        if (this.initTriggers) {
            this.parentChanged(null, this.parents.get(0));
        }
    }

    public void uninstall() {
        if (this.initTriggers) {
            this.parentChanged(this.parents.get(0), null);
        }
        ((JComponent)this.component).removeAncestorListener(this);
        this.parents = null;
    }

    @Override
    public void ancestorAdded(@NotNull AncestorEvent event) {
        this.ancestorChanged(event);
    }

    @Override
    public void ancestorRemoved(@NotNull AncestorEvent event) {
        this.ancestorChanged(event);
    }

    @Override
    public void ancestorMoved(@NotNull AncestorEvent event) {
        this.ancestorChanged(event);
    }

    protected void ancestorChanged(@NotNull AncestorEvent event) {
        if (this.directParentOnly) {
            List<Container> newParents = this.getParents();
            if (newParents.get(0) != this.parents.get(0)) {
                List<Container> oldParents = this.parents;
                this.parents = newParents;
                this.parentChanged(oldParents.get(0), newParents.get(0));
            }
        } else {
            List<Container> newParents = this.getParents();
            if (!CollectionUtils.equals(newParents, this.parents)) {
                List<Container> oldParents = this.parents;
                this.parents = newParents;
                this.parentChanged(oldParents.get(0), newParents.get(0));
            }
        }
    }

    public abstract void parentChanged(@Nullable Container var1, @Nullable Container var2);
}

