/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.behavior.Behavior;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public abstract class DocumentChangeBehavior<C extends JTextComponent>
implements DocumentListener,
PropertyChangeListener,
Behavior {
    @NotNull
    protected final WeakReference<C> textComponent;

    public DocumentChangeBehavior(@NotNull C textComponent) {
        this.textComponent = new WeakReference<C>(textComponent);
    }

    public DocumentChangeBehavior<C> install() {
        JTextComponent jTextComponent = (JTextComponent)this.textComponent.get();
        if (jTextComponent != null) {
            jTextComponent.getDocument().addDocumentListener(this);
            jTextComponent.addPropertyChangeListener("document", this);
        }
        return this;
    }

    public DocumentChangeBehavior<C> uninstall() {
        JTextComponent jTextComponent = (JTextComponent)this.textComponent.get();
        if (jTextComponent != null) {
            jTextComponent.removePropertyChangeListener("document", this);
            jTextComponent.getDocument().removeDocumentListener(this);
        }
        return this;
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent e) {
        Object newDocument;
        Object oldDocument = e.getOldValue();
        if (oldDocument != null && oldDocument instanceof Document) {
            ((Document)oldDocument).removeDocumentListener(this);
        }
        if ((newDocument = e.getNewValue()) != null && newDocument instanceof Document) {
            ((Document)newDocument).addDocumentListener(this);
        }
        this.fireDocumentChanged(null);
    }

    @Override
    public void insertUpdate(@NotNull DocumentEvent e) {
        this.fireDocumentChanged(e);
    }

    @Override
    public void removeUpdate(@NotNull DocumentEvent e) {
        this.fireDocumentChanged(e);
    }

    @Override
    public void changedUpdate(@NotNull DocumentEvent e) {
        this.fireDocumentChanged(e);
    }

    protected void fireDocumentChanged(@Nullable DocumentEvent event) {
        JTextComponent component2 = (JTextComponent)this.textComponent.get();
        if (component2 != null) {
            this.documentChanged(component2, event);
        }
    }

    public abstract void documentChanged(@NotNull C var1, @Nullable DocumentEvent var2);
}

