/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.behavior;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.CompassDirection;
import com.alee.api.jdk.Function;
import com.alee.extended.behavior.Behavior;
import com.alee.utils.CoreSwingUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

public class ComponentResizeBehavior
extends MouseAdapter
implements Behavior,
SwingConstants {
    @NotNull
    protected final Component gripper;
    @Nullable
    protected final Component target;
    @NotNull
    protected Function<Point, CompassDirection> direction;
    protected transient boolean resizing = false;
    protected transient Point initialPoint = null;
    protected transient Rectangle initialBounds = null;
    protected transient CompassDirection currentDirection = null;
    protected transient Cursor initialCursor = null;

    public ComponentResizeBehavior(@NotNull Component gripper, @NotNull CompassDirection direction) {
        this(gripper, null, new SingleResizeDirection(direction));
    }

    public ComponentResizeBehavior(@NotNull Component gripper, @Nullable Component target, @NotNull CompassDirection direction) {
        this(gripper, target, new SingleResizeDirection(direction));
    }

    public ComponentResizeBehavior(@NotNull Component gripper, @NotNull Function<Point, CompassDirection> direction) {
        this(gripper, null, direction);
    }

    public ComponentResizeBehavior(@NotNull Component gripper, @Nullable Component target, @NotNull Function<Point, CompassDirection> direction) {
        this.gripper = gripper;
        this.target = target;
        this.direction = direction;
    }

    public void install() {
        this.gripper.addMouseListener(this);
        this.gripper.addMouseMotionListener(this);
    }

    public void uninstall() {
        this.gripper.removeMouseMotionListener(this);
        this.gripper.removeMouseListener(this);
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        int cursor = this.getCursor(e.getPoint());
        if (cursor != -1) {
            if (this.initialCursor == null) {
                this.initialCursor = e.getComponent().getCursor();
            }
            e.getComponent().setCursor(Cursor.getPredefinedCursor(cursor));
        } else if (this.initialCursor != null) {
            e.getComponent().setCursor(this.initialCursor);
            this.initialCursor = null;
        }
    }

    @Override
    public void mouseExited(@NotNull MouseEvent e) {
        if (!this.resizing && this.initialCursor != null) {
            e.getComponent().setCursor(this.initialCursor);
            this.initialCursor = null;
        }
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        CompassDirection d;
        if (!e.isConsumed() && SwingUtilities.isLeftMouseButton(e) && (d = this.direction.apply(e.getPoint())) != null) {
            this.resizing = true;
            Point los = CoreSwingUtils.locationOnScreen(e.getComponent());
            this.initialPoint = new Point(los.x + e.getX(), los.y + e.getY());
            this.initialBounds = this.getResized(e).getBounds();
            this.currentDirection = d;
            e.consume();
        }
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent e) {
        if (!e.isConsumed() && SwingUtilities.isLeftMouseButton(e) && this.resizing) {
            Component resized = this.getResized(e);
            if (this.currentDirection == CompassDirection.center) {
                Point mouse = CoreSwingUtils.getMouseLocation();
                int x = this.initialBounds.x + mouse.x - this.initialPoint.x;
                int y = this.initialBounds.y + mouse.y - this.initialPoint.y;
                Point location = new Point(x, y);
                resized.setLocation(location);
            } else {
                boolean undecorated;
                Dimension ms;
                if (resized instanceof JDialog) {
                    ms = ((JDialog)resized).getRootPane().getMinimumSize();
                    undecorated = ((JDialog)resized).isUndecorated();
                } else if (resized instanceof JFrame) {
                    ms = ((JFrame)resized).getRootPane().getMinimumSize();
                    undecorated = ((JFrame)resized).isUndecorated();
                } else if (resized instanceof JWindow) {
                    ms = ((JWindow)resized).getRootPane().getMinimumSize();
                    undecorated = true;
                } else {
                    ms = resized.getMinimumSize();
                    undecorated = true;
                }
                Point ml = CoreSwingUtils.getMouseLocation();
                Point shift = new Point(ml.x - this.initialPoint.x, ml.y - this.initialPoint.y);
                Rectangle newBounds = new Rectangle(this.initialBounds);
                switch (this.currentDirection) {
                    case northWest: {
                        newBounds.x += shift.x;
                        newBounds.width -= shift.x;
                        newBounds.y += shift.y;
                        newBounds.height -= shift.y;
                        break;
                    }
                    case north: {
                        newBounds.y += shift.y;
                        newBounds.height -= shift.y;
                        break;
                    }
                    case northEast: {
                        newBounds.width += shift.x;
                        newBounds.y += shift.y;
                        newBounds.height -= shift.y;
                        break;
                    }
                    case west: {
                        newBounds.x += shift.x;
                        newBounds.width -= shift.x;
                        break;
                    }
                    case east: {
                        newBounds.width += shift.x;
                        break;
                    }
                    case southWest: {
                        newBounds.x += shift.x;
                        newBounds.width -= shift.x;
                        newBounds.height += shift.y;
                        break;
                    }
                    case south: {
                        newBounds.height += shift.y;
                        break;
                    }
                    default: {
                        newBounds.width += shift.x;
                        newBounds.height += shift.y;
                    }
                }
                if (undecorated) {
                    int diff;
                    if (newBounds.width < ms.width) {
                        diff = ms.width - newBounds.width;
                        if (this.currentDirection == CompassDirection.northWest || this.currentDirection == CompassDirection.west || this.currentDirection == CompassDirection.southWest) {
                            newBounds.x -= diff;
                        }
                        newBounds.width += diff;
                    }
                    if (newBounds.height < ms.height) {
                        diff = ms.height - newBounds.height;
                        if (this.currentDirection == CompassDirection.northWest || this.currentDirection == CompassDirection.north || this.currentDirection == CompassDirection.northEast) {
                            newBounds.y -= diff;
                        }
                        newBounds.height += diff;
                    }
                }
                resized.setBounds(newBounds);
            }
            e.consume();
        }
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        if (!e.isConsumed() && SwingUtilities.isLeftMouseButton(e) && this.resizing) {
            int cursor = this.getCursor(e.getPoint());
            if (cursor != -1) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(cursor));
            } else if (this.initialCursor != null) {
                e.getComponent().setCursor(this.initialCursor);
                this.initialCursor = null;
            }
            this.resizing = false;
            this.initialPoint = null;
            this.initialBounds = null;
            this.currentDirection = null;
            e.consume();
        }
    }

    @NotNull
    protected Component getResized(@NotNull MouseEvent e) {
        return this.target != null ? this.target : CoreSwingUtils.getNonNullWindowAncestor(e.getComponent());
    }

    protected int getCursor(@NotNull Point position) {
        int cursor = -1;
        CompassDirection direction = this.direction.apply(position);
        if (direction != null) {
            switch (direction) {
                case northWest: {
                    cursor = 6;
                    break;
                }
                case north: {
                    cursor = 8;
                    break;
                }
                case northEast: {
                    cursor = 7;
                    break;
                }
                case west: {
                    cursor = 10;
                    break;
                }
                case east: {
                    cursor = 11;
                    break;
                }
                case southWest: {
                    cursor = 4;
                    break;
                }
                case south: {
                    cursor = 9;
                    break;
                }
                case southEast: {
                    cursor = 5;
                    break;
                }
                case center: {
                    cursor = 13;
                }
            }
        }
        return cursor;
    }

    public static class SingleResizeDirection
    implements Function<Point, CompassDirection> {
        @NotNull
        private final CompassDirection direction;

        public SingleResizeDirection(@NotNull CompassDirection direction) {
            this.direction = direction;
        }

        @Override
        @NotNull
        public CompassDirection apply(@NotNull Point point) {
            return this.direction;
        }
    }
}

